/*
 * Decompiled with CFR 0.152.
 */
package crosby.binary.file;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import crosby.binary.Fileformat;
import crosby.binary.file.FileBlock;
import crosby.binary.file.FileBlockBase;
import crosby.binary.file.FileFormatException;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class FileBlockPosition
extends FileBlockBase {
    protected int datasize;
    long data_offset;

    protected FileBlockPosition(String type, ByteString indexdata) {
        super(type, indexdata);
    }

    FileBlock parseData(byte[] buf) throws InvalidProtocolBufferException {
        FileBlock out = FileBlock.newInstance(this.type, null, this.indexdata);
        Fileformat.Blob blob = Fileformat.Blob.parseFrom(buf);
        if (blob.hasRaw()) {
            out.data = blob.getRaw();
        } else if (blob.hasZlibData()) {
            byte[] buf2 = new byte[blob.getRawSize()];
            Inflater decompresser = new Inflater();
            decompresser.setInput(blob.getZlibData().toByteArray());
            try {
                decompresser.inflate(buf2);
            }
            catch (DataFormatException e) {
                throw new UncheckedIOException(new FileFormatException(e));
            }
            assert (decompresser.finished());
            decompresser.end();
            out.data = ByteString.copyFrom(buf2);
        }
        return out;
    }

    public int getDatasize() {
        return this.datasize;
    }

    static FileBlockPosition newInstance(FileBlockBase base, long offset, int length) {
        FileBlockPosition out = new FileBlockPosition(base.type, base.indexdata);
        out.datasize = length;
        out.data_offset = offset;
        return out;
    }

    public FileBlock read(InputStream input) throws IOException {
        if (input instanceof FileInputStream) {
            ((FileInputStream)input).getChannel().position(this.data_offset);
            byte[] buf = new byte[this.getDatasize()];
            new DataInputStream(input).readFully(buf);
            return this.parseData(buf);
        }
        throw new IllegalArgumentException("Random access binary reads require seekability");
    }

    public ByteString serialize() {
        throw new UnsupportedOperationException("TODO");
    }

    static FileBlockPosition parseFrom(ByteString b) {
        throw new UnsupportedOperationException("TODO");
    }
}

