/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import livegps.LiveGpsData;
import livegps.LiveGpsLayer;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.preferences.CachingProperty;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.MapViewGraphics;
import org.openstreetmap.josm.gui.layer.gpx.GpxDrawHelper;
import org.openstreetmap.josm.spi.preferences.Config;

public class LiveGpsDrawHelper
extends GpxDrawHelper {
    private final LiveGpsLayer layer;
    private static final CachingProperty<Color> COLOR_POSITION = new NamedColorProperty("color.livegps.position", Color.RED).cached();
    private static final CachingProperty<Color> COLOR_POSITION_ESTIMATE = new NamedColorProperty("color.livegps.position_estimate", Color.CYAN).cached();

    public LiveGpsDrawHelper(LiveGpsLayer livegpslayer) {
        super((GpxLayer)livegpslayer);
        this.layer = livegpslayer;
    }

    public void paint(MapViewGraphics mvg) {
        super.paint(mvg);
        MapView mv = mvg.getMapView();
        Graphics2D g = mvg.getDefaultGraphics();
        WayPoint lastPoint = this.layer.lastPoint;
        LiveGpsData lastData = this.layer.lastData;
        if (lastPoint == null) {
            return;
        }
        Point screen = mv.getPoint(lastPoint.getCoor());
        int TriaHeight = Config.getPref().getInt("livegps.cursor_height", 20);
        int TriaWidth = Config.getPref().getInt("livegps.cursor_width", 10);
        int TriaThick = Config.getPref().getInt("livegps.cursor_thickness", 4);
        g.setColor((Color)COLOR_POSITION_ESTIMATE.get());
        double ppm = 100.0 / mv.getDist100Pixel();
        int w = (int)Math.round((double)lastData.getEpx() * ppm);
        int h = (int)Math.round((double)lastData.getEpy() * ppm);
        if (w > TriaWidth || h > TriaWidth) {
            int yo = screen.y - h / 2;
            int xo = screen.x - w / 2;
            g.drawOval(xo, yo, w, h);
        }
        int[] x = new int[4];
        int[] y = new int[4];
        float course = lastData.getCourse();
        float csin = (float)Math.sin(Math.toRadians(course));
        float ccos = (float)Math.cos(Math.toRadians(course));
        float csin120 = (float)Math.sin(Math.toRadians(course + 120.0f));
        float ccos120 = (float)Math.cos(Math.toRadians(course + 120.0f));
        float csin240 = (float)Math.sin(Math.toRadians(course + 240.0f));
        float ccos240 = (float)Math.cos(Math.toRadians(course + 240.0f));
        g.setColor((Color)COLOR_POSITION.get());
        int i = 0;
        while (i < TriaThick) {
            x[0] = screen.x + Math.round((float)TriaHeight * csin);
            y[0] = screen.y - Math.round((float)TriaHeight * ccos);
            x[1] = screen.x + Math.round((float)TriaWidth * csin120);
            y[1] = screen.y - Math.round((float)TriaWidth * ccos120);
            x[2] = screen.x;
            y[2] = screen.y;
            x[3] = screen.x + Math.round((float)TriaWidth * csin240);
            y[3] = screen.y - Math.round((float)TriaWidth * ccos240);
            g.drawPolygon(x, y, 4);
            ++i;
            --TriaHeight;
            --TriaWidth;
        }
    }
}

