/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.gui;

import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.NoSuchElementException;
import org.openstreetmap.josm.plugins.turnlanes.gui.GuiUtil;

abstract class Path {
    Path() {
    }

    public static Path create(double x, double y) {
        return new Start(x, y);
    }

    public Path lineTo(double x, double y, double length) {
        return new Line(this, x, y, length);
    }

    public Path curveTo(double r1, double r2, double a, double length) {
        return new Curve(this, r1, r2, a, length);
    }

    public abstract Path offset(double var1, double var3, double var5, double var7);

    abstract Path offsetInternal(double var1, double var3, double var5, double var7, double var9);

    public abstract double getLength();

    public abstract double getEndAngle();

    public abstract Point2D getStart();

    public abstract Point2D getEnd();

    public abstract SimplePathIterator getIterator();

    abstract SimplePathIterator getIteratorInternal(double var1);

    public abstract Path subpath(double var1, double var3);

    public Path subpath(double from, double to, boolean fixArgs) {
        if (fixArgs) {
            from = Math.min(Math.max(from, 0.0), this.getLength());
            to = Math.min(Math.max(to, 0.0), this.getLength());
        }
        return this.subpath(from, to);
    }

    public abstract Point2D getPoint(double var1);

    public Point2D getPoint(double offset, boolean fixArgs) {
        if (fixArgs) {
            offset = Math.min(Math.max(offset, 0.0), this.getLength());
        }
        return this.getPoint(offset);
    }

    private static class Start
    extends Path {
        private final double x;
        private final double y;
        private final double endAngle;

        Start(double x, double y, double endAngle) {
            this.x = x;
            this.y = y;
            this.endAngle = endAngle;
        }

        Start(double x, double y) {
            this(x, y, Double.NaN);
        }

        @Override
        public Point2D getStart() {
            return new Point2D.Double(this.x, this.y);
        }

        @Override
        public Point2D getEnd() {
            return new Point2D.Double(this.x, this.y);
        }

        @Override
        public double getEndAngle() {
            if (Double.isNaN(this.endAngle)) {
                throw new UnsupportedOperationException();
            }
            return this.endAngle;
        }

        @Override
        public double getLength() {
            return 0.0;
        }

        @Override
        public Path offset(double ws, double m1, double m2, double we) {
            throw new UnsupportedOperationException();
        }

        @Override
        Path offsetInternal(double ws, double m1, double m2, double we, double endAngle) {
            Point2D offset = GuiUtil.relativePoint(this.getStart(), ws, endAngle + 1.5707963267948966);
            return new Start(offset.getX(), offset.getY(), endAngle);
        }

        @Override
        public SimplePathIterator getIterator() {
            return new SimplePathIterator(0, this.x, this.y, 0.0, 0.0, 0.0, 0.0);
        }

        @Override
        public Path subpath(double from, double to) {
            if (from > to) {
                throw new IllegalArgumentException("from > to");
            }
            if (from < 0.0) {
                throw new IllegalArgumentException("from < 0");
            }
            return this;
        }

        @Override
        public Point2D getPoint(double offset) {
            if (offset == 0.0) {
                return this.getEnd();
            }
            throw new IllegalArgumentException(Double.toString(offset));
        }

        @Override
        SimplePathIterator getIteratorInternal(double endAngle) {
            return new SimplePathIterator(0, this.x, this.y, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static class Curve
    extends Path {
        private final Path previous;
        private final double height;
        private final double centerX;
        private final double centerY;
        private final double centerToFromAngle;
        private final double endX;
        private final double endY;
        private final double fromAngle;
        private final double fromRadius;
        private final double toRadius;
        private final double angle;
        private final double length;

        private Curve(Path previous, double r1, double r2, double a, double length, double fromAngle) {
            this.previous = previous;
            this.fromAngle = fromAngle;
            this.fromRadius = r1;
            this.toRadius = r2;
            this.angle = a;
            this.length = length;
            Point2D from = previous.getEnd();
            this.centerToFromAngle = fromAngle - Math.signum(a) * Math.PI / 2.0;
            Point2D center = GuiUtil.relativePoint(from, r1, this.centerToFromAngle + Math.PI);
            double toAngle = this.centerToFromAngle + a;
            this.endX = center.getX() + r2 * Math.cos(toAngle);
            this.endY = center.getY() - r2 * Math.sin(toAngle);
            this.centerX = center.getX();
            this.centerY = center.getY();
            double y = new Line2D.Double(center, from).ptLineDist(this.endX, this.endY);
            this.height = y / Math.sin(this.angle);
        }

        Curve(Path previous, double r1, double r2, double a, double length) {
            this(previous, r1, r2, a, length, previous.getEndAngle());
        }

        @Override
        public Point2D getStart() {
            return this.previous.getStart();
        }

        @Override
        public Point2D getEnd() {
            return new Point2D.Double(this.endX, this.endY);
        }

        @Override
        public double getEndAngle() {
            return this.fromAngle + this.angle;
        }

        @Override
        public double getLength() {
            return this.previous.getLength() + this.length;
        }

        @Override
        public Path offset(double ws, double m1, double m2, double we) {
            return this.offsetInternal(ws, m1, m2, we, this.previous.getEndAngle() + this.angle);
        }

        @Override
        Path offsetInternal(double ws, double m1, double m2, double we, double endAngle) {
            double PL = this.previous.getLength();
            double ML = PL + this.length;
            Path prev = this.previous.offsetInternal(ws, m1, m2, we, this.fromAngle);
            if (ML <= m1) {
                return this.simpleOffset(prev, ws);
            }
            if (m2 <= PL) {
                return this.simpleOffset(prev, we);
            }
            double s = Math.signum(this.angle);
            if (PL < m1 && m2 < ML) {
                double l1 = m1 - PL;
                double a1 = this.angle(l1);
                double r1 = this.radius(a1) - s * ws;
                Curve c1 = new Curve(prev, this.fromRadius - ws, r1, a1, l1, this.fromAngle);
                double l2 = m2 - m1;
                double a2 = this.angle(l2);
                double r2 = this.radius(a2) - s * we;
                Curve c2 = new Curve(c1, r1, r2, a2 - a1, l2);
                return new Curve(c2, r2, this.toRadius - s * we, this.angle - a2, ML - m2);
            }
            if (PL < m1) {
                double l1 = m1 - PL;
                double a1 = this.angle(l1);
                double r1 = this.radius(a1) - s * ws;
                Curve c1 = new Curve(prev, this.fromRadius - s * ws, r1, a1, l1, this.fromAngle);
                double w = ws + (ML - m1) * (we - ws) / (m2 - m1);
                return new Curve(c1, r1, this.toRadius - s * w, this.angle - a1, ML - m1);
            }
            if (m2 < ML) {
                double w = ws + (PL - m1) * (we - ws) / (m2 - m1);
                double l2 = m2 - PL;
                double a2 = this.angle(l2);
                double r2 = this.radius(a2) - s * we;
                Curve c2 = new Curve(prev, this.fromRadius - s * w, r2, a2, l2, this.fromAngle);
                return new Curve(c2, r2, this.toRadius - s * we, this.angle - a2, ML - m2);
            }
            double w1 = ws + (PL - m1) * (we - ws) / (m2 - m1);
            double w2 = we - (m2 - ML) * (we - ws) / (m2 - m1);
            return new Curve(prev, this.fromRadius - s * w1, this.toRadius - s * w2, this.angle, this.length, this.fromAngle);
        }

        private double angle(double l) {
            return l * this.angle / this.length;
        }

        private double radius(double a) {
            return Math.hypot(this.fromRadius * Math.cos(a), this.height * Math.sin(a));
        }

        private Path simpleOffset(Path prev, double w) {
            double s = Math.signum(this.angle);
            return new Curve(prev, this.fromRadius - s * w, this.toRadius - s * w, this.angle, this.length, this.fromAngle);
        }

        @Override
        public SimplePathIterator getIterator() {
            return this.getIteratorInternal(this.previous.getEndAngle() + this.angle);
        }

        @Override
        public Path subpath(double from, double to) {
            double PL = this.previous.getLength();
            double ML = PL + this.length;
            if (from > ML) {
                throw new IllegalArgumentException("from > length");
            }
            if (to > ML) {
                throw new IllegalArgumentException("to > length");
            }
            if (to < PL) {
                return this.previous.subpath(from, to);
            }
            double toA = to < ML ? this.angle(to - PL) : this.angle;
            double toR = to < ML ? this.radius(toA) : this.toRadius;
            double fromA = from > PL ? this.angle(from - PL) : 0.0;
            double fromR = from > PL ? this.radius(fromA) : this.fromRadius;
            double a = toA - fromA;
            double l = Math.min(ML, to) - Math.max(PL, from);
            if (from >= PL) {
                Point2D start = this.getPoint(from);
                double fa = this.fromAngle + fromA;
                return new Curve(new Start(start.getX(), start.getY(), fa), fromR, toR, a, l, fa);
            }
            return new Curve(this.previous.subpath(from, PL), fromR, toR, a, l, this.fromAngle);
        }

        @Override
        public Point2D getPoint(double offset) {
            double PL = this.previous.getLength();
            double ML = PL + this.length;
            if (offset <= ML && offset >= PL) {
                double a = Math.abs(this.angle(offset - PL));
                double w = this.fromRadius * Math.cos(a);
                double h = -this.height * Math.sin(a);
                double r = this.centerToFromAngle;
                double x = w * Math.cos(r) + h * Math.sin(r);
                double y = -w * Math.sin(r) + h * Math.cos(r);
                return new Point2D.Double(this.centerX + x, this.centerY + y);
            }
            return this.previous.getPoint(offset);
        }

        @Override
        SimplePathIterator getIteratorInternal(double endAngle) {
            Point2D cp1 = GuiUtil.relativePoint(this.previous.getEnd(), GuiUtil.cpf(this.angle, this.fromRadius), this.previous.getEndAngle());
            Point2D cp2 = GuiUtil.relativePoint(this.getEnd(), GuiUtil.cpf(this.angle, this.toRadius), endAngle + Math.PI);
            return new SimplePathIterator(this.previous.getIteratorInternal(this.getEndAngle()), 3, cp1.getX(), cp1.getY(), cp2.getX(), cp2.getY(), this.endX, this.endY);
        }
    }

    private static final class Line
    extends Path {
        private final Path previous;
        private final double endX;
        private final double endY;
        private final double angle;
        private final double length;

        Line(Path previous, double x, double y, double length) {
            this.previous = previous;
            this.endX = x;
            this.endY = y;
            this.angle = GuiUtil.angle(previous.getEnd(), this.getEnd());
            this.length = length;
        }

        @Override
        public Point2D getStart() {
            return this.previous.getStart();
        }

        @Override
        public Point2D getEnd() {
            return new Point2D.Double(this.endX, this.endY);
        }

        @Override
        public double getEndAngle() {
            return this.angle;
        }

        @Override
        public double getLength() {
            return this.previous.getLength() + this.length;
        }

        @Override
        public Path offset(double ws, double m1, double m2, double we) {
            return this.offsetInternal(ws, m1, m2, we, this.angle);
        }

        @Override
        Path offsetInternal(double ws, double m1, double m2, double we, double endAngle) {
            Point2D m2o;
            Point2D to;
            double PL = this.previous.getLength();
            double ML = PL + this.length;
            Path prev = this.previous.offsetInternal(ws, m1, m2, we, this.angle);
            double wStart = PL <= m1 ? ws : (m2 <= PL ? we : ws + (PL - m1) * (we - ws) / (m2 - m1));
            Point2D from = prev.getEnd();
            if (Math.abs(GuiUtil.minAngleDiff(this.angle, GuiUtil.angle(from, to = this.offsetEnd(wStart, endAngle)))) > 0.031415926535897934) {
                return this.previous.offsetInternal(ws, m1, m2, we, endAngle);
            }
            if (ML <= m1) {
                return this.simpleOffset(prev, ws, endAngle);
            }
            if (m2 <= PL) {
                return this.simpleOffset(prev, we, endAngle);
            }
            double LL = from.distance(to);
            Point2D m1o = PL <= m1 ? GuiUtil.relativePoint(prev.getEnd(), LL * (m1 - PL) / this.length, this.angle) : null;
            Point2D m2t = m2 <= ML ? GuiUtil.relativePoint(this.getEnd(), LL * (ML - m2) / this.length, this.angle + Math.PI) : null;
            Point2D point2D = m2o = m2t == null ? null : GuiUtil.relativePoint(m2t, we, (this.angle + endAngle - Math.PI) / 2.0);
            if (m1o != null && m2o != null) {
                Line l1 = new Line(prev, m1o.getX(), m1o.getY(), m1 - PL);
                Line l2 = new Line(l1, m2o.getX(), m2o.getY(), m2 - m1);
                Point2D end = this.offsetEnd(we, endAngle);
                return new Line(l2, end.getX(), end.getY(), ML - m2);
            }
            if (m1o != null) {
                Line l1 = new Line(prev, m1o.getX(), m1o.getY(), m1 - PL);
                double w = ws + (ML - m1) * (we - ws) / (m2 - m1);
                Point2D end = this.offsetEnd(w, endAngle);
                return new Line(l1, end.getX(), end.getY(), ML - m1);
            }
            if (m2o != null) {
                Line l2 = new Line(prev, m2o.getX(), m2o.getY(), m2 - PL);
                Point2D end = this.offsetEnd(we, endAngle);
                return new Line(l2, end.getX(), end.getY(), ML - m2);
            }
            double w = ws + (PL - m1 + this.length) * (we - ws) / (m2 - m1);
            Point2D end = this.offsetEnd(w, endAngle);
            return new Line(prev, end.getX(), end.getY(), this.length);
        }

        private Path simpleOffset(Path prev, double w, double endAngle) {
            Point2D offset = this.offsetEnd(w, endAngle);
            return new Line(prev, offset.getX(), offset.getY(), this.length);
        }

        private Point2D offsetEnd(double w, double endAngle) {
            double da2 = GuiUtil.minAngleDiff(this.angle, endAngle) / 2.0;
            double hypotenuse = w / Math.cos(da2);
            return GuiUtil.relativePoint(this.getEnd(), hypotenuse, this.angle + 1.5707963267948966 + da2);
        }

        @Override
        public SimplePathIterator getIterator() {
            return new SimplePathIterator(this.previous.getIteratorInternal(this.angle), 1, this.endX, this.endY, 0.0, 0.0, 0.0, 0.0);
        }

        @Override
        public Path subpath(double from, double to) {
            double PL = this.previous.getLength();
            double ML = PL + this.length;
            if (from > ML) {
                throw new IllegalArgumentException("from > length");
            }
            if (to > ML) {
                throw new IllegalArgumentException("to > length");
            }
            if (to < PL) {
                return this.previous.subpath(from, to);
            }
            Point2D end = to < ML ? this.getPoint(to) : new Point2D.Double(this.endX, this.endY);
            double EL = Math.min(ML, to);
            if (PL <= from) {
                Point2D start = this.getPoint(from);
                return new Line(new Start(start.getX(), start.getY(), this.angle), end.getX(), end.getY(), EL - from);
            }
            return new Line(this.previous.subpath(from, PL), end.getX(), end.getY(), EL - PL);
        }

        @Override
        public Point2D getPoint(double offset) {
            double PL = this.previous.getLength();
            double ML = PL + this.length;
            if (offset > ML) {
                throw new IllegalArgumentException("offset > length");
            }
            if (offset <= ML && offset >= PL) {
                double LL = this.previous.getEnd().distance(this.getEnd());
                return GuiUtil.relativePoint(this.getEnd(), LL * (ML - offset) / this.length, this.angle + Math.PI);
            }
            return this.previous.getPoint(offset);
        }

        @Override
        SimplePathIterator getIteratorInternal(double endAngle) {
            return this.getIterator();
        }
    }

    private static final class SimplePathIterator
    implements PathIterator {
        private final SimplePathIterator previous;
        private final int type;
        private final double[] coords;
        private boolean done = false;

        SimplePathIterator(SimplePathIterator previous, int type, double ... coords) {
            this.previous = previous;
            this.type = type;
            this.coords = coords;
        }

        SimplePathIterator(int type, double ... coords) {
            this(null, type, coords);
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public void next() {
            if (this.previous != null && !this.previous.isDone()) {
                this.previous.next();
            } else {
                this.done = true;
            }
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.previous != null && !this.previous.isDone()) {
                return this.previous.currentSegment(coords);
            }
            if (this.done) {
                throw new NoSuchElementException("Iterator is already done.");
            }
            for (int i = 0; i < 6; ++i) {
                coords[i] = (float)this.coords[i];
            }
            return this.type;
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.previous != null && !this.previous.isDone()) {
                return this.previous.currentSegment(coords);
            }
            if (this.done) {
                throw new NoSuchElementException("Iterator is already done.");
            }
            for (int i = 0; i < 6; ++i) {
                coords[i] = this.coords[i];
            }
            return this.type;
        }
    }
}

