/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.turnrestrictions.TurnRestrictionBuilder;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditor;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditorManager;
import org.openstreetmap.josm.plugins.turnrestrictions.list.TurnRestrictionCellRenderer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TurnRestrictionSelectionPopupPanel
extends JPanel {
    private Popup parentPopup;
    private JButton btnNew;
    private JTable tblTurnRestrictions;
    private OsmDataLayer layer;

    public static Collection<Relation> getTurnRestrictionsParticipatingIn(Collection<OsmPrimitive> primitives) {
        HashSet<Relation> ret = new HashSet<Relation>();
        if (primitives == null) {
            return ret;
        }
        for (OsmPrimitive p : primitives) {
            if (p == null || p.isDeleted() || !p.isVisible()) continue;
            for (OsmPrimitive parent : p.getReferrers()) {
                String type;
                if (!(parent instanceof Relation) || (type = parent.get("type")) == null || !type.equals("restriction") || parent.isDeleted() || !parent.isVisible()) continue;
                ret.add((Relation)parent);
            }
        }
        return ret;
    }

    protected void registerEditShortcuts(Collection<Relation> editCandiates) {
        for (int i = 1; i <= Math.min(editCandiates.size(), 9); ++i) {
            int vkey = 0;
            switch (i) {
                case 1: {
                    vkey = 49;
                    break;
                }
                case 2: {
                    vkey = 50;
                    break;
                }
                case 3: {
                    vkey = 51;
                    break;
                }
                case 4: {
                    vkey = 52;
                    break;
                }
                case 5: {
                    vkey = 53;
                    break;
                }
                case 6: {
                    vkey = 54;
                    break;
                }
                case 7: {
                    vkey = 55;
                    break;
                }
                case 8: {
                    vkey = 56;
                    break;
                }
                case 9: {
                    vkey = 57;
                }
            }
            this.registerKeyboardAction(new EditTurnRestrictionAction(i - 1), KeyStroke.getKeyStroke(vkey, 0), 1);
        }
    }

    protected JPanel buildTurnRestrictionTablePanel(Collection<Relation> editCandiates) {
        this.tblTurnRestrictions = new JTable(new TurnRestrictionTableModel(editCandiates), new TurnRestrictionTableColumnModel());
        this.tblTurnRestrictions.setColumnSelectionAllowed(false);
        this.tblTurnRestrictions.getSelectionModel().setSelectionMode(1);
        TurnRestrictionCellRenderer renderer = new TurnRestrictionCellRenderer();
        this.tblTurnRestrictions.setRowHeight((int)renderer.getPreferredSize().getHeight());
        JScrollPane pane = new JScrollPane(this.tblTurnRestrictions);
        pane.setHorizontalScrollBarPolicy(31);
        pane.setVerticalScrollBarPolicy(20);
        this.tblTurnRestrictions.setTableHeader(null);
        pane.setColumnHeaderView(null);
        EditSelectedTurnRestrictionAction action = new EditSelectedTurnRestrictionAction();
        this.tblTurnRestrictions.addMouseListener(action);
        this.tblTurnRestrictions.registerKeyboardAction(action, KeyStroke.getKeyStroke(10, 0), 0);
        this.tblTurnRestrictions.addFocusListener(new FocusHandler());
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)pane, "Center");
        pnl.setBackground(UIManager.getColor("Table.background"));
        pane.setBackground(UIManager.getColor("Table.background"));
        return pnl;
    }

    protected void build(Collection<Relation> editCandiates) {
        this.setLayout(new BorderLayout());
        this.btnNew = new JButton(new NewAction());
        this.add((Component)this.btnNew, "North");
        this.btnNew.setFocusable(true);
        this.btnNew.registerKeyboardAction(this.btnNew.getAction(), KeyStroke.getKeyStroke(10, 0), 0);
        this.registerKeyboardAction(new CloseAction(), KeyStroke.getKeyStroke(27, 0), 1);
        this.registerKeyboardAction(this.btnNew.getAction(), KeyStroke.getKeyStroke(78, 0), 1);
        this.btnNew.addFocusListener(new FocusHandler());
        if (editCandiates != null && !editCandiates.isEmpty()) {
            this.add((Component)this.buildTurnRestrictionTablePanel(editCandiates), "Center");
            this.registerEditShortcuts(editCandiates);
        }
        this.setBackground(UIManager.getColor("Table.background"));
    }

    public TurnRestrictionSelectionPopupPanel(OsmDataLayer layer) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)layer, (String)"layer");
        this.layer = layer;
        this.build(TurnRestrictionSelectionPopupPanel.getTurnRestrictionsParticipatingIn(layer.data.getSelected()));
    }

    public TurnRestrictionSelectionPopupPanel(OsmDataLayer layer, Collection<Relation> editCandidates) {
        CheckParameterUtil.ensureParameterNotNull((Object)layer, (String)"layer");
        this.layer = layer;
        this.build(editCandidates);
    }

    public void launch() {
        PointerInfo info = MouseInfo.getPointerInfo();
        Point pt = info.getLocation();
        this.parentPopup = PopupFactory.getSharedInstance().getPopup((Component)MainApplication.getMap().mapView, this, pt.x, pt.y);
        this.parentPopup.show();
        this.btnNew.requestFocusInWindow();
    }

    @Override
    public Dimension getPreferredSize() {
        int bestheight = (int)this.btnNew.getPreferredSize().getHeight() + Math.min(2, this.tblTurnRestrictions.getRowCount()) * this.tblTurnRestrictions.getRowHeight() + 5;
        return new Dimension(300, bestheight);
    }

    private class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!(e.getOppositeComponent() != null && SwingUtilities.isDescendingFrom(e.getOppositeComponent(), TurnRestrictionSelectionPopupPanel.this) || TurnRestrictionSelectionPopupPanel.this.parentPopup == null)) {
                TurnRestrictionSelectionPopupPanel.this.parentPopup.hide();
            }
        }
    }

    private static class TurnRestrictionTableColumnModel
    extends DefaultTableColumnModel {
        TurnRestrictionTableColumnModel() {
            TableColumn col = new TableColumn(0);
            col.setResizable(false);
            col.setWidth(50);
            this.addColumn(col);
            col = new TableColumn(1);
            col.setResizable(false);
            col.setPreferredWidth(400);
            col.setCellRenderer(new TurnRestrictionCellRenderer());
            this.addColumn(col);
        }
    }

    private static class TurnRestrictionTableModel
    extends AbstractTableModel {
        private final ArrayList<Relation> turnrestrictions = new ArrayList();

        TurnRestrictionTableModel(Collection<Relation> turnrestrictions) {
            this.turnrestrictions.clear();
            if (turnrestrictions != null) {
                this.turnrestrictions.addAll(turnrestrictions);
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.turnrestrictions.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (rowIndex <= 8) {
                        return Integer.toString(rowIndex + 1);
                    }
                    return "";
                }
                case 1: {
                    return this.turnrestrictions.get(rowIndex);
                }
            }
            return null;
        }
    }

    private class CloseAction
    extends AbstractAction {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TurnRestrictionSelectionPopupPanel.this.parentPopup != null) {
                TurnRestrictionSelectionPopupPanel.this.parentPopup.hide();
            }
        }
    }

    private class EditSelectedTurnRestrictionAction
    extends AbstractEditTurnRestrictionAction
    implements MouseListener {
        private EditSelectedTurnRestrictionAction() {
        }

        public void editTurnRestrictionAtRow(int row) {
            if (row < 0) {
                return;
            }
            Relation tr = (Relation)TurnRestrictionSelectionPopupPanel.this.tblTurnRestrictions.getModel().getValueAt(row, 1);
            this.launchEditor(tr);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TurnRestrictionSelectionPopupPanel.this.tblTurnRestrictions.getSelectedRow();
            this.editTurnRestrictionAtRow(row);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e) || e.getClickCount() < 2) {
                return;
            }
            int row = TurnRestrictionSelectionPopupPanel.this.tblTurnRestrictions.rowAtPoint(e.getPoint());
            if (row < 0) {
                return;
            }
            this.editTurnRestrictionAtRow(row);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class EditTurnRestrictionAction
    extends AbstractEditTurnRestrictionAction {
        private int idx;

        EditTurnRestrictionAction(int idx) {
            this.idx = idx;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Relation tr = (Relation)TurnRestrictionSelectionPopupPanel.this.tblTurnRestrictions.getModel().getValueAt(this.idx, 1);
            this.launchEditor(tr);
        }
    }

    private abstract class AbstractEditTurnRestrictionAction
    extends AbstractAction {
        private AbstractEditTurnRestrictionAction() {
        }

        protected void launchEditor(Relation tr) {
            TurnRestrictionEditorManager manager = TurnRestrictionEditorManager.getInstance();
            TurnRestrictionEditor editor = manager.getEditorForRelation(TurnRestrictionSelectionPopupPanel.this.layer, tr);
            if (TurnRestrictionSelectionPopupPanel.this.parentPopup != null) {
                TurnRestrictionSelectionPopupPanel.this.parentPopup.hide();
            }
            if (editor != null) {
                editor.setVisible(true);
                editor.toFront();
            } else {
                editor = new TurnRestrictionEditor((Component)MainApplication.getMap().mapView, TurnRestrictionSelectionPopupPanel.this.layer, tr);
                manager.positionOnScreen(editor);
                manager.register(TurnRestrictionSelectionPopupPanel.this.layer, tr, editor);
                editor.setVisible(true);
            }
        }
    }

    private class NewAction
    extends AbstractAction {
        NewAction() {
            this.putValue("Name", I18n.tr((String)"Create new turn restriction", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Launch the turn restriction editor to create a new turn restriction", (Object[])new Object[0]));
            new ImageProvider("new").getResource().attachImageIcon((AbstractAction)this);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Relation tr = new TurnRestrictionBuilder().buildFromSelection(TurnRestrictionSelectionPopupPanel.this.layer);
            TurnRestrictionEditor editor = new TurnRestrictionEditor((Component)MainApplication.getMap().mapView, TurnRestrictionSelectionPopupPanel.this.layer, tr);
            TurnRestrictionEditorManager.getInstance().positionOnScreen(editor);
            TurnRestrictionEditorManager.getInstance().register(TurnRestrictionSelectionPopupPanel.this.layer, tr, editor);
            if (TurnRestrictionSelectionPopupPanel.this.parentPopup != null) {
                TurnRestrictionSelectionPopupPanel.this.parentPopup.hide();
            }
            editor.setVisible(true);
        }
    }
}

