/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.poi.poifs.common.POIFSBigBlockSize;
import org.apache.poi.poifs.common.POIFSConstants;
import org.apache.poi.poifs.property.DocumentProperty;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.storage.BlockWritable;
import org.apache.poi.poifs.storage.DataInputBlock;
import org.apache.poi.poifs.storage.DocumentBlock;
import org.apache.poi.poifs.storage.ListManagedBlock;
import org.apache.poi.poifs.storage.RawDataBlock;
import org.apache.poi.poifs.storage.SmallDocumentBlock;

public final class POIFSDocument {
    private static final DocumentBlock[] EMPTY_BIG_BLOCK_ARRAY = new DocumentBlock[0];
    private static final SmallDocumentBlock[] EMPTY_SMALL_BLOCK_ARRAY = new SmallDocumentBlock[0];
    private DocumentProperty _property;
    private int _size;
    private SmallBlockStore _small_store;
    private BigBlockStore _big_store;

    private static DocumentBlock[] convertRawBlocksToBigBlocks(ListManagedBlock[] listManagedBlockArray) throws IOException {
        DocumentBlock[] documentBlockArray = new DocumentBlock[listManagedBlockArray.length];
        for (int i = 0; i < documentBlockArray.length; ++i) {
            documentBlockArray[i] = new DocumentBlock((RawDataBlock)listManagedBlockArray[i]);
        }
        return documentBlockArray;
    }

    private static SmallDocumentBlock[] convertRawBlocksToSmallBlocks(ListManagedBlock[] listManagedBlockArray) {
        if (listManagedBlockArray instanceof SmallDocumentBlock[]) {
            return (SmallDocumentBlock[])listManagedBlockArray;
        }
        SmallDocumentBlock[] smallDocumentBlockArray = new SmallDocumentBlock[listManagedBlockArray.length];
        System.arraycopy(listManagedBlockArray, 0, smallDocumentBlockArray, 0, listManagedBlockArray.length);
        return smallDocumentBlockArray;
    }

    public POIFSDocument(String string, POIFSBigBlockSize pOIFSBigBlockSize, ListManagedBlock[] listManagedBlockArray, int n) throws IOException {
        this._size = n;
        this._property = new DocumentProperty(string, this._size);
        this._property.setDocument(this);
        if (Property.isSmall(this._size)) {
            this._big_store = new BigBlockStore(pOIFSBigBlockSize, EMPTY_BIG_BLOCK_ARRAY);
            this._small_store = new SmallBlockStore(pOIFSBigBlockSize, POIFSDocument.convertRawBlocksToSmallBlocks(listManagedBlockArray));
        } else {
            this._big_store = new BigBlockStore(pOIFSBigBlockSize, POIFSDocument.convertRawBlocksToBigBlocks(listManagedBlockArray));
            this._small_store = new SmallBlockStore(pOIFSBigBlockSize, EMPTY_SMALL_BLOCK_ARRAY);
        }
    }

    public POIFSDocument(String string, ListManagedBlock[] listManagedBlockArray, int n) throws IOException {
        this(string, POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS, listManagedBlockArray, n);
    }

    public POIFSDocument(String string, POIFSBigBlockSize pOIFSBigBlockSize, InputStream inputStream) throws IOException {
        BlockWritable[] blockWritableArray;
        ArrayList<BlockWritable[]> arrayList = new ArrayList<BlockWritable[]>();
        this._size = 0;
        do {
            int n;
            if ((n = (blockWritableArray = new DocumentBlock(inputStream, pOIFSBigBlockSize)).size()) <= 0) continue;
            arrayList.add(blockWritableArray);
            this._size += n;
        } while (!blockWritableArray.partiallyRead());
        blockWritableArray = arrayList.toArray(new DocumentBlock[arrayList.size()]);
        this._big_store = new BigBlockStore(pOIFSBigBlockSize, (DocumentBlock[])blockWritableArray);
        this._property = new DocumentProperty(string, this._size);
        this._property.setDocument(this);
        if (this._property.shouldUseSmallBlocks()) {
            this._small_store = new SmallBlockStore(pOIFSBigBlockSize, SmallDocumentBlock.convert(pOIFSBigBlockSize, blockWritableArray, this._size));
            this._big_store = new BigBlockStore(pOIFSBigBlockSize, new DocumentBlock[0]);
        } else {
            this._small_store = new SmallBlockStore(pOIFSBigBlockSize, EMPTY_SMALL_BLOCK_ARRAY);
        }
    }

    public POIFSDocument(String string, InputStream inputStream) throws IOException {
        this(string, POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS, inputStream);
    }

    public int getSize() {
        return this._size;
    }

    DataInputBlock getDataInputBlock(int n) {
        if (n >= this._size) {
            if (n > this._size) {
                throw new RuntimeException("Request for Offset " + n + " doc size is " + this._size);
            }
            return null;
        }
        if (this._property.shouldUseSmallBlocks()) {
            return SmallDocumentBlock.getDataInputBlock(this._small_store.getBlocks(), n);
        }
        return DocumentBlock.getDataInputBlock(this._big_store.getBlocks(), n);
    }

    DocumentProperty getDocumentProperty() {
        return this._property;
    }

    private static final class BigBlockStore {
        private DocumentBlock[] bigBlocks;

        BigBlockStore(POIFSBigBlockSize pOIFSBigBlockSize, DocumentBlock[] documentBlockArray) {
            this.bigBlocks = (DocumentBlock[])documentBlockArray.clone();
        }

        DocumentBlock[] getBlocks() {
            return this.bigBlocks;
        }
    }

    private static final class SmallBlockStore {
        private SmallDocumentBlock[] _smallBlocks;
        private final int _size;
        private final POIFSBigBlockSize _bigBlockSize;

        SmallBlockStore(POIFSBigBlockSize pOIFSBigBlockSize, SmallDocumentBlock[] smallDocumentBlockArray) {
            this._bigBlockSize = pOIFSBigBlockSize;
            this._smallBlocks = (SmallDocumentBlock[])smallDocumentBlockArray.clone();
            this._size = -1;
        }

        boolean isValid() {
            return this._smallBlocks.length > 0;
        }

        SmallDocumentBlock[] getBlocks() {
            if (this.isValid()) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this._size);
                this._smallBlocks = SmallDocumentBlock.convert(this._bigBlockSize, byteArrayOutputStream.toByteArray(), this._size);
            }
            return this._smallBlocks;
        }
    }
}

