/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.npm;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.netbeans.spi.keyring.KeyringProvider;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.plugins.npm.NPMPlugin;
import org.openstreetmap.josm.plugins.npm.NPMType;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformManager;

public class InitializationWizard
extends JDialog {
    protected boolean canceled;
    protected JButton btnCancel;
    protected JButton btnBack;
    protected JButton btnNext;
    protected Action nextAction;
    protected Action finishAction;
    protected JPanel cardPanel;
    List<WizardPanel> panels = new ArrayList<WizardPanel>();
    int panelIndex;
    private CardLayout cardLayout;
    private static final String NPM = "Native Password Manager Plugin: ";

    public InitializationWizard() {
        super((Window)JOptionPane.getFrameForComponent((Component)MainApplication.getMainFrame()), I18n.tr((String)"Native password manager plugin", (Object[])new Object[0]), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
        NPMType npm = InitializationWizard.detectNativePasswordManager();
        AbstractWizardPanel firstPanel = npm == null ? new NothingFoundPanel() : new SelectionPanel(npm, this);
        this.panelIndex = 0;
        this.panels.add(firstPanel);
        this.cardPanel.add((Component)firstPanel.getPanel(), firstPanel.getId());
        this.updateButtons();
    }

    private void build() {
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        this.addWindowListener(new WindowEventHandler());
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", new CancelAction());
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        c.add((Component)this.cardPanel, "Center");
        this.nextAction = new NextAction();
        this.finishAction = new FinishAction();
        this.btnCancel = new JButton(new CancelAction());
        this.btnBack = new JButton(new BackAction());
        this.btnNext = new JButton(this.nextAction);
        Box buttonsBox = new Box(0);
        buttonsBox.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        buttonsBox.add(this.btnCancel);
        buttonsBox.add(Box.createHorizontalStrut(30));
        buttonsBox.add(this.btnBack);
        buttonsBox.add(Box.createHorizontalStrut(10));
        buttonsBox.add(this.btnNext);
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        buttonsPanel.add((Component)new JSeparator(), "North");
        buttonsPanel.add((Component)buttonsBox, "East");
        c.add((Component)buttonsPanel, "South");
    }

    private void updateButtons() {
        this.btnBack.setEnabled(this.panelIndex > 0);
        if (this.panels.get(this.panelIndex).isLast()) {
            this.btnNext.setAction(this.finishAction);
        } else {
            this.btnNext.setAction(this.nextAction);
        }
    }

    private static NPMType detectNativePasswordManager() {
        NPMType[] potentialManagers;
        if (PlatformManager.isPlatformWindows()) {
            potentialManagers = new NPMType[]{NPMType.CRYPT32};
        } else if (PlatformManager.isPlatformOsx()) {
            potentialManagers = new NPMType[]{NPMType.KEYCHAIN};
        } else if (PlatformManager.isPlatformUnixoid()) {
            potentialManagers = new NPMType[]{NPMType.GNOME_KEYRING, NPMType.KWALLET};
        } else {
            throw new AssertionError();
        }
        for (NPMType manager : potentialManagers) {
            Logging.info((String)("Native Password Manager Plugin: Looking for " + manager.getName()));
            KeyringProvider provider = manager.getProvider();
            if (!provider.enabled()) continue;
            Logging.info((String)("Native Password Manager Plugin: Found " + manager.getName()));
            return manager;
        }
        return null;
    }

    private static boolean hasUnprotectedCedentials() {
        return Config.getPref().get("osm-server.username", null) != null || Config.getPref().get("osm-server.password", null) != null || Config.getPref().get("proxy.user", null) != null || Config.getPref().get("proxy.pass", null) != null || Config.getPref().get("oauth.access-token.key", null) != null || Config.getPref().get("oauth.access-token.secret", null) != null;
    }

    public void showDialog() {
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow((Component)this.getParent(), (Dimension)new Dimension(600, 400))).applySafe((Window)this);
        } else if (this.isShowing()) {
            new WindowGeometry((Window)this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public static char[] toCharArray(String s) {
        if (s == null) {
            return new char[0];
        }
        return s.toCharArray();
    }

    public static String string(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent arg0) {
            new CancelAction().cancel();
        }
    }

    class FinishAction
    extends AbstractAction {
        public FinishAction() {
            this.putValue("Name", I18n.tr((String)"Finish", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"ok"));
            this.putValue("ShortDescription", I18n.tr((String)"Confirm the setup and close this dialog", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            for (int i = 0; i <= InitializationWizard.this.panelIndex && !InitializationWizard.this.isCanceled(); ++i) {
                InitializationWizard.this.panels.get(i).onOkAction();
            }
            InitializationWizard.this.setVisible(false);
        }
    }

    class NextAction
    extends AbstractAction {
        public NextAction() {
            this.putValue("Name", I18n.tr((String)"Next", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"dialogs", (String)"next"));
            this.putValue("ShortDescription", I18n.tr((String)"Proceed and go to the next page", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (InitializationWizard.this.panelIndex == InitializationWizard.this.panels.size() - 1) {
                WizardPanel next = InitializationWizard.this.panels.get(InitializationWizard.this.panelIndex).provideNext();
                InitializationWizard.this.cardPanel.add((Component)next.getPanel(), next.getId());
                InitializationWizard.this.panels.add(next);
            }
            ++InitializationWizard.this.panelIndex;
            InitializationWizard.this.cardLayout.show(InitializationWizard.this.cardPanel, InitializationWizard.this.panels.get(InitializationWizard.this.panelIndex).getId());
            InitializationWizard.this.updateButtons();
        }
    }

    class BackAction
    extends AbstractAction {
        public BackAction() {
            this.putValue("Name", I18n.tr((String)"Back", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"dialogs", (String)"previous"));
            this.putValue("ShortDescription", I18n.tr((String)"Go to the previous page", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (InitializationWizard.this.panelIndex <= 0) {
                throw new IndexOutOfBoundsException("Index out of range: " + InitializationWizard.this.panelIndex);
            }
            --InitializationWizard.this.panelIndex;
            InitializationWizard.this.cardLayout.show(InitializationWizard.this.cardPanel, InitializationWizard.this.panels.get(InitializationWizard.this.panelIndex).getId());
            InitializationWizard.this.updateButtons();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr((String)"Cancel", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"cancel"));
            this.putValue("ShortDescription", I18n.tr((String)"Close the dialog and discard all changes", (Object[])new Object[0]));
        }

        public void cancel() {
            InitializationWizard.this.setCanceled(true);
            InitializationWizard.this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.cancel();
        }
    }

    private static class DeleteOldCredentialsPanel
    extends AbstractWizardPanel {
        private JRadioButton rbClear;
        private JRadioButton rbKeep;

        private DeleteOldCredentialsPanel() {
        }

        @Override
        public boolean isLast() {
            return true;
        }

        @Override
        public WizardPanel provideNext() {
            return null;
        }

        @Override
        public JPanel getContentPanel() {
            JPanel p = new JPanel();
            GroupLayout layout = new GroupLayout(p);
            p.setLayout(layout);
            HtmlPanel l = new HtmlPanel();
            l.setText("<html><b>" + I18n.tr((String)"Found sensitive data that is still saved in JOSM''s preference file (plain text).", (Object[])new Object[0]) + "<b></html>");
            this.rbClear = new JRadioButton("<html>" + I18n.tr((String)"Transfer to password manager and remove from preference file", (Object[])new Object[0]) + "</html>");
            this.rbKeep = new JRadioButton("<html>" + I18n.tr((String)"No, just keep it", (Object[])new Object[0]) + "</html>");
            this.rbClear.setSelected(true);
            ButtonGroup group = new ButtonGroup();
            group.add(this.rbClear);
            group.add(this.rbKeep);
            layout.setHorizontalGroup(layout.createParallelGroup().addComponent((Component)l).addComponent(this.rbClear).addComponent(this.rbKeep));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent((Component)l, -2, -1, -2).addComponent(this.rbClear).addComponent(this.rbKeep));
            return p;
        }

        @Override
        public void onOkAction() {
            CredentialsManager cm = CredentialsManager.getInstance();
            String proxyUsername = Config.getPref().get("proxy.user", null);
            String proxyPassword = Config.getPref().get("proxy.pass", null);
            String proxyHost = Config.getPref().get("proxy.http.host", null);
            if (proxyUsername != null || proxyPassword != null) {
                try {
                    cm.store(Authenticator.RequestorType.PROXY, proxyHost, new PasswordAuthentication(InitializationWizard.string(proxyUsername), InitializationWizard.toCharArray(proxyPassword)));
                    if (this.rbClear.isSelected()) {
                        Config.getPref().put("proxy.user", null);
                        Config.getPref().put("proxy.pass", null);
                    }
                }
                catch (CredentialsAgentException ex) {
                    Logging.error((Throwable)ex);
                }
            }
        }
    }

    private static class SelectionPanel
    extends AbstractWizardPanel
    implements ActionListener {
        private final NPMType type;
        private final InitializationWizard wizard;
        private JRadioButton rbManage;
        private JRadioButton rbPlain;

        public SelectionPanel(NPMType type, InitializationWizard wizard) {
            this.type = type;
            this.wizard = wizard;
        }

        @Override
        public boolean isLast() {
            return this.rbPlain != null && this.rbPlain.isSelected() || !InitializationWizard.hasUnprotectedCedentials();
        }

        @Override
        public WizardPanel provideNext() {
            return new DeleteOldCredentialsPanel();
        }

        @Override
        protected JPanel getContentPanel() {
            JPanel p = new JPanel();
            GroupLayout layout = new GroupLayout(p);
            p.setLayout(layout);
            HtmlPanel intro = new HtmlPanel("<html><b>" + this.type.getIntroText() + "</b></html>");
            this.rbManage = new JRadioButton("<html>" + this.type.getSelectionText() + "</html>");
            this.rbPlain = new JRadioButton("<html>" + I18n.tr((String)"No thanks, use JOSM''s plain text preferences storage", (Object[])new Object[0]) + "</html>");
            this.rbManage.addActionListener(this);
            this.rbPlain.addActionListener(this);
            this.rbManage.setSelected(true);
            ButtonGroup group = new ButtonGroup();
            group.add(this.rbManage);
            group.add(this.rbPlain);
            layout.setHorizontalGroup(layout.createParallelGroup().addComponent((Component)intro).addComponent(this.rbManage).addComponent(this.rbPlain));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent((Component)intro, -2, -1, -2).addComponent(this.rbManage).addComponent(this.rbPlain));
            return p;
        }

        @Override
        public void onOkAction() {
            if (this.rbManage.isSelected()) {
                NPMPlugin.selectAndSave(this.type);
            } else {
                this.wizard.setCanceled(true);
                NPMPlugin.turnOffPermanently();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.wizard.updateButtons();
        }
    }

    private static class NothingFoundPanel
    extends AbstractWizardPanel {
        JCheckBox cbDoNotShowAgain;

        private NothingFoundPanel() {
        }

        @Override
        public boolean isLast() {
            return true;
        }

        @Override
        public WizardPanel provideNext() {
            return null;
        }

        @Override
        public void onOkAction() {
            if (this.cbDoNotShowAgain.isSelected()) {
                NPMPlugin.turnOffPermanently();
            }
        }

        @Override
        protected JPanel getContentPanel() {
            JPanel p = new JPanel();
            GroupLayout layout = new GroupLayout(p);
            p.setLayout(layout);
            HtmlPanel intro = new HtmlPanel("<html>" + I18n.tr((String)"No native password manager could be found!", (Object[])new Object[0]) + "<br>" + I18n.tr((String)"Depending on your Operating System / Distribution, you may have to create a default keyring / wallet first.", (Object[])new Object[0]) + "</html>");
            this.cbDoNotShowAgain = new JCheckBox("Do not show this wizard again on next start");
            layout.setHorizontalGroup(layout.createParallelGroup().addComponent((Component)intro).addComponent(this.cbDoNotShowAgain));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent((Component)intro, -2, -1, -2).addComponent(this.cbDoNotShowAgain));
            return p;
        }
    }

    private static abstract class AbstractWizardPanel
    implements WizardPanel {
        private AbstractWizardPanel() {
        }

        @Override
        public JPanel getPanel() {
            JPanel p = new JPanel(new BorderLayout());
            JLabel image = new JLabel(ImageProvider.get((String)"lock-large"));
            image.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(0), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            image.setVerticalAlignment(1);
            p.add((Component)image, "West");
            JPanel content = this.getContentPanel();
            content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            p.add((Component)content, "Center");
            return p;
        }

        @Override
        public String getId() {
            return this.getClass().getCanonicalName();
        }

        protected abstract JPanel getContentPanel();
    }

    public static interface WizardPanel {
        public String getId();

        public JPanel getPanel();

        public boolean isLast();

        public WizardPanel provideNext();

        public void onOkAction();
    }
}

