/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.tiff.AbstractTiffElement;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.constants.TiffPlanarConfiguration;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.datareaders.DataReaderStrips;
import org.apache.commons.imaging.formats.tiff.datareaders.DataReaderTiled;
import org.apache.commons.imaging.formats.tiff.datareaders.ImageDataReader;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreter;

public abstract class AbstractTiffImageData {
    private static int extractSampleFormat(TiffDirectory directory) throws ImagingException {
        short[] sSampleFmt = directory.getFieldValue(TiffTagConstants.TIFF_TAG_SAMPLE_FORMAT, false);
        if (sSampleFmt != null && sSampleFmt.length > 0) {
            return sSampleFmt[0];
        }
        return 0;
    }

    public abstract ImageDataReader getDataReader(TiffDirectory var1, PhotometricInterpreter var2, int var3, int[] var4, int var5, int var6, int var7, int var8, int var9, TiffPlanarConfiguration var10, ByteOrder var11) throws IOException, ImagingException;

    public abstract AbstractTiffElement.DataElement[] getImageData();

    public abstract boolean stripsNotTiles();

    public static class Tiles
    extends AbstractTiffImageData {
        public final AbstractTiffElement.DataElement[] tiles;
        private final int tileWidth;
        private final int tileLength;

        public Tiles(AbstractTiffElement.DataElement[] tiles, int tileWidth, int tileLength) {
            this.tiles = tiles;
            this.tileWidth = tileWidth;
            this.tileLength = tileLength;
        }

        @Override
        public ImageDataReader getDataReader(TiffDirectory directory, PhotometricInterpreter photometricInterpreter, int bitsPerPixel, int[] bitsPerSample, int predictor, int samplesPerPixel, int width, int height, int compression, TiffPlanarConfiguration planarConfiguration, ByteOrder byteOrder) throws IOException, ImagingException {
            int sampleFormat = AbstractTiffImageData.extractSampleFormat(directory);
            return new DataReaderTiled(directory, photometricInterpreter, this.tileWidth, this.tileLength, bitsPerPixel, bitsPerSample, predictor, samplesPerPixel, sampleFormat, width, height, compression, planarConfiguration, byteOrder, this);
        }

        @Override
        public AbstractTiffElement.DataElement[] getImageData() {
            return this.tiles;
        }

        public int getTileHeight() {
            return this.tileLength;
        }

        public int getTileWidth() {
            return this.tileWidth;
        }

        @Override
        public boolean stripsNotTiles() {
            return false;
        }
    }

    public static class Strips
    extends AbstractTiffImageData {
        private final AbstractTiffElement.DataElement[] strips;
        public final int rowsPerStrip;

        public Strips(AbstractTiffElement.DataElement[] strips, int rowsPerStrip) {
            this.strips = strips;
            this.rowsPerStrip = rowsPerStrip;
        }

        @Override
        public ImageDataReader getDataReader(TiffDirectory directory, PhotometricInterpreter photometricInterpreter, int bitsPerPixel, int[] bitsPerSample, int predictor, int samplesPerPixel, int width, int height, int compression, TiffPlanarConfiguration planarConfiguration, ByteOrder byteorder) throws IOException, ImagingException {
            int sampleFormat = AbstractTiffImageData.extractSampleFormat(directory);
            return new DataReaderStrips(directory, photometricInterpreter, bitsPerPixel, bitsPerSample, predictor, samplesPerPixel, sampleFormat, width, height, compression, planarConfiguration, byteorder, this.rowsPerStrip, this);
        }

        @Override
        public AbstractTiffElement.DataElement[] getImageData() {
            return this.strips;
        }

        public AbstractTiffElement.DataElement getImageData(int offset) {
            return this.strips[offset];
        }

        public int getImageDataLength() {
            return this.strips.length;
        }

        @Override
        public boolean stripsNotTiles() {
            return true;
        }
    }

    public static class Data
    extends AbstractTiffElement.DataElement {
        public Data(long offset, int length, byte[] data) {
            super(offset, length, data);
        }

        @Override
        public String getElementDescription() {
            return "TIFF image data: " + this.getDataLength() + " bytes";
        }
    }
}

