/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.search;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.data.osm.search.PushbackTokenizer;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.plugins.utilsplugin2.search.ChildrenMatch;
import org.openstreetmap.josm.plugins.utilsplugin2.search.ParentsMatch;
import org.openstreetmap.josm.plugins.utilsplugin2.search.UsedInRelationsMatch;
import org.openstreetmap.josm.plugins.utilsplugin2.search.UsedInWaysMatch;
import org.openstreetmap.josm.tools.I18n;

public class UtilsSimpleMatchFactory
implements SearchCompiler.SimpleMatchFactory {
    private static final Collection<String> keywords = Collections.unmodifiableCollection(Arrays.asList("usedinways", "usedinrelations", "parents", "children"));

    public Collection<String> getKeywords() {
        return keywords;
    }

    public SearchCompiler.Match get(String keyword, boolean caseSensitive, boolean regexSearch, PushbackTokenizer tokenizer) throws SearchParseError {
        if (tokenizer == null) {
            throw new SearchParseError("<html>" + I18n.tr((String)"Expecting {0} after {1}", (Object[])new Object[]{"<code>:</code>", "<i>" + keyword + "</i>"}) + "</html>");
        }
        switch (keyword) {
            case "usedinways": {
                return new UsedInWaysMatch(tokenizer);
            }
            case "usedinrelations": {
                return new UsedInRelationsMatch(tokenizer);
            }
            case "parents": {
                return new ParentsMatch(tokenizer);
            }
            case "children": {
                return new ChildrenMatch(tokenizer);
            }
        }
        throw new IllegalStateException("Not expecting keyword " + keyword);
    }
}

