/*
 * Decompiled with CFR 0.152.
 */
package s57;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import s57.S57att;
import s57.S57map;
import s57.S57obj;
import s57.S57val;

public final class S57osm {
    private static final HashMap<String, KeyVal<?>> OSMtags = new HashMap();

    private S57osm() {
    }

    public static void OSMtag(ArrayList<KeyVal<?>> osm, String key, String val) {
        KeyVal<?> kv = OSMtags.get(key + "=" + val);
        if (kv != null) {
            if (kv.conv == S57val.Conv.E) {
                ArrayList<Enum> list = new ArrayList<Enum>();
                list.add((Enum)kv.val);
                osm.add(new KeyVal(kv.obj, kv.att, kv.conv, list));
            } else {
                osm.add(kv);
            }
        }
        KeyVal<?> kvl = null;
        KeyVal<?> kvd = null;
        boolean rc = false;
        boolean rcl = false;
        for (KeyVal<?> kvx : osm) {
            if (kvx.obj == S57obj.Obj.LAKARE) {
                kvl = kvx;
            } else if (kvx.obj == S57obj.Obj.RIVERS || kvx.obj == S57obj.Obj.CANALS) {
                rc = true;
            }
            if (kvx.obj == S57obj.Obj.DEPARE) {
                kvd = kvx;
                continue;
            }
            if (kvx.obj != S57obj.Obj.RIVERS && kvx.obj != S57obj.Obj.CANALS && kvx.obj != S57obj.Obj.LAKARE) continue;
            rcl = true;
        }
        if (rc && kvl != null) {
            osm.remove(kvl);
        }
        if (rcl && kvd != null) {
            osm.remove(kvd);
        }
    }

    public static void OSMmap(File file, S57map map, boolean bb) throws Exception {
        try (FileInputStream in = new FileInputStream(file);){
            S57osm.OSMmap(in, map, bb);
        }
    }

    public static void OSMmap(InputStream in, S57map map, boolean bb) throws Exception {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(in);
        S57osm.OSMmap(doc, map, bb);
    }

    public static void OSMmap(Document doc, S57map map, boolean bb) throws Exception {
        NamedNodeMap ntmap;
        NodeList rList;
        Node nNode;
        int i;
        NamedNodeMap nnmap;
        NodeList nList;
        double lat = 0.0;
        double lon = 0.0;
        long id = 0L;
        long ref = 0L;
        String k = "";
        String v = "";
        String type = "";
        String role = "";
        map.nodes.put(1L, new S57map.Snode());
        map.nodes.put(2L, new S57map.Snode());
        map.nodes.put(3L, new S57map.Snode());
        map.nodes.put(4L, new S57map.Snode());
        doc.getDocumentElement().normalize();
        if (!doc.getDocumentElement().getNodeName().equals("osm")) {
            System.err.println("OSM file format error");
            System.exit(-1);
        }
        if ((nList = doc.getElementsByTagName("bounds")).getLength() != 0) {
            nnmap = nList.item(0).getAttributes();
            ((S57map.Snode)map.nodes.get((Object)Long.valueOf((long)2L))).lat = map.bounds.minlat = Math.toRadians(Double.parseDouble(nnmap.getNamedItem("minlat").getNodeValue()));
            ((S57map.Snode)map.nodes.get((Object)Long.valueOf((long)3L))).lat = map.bounds.minlat;
            ((S57map.Snode)map.nodes.get((Object)Long.valueOf((long)1L))).lon = map.bounds.minlon = Math.toRadians(Double.parseDouble(nnmap.getNamedItem("minlon").getNodeValue()));
            ((S57map.Snode)map.nodes.get((Object)Long.valueOf((long)2L))).lon = map.bounds.minlon;
            ((S57map.Snode)map.nodes.get((Object)Long.valueOf((long)1L))).lat = map.bounds.maxlat = Math.toRadians(Double.parseDouble(nnmap.getNamedItem("maxlat").getNodeValue()));
            ((S57map.Snode)map.nodes.get((Object)Long.valueOf((long)4L))).lat = map.bounds.maxlat;
            ((S57map.Snode)map.nodes.get((Object)Long.valueOf((long)3L))).lon = map.bounds.maxlon = Math.toRadians(Double.parseDouble(nnmap.getNamedItem("maxlon").getNodeValue()));
            ((S57map.Snode)map.nodes.get((Object)Long.valueOf((long)4L))).lon = map.bounds.maxlon;
        }
        nList = doc.getElementsByTagName("node");
        int nLen = nList.getLength();
        for (i = 0; i < nLen; ++i) {
            nNode = nList.item(i);
            if (nNode.getNodeType() != 1) continue;
            nnmap = nNode.getAttributes();
            id = Long.parseLong(nnmap.getNamedItem("id").getNodeValue());
            lat = Double.parseDouble(nnmap.getNamedItem("lat").getNodeValue());
            lon = Double.parseDouble(nnmap.getNamedItem("lon").getNodeValue());
            map.addNode(id, lat, lon);
            NodeList tList = ((Element)nNode).getElementsByTagName("tag");
            for (int j = 0; j < tList.getLength(); ++j) {
                NamedNodeMap ntmap2 = tList.item(j).getAttributes();
                k = ntmap2.getNamedItem("k").getNodeValue();
                v = ntmap2.getNamedItem("v").getNodeValue();
                if (k.isEmpty() || v.isEmpty()) continue;
                map.addTag(k, v);
            }
            map.tagsDone(id);
        }
        nList = doc.getElementsByTagName("way");
        nLen = nList.getLength();
        for (i = 0; i < nLen; ++i) {
            nNode = nList.item(i);
            if (nNode.getNodeType() != 1) continue;
            nnmap = nNode.getAttributes();
            id = Long.parseLong(nnmap.getNamedItem("id").getNodeValue());
            map.addEdge(id);
            rList = ((Element)nNode).getElementsByTagName("nd");
            for (int j = 0; j < rList.getLength(); ++j) {
                NamedNodeMap nrmap = rList.item(j).getAttributes();
                ref = Long.parseLong(nrmap.getNamedItem("ref").getNodeValue());
                try {
                    map.addToEdge(ref);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Unknown node in way");
                    System.exit(-1);
                }
            }
            NodeList tList = ((Element)nNode).getElementsByTagName("tag");
            for (int j = 0; j < tList.getLength(); ++j) {
                ntmap = tList.item(j).getAttributes();
                k = ntmap.getNamedItem("k").getNodeValue();
                v = ntmap.getNamedItem("v").getNodeValue();
                if (k.isEmpty() || v.isEmpty()) continue;
                map.addTag(k, v);
            }
            map.tagsDone(id);
        }
        nList = doc.getElementsByTagName("relation");
        nLen = nList.getLength();
        for (i = 0; i < nLen; ++i) {
            nNode = nList.item(i);
            if (nNode.getNodeType() != 1) continue;
            nnmap = nNode.getAttributes();
            id = Long.parseLong(nnmap.getNamedItem("id").getNodeValue());
            map.addArea(id);
            rList = ((Element)nNode).getElementsByTagName("member");
            for (int j = 0; j < rList.getLength(); ++j) {
                NamedNodeMap nrmap = rList.item(j).getAttributes();
                type = nrmap.getNamedItem("type").getNodeValue();
                ref = Long.parseLong(nrmap.getNamedItem("ref").getNodeValue());
                role = nrmap.getNamedItem("role").getNodeValue();
                if (!role.equals("outer") && !role.equals("inner") || !type.equals("way")) continue;
                map.addToArea(ref, role.equals("outer"));
            }
            NodeList tList = ((Element)nNode).getElementsByTagName("tag");
            for (int j = 0; j < tList.getLength(); ++j) {
                ntmap = tList.item(j).getAttributes();
                k = ntmap.getNamedItem("k").getNodeValue();
                v = ntmap.getNamedItem("v").getNodeValue();
                if (k.isEmpty() || v.isEmpty()) continue;
                map.addTag(k, v);
            }
            map.tagsDone(id);
        }
        map.mapDone();
    }

    public static void OSMmeta(S57map map) {
        map.addEdge(++map.xref);
        for (long ref = 0L; ref <= 4L; ++ref) {
            map.addToEdge(ref == 0L ? 4L : ref);
        }
        map.addTag("seamark:type", "coverage");
        map.addTag("seamark:coverage:category", "coverage");
        map.tagsDone(map.xref);
    }

    static {
        OSMtags.put("natural=coastline", new KeyVal<Object>(S57obj.Obj.COALNE, S57att.Att.UNKATT, null, null));
        OSMtags.put("natural=water", new KeyVal<Object>(S57obj.Obj.LAKARE, S57att.Att.UNKATT, null, null));
        OSMtags.put("water=river", new KeyVal<Object>(S57obj.Obj.RIVERS, S57att.Att.UNKATT, null, null));
        OSMtags.put("water=canal", new KeyVal<Object>(S57obj.Obj.CANALS, S57att.Att.UNKATT, null, null));
        OSMtags.put("waterway=riverbank", new KeyVal<Object>(S57obj.Obj.RIVERS, S57att.Att.UNKATT, null, null));
        OSMtags.put("waterway=dock", new KeyVal<Object>(S57obj.Obj.HRBBSN, S57att.Att.UNKATT, null, null));
        OSMtags.put("waterway=lock", new KeyVal<Object>(S57obj.Obj.HRBBSN, S57att.Att.UNKATT, null, null));
        OSMtags.put("landuse=basin", new KeyVal<Object>(S57obj.Obj.LAKARE, S57att.Att.UNKATT, null, null));
        OSMtags.put("wetland=tidalflat", new KeyVal<Double>(S57obj.Obj.DEPARE, S57att.Att.DRVAL2, S57val.Conv.F, 0.0));
        OSMtags.put("tidal=yes", new KeyVal<Double>(S57obj.Obj.DEPARE, S57att.Att.DRVAL2, S57val.Conv.F, 0.0));
        OSMtags.put("natural=mud", new KeyVal<Object>(S57obj.Obj.DEPARE, S57att.Att.UNKATT, null, null));
        OSMtags.put("natural=sand", new KeyVal<Object>(S57obj.Obj.DEPARE, S57att.Att.UNKATT, null, null));
        OSMtags.put("highway=motorway", new KeyVal<S57val.CatROD>(S57obj.Obj.ROADWY, S57att.Att.CATROD, S57val.Conv.E, S57val.CatROD.ROD_MWAY));
        OSMtags.put("highway=trunk", new KeyVal<S57val.CatROD>(S57obj.Obj.ROADWY, S57att.Att.CATROD, S57val.Conv.E, S57val.CatROD.ROD_MAJR));
        OSMtags.put("highway=primary", new KeyVal<S57val.CatROD>(S57obj.Obj.ROADWY, S57att.Att.CATROD, S57val.Conv.E, S57val.CatROD.ROD_MAJR));
        OSMtags.put("highway=secondary", new KeyVal<S57val.CatROD>(S57obj.Obj.ROADWY, S57att.Att.CATROD, S57val.Conv.E, S57val.CatROD.ROD_MINR));
        OSMtags.put("highway=tertiary", new KeyVal<S57val.CatROD>(S57obj.Obj.ROADWY, S57att.Att.CATROD, S57val.Conv.E, S57val.CatROD.ROD_MINR));
        OSMtags.put("highway=residential", new KeyVal<Object>(S57obj.Obj.ROADWY, S57att.Att.UNKATT, null, null));
        OSMtags.put("highway=unclassified", new KeyVal<Object>(S57obj.Obj.ROADWY, S57att.Att.UNKATT, null, null));
        OSMtags.put("railway=rail", new KeyVal<Object>(S57obj.Obj.RAILWY, S57att.Att.UNKATT, null, null));
        OSMtags.put("man_made=breakwater", new KeyVal<Object>(S57obj.Obj.SLCONS, S57att.Att.UNKATT, null, null));
        OSMtags.put("man_made=groyne", new KeyVal<Object>(S57obj.Obj.SLCONS, S57att.Att.UNKATT, null, null));
        OSMtags.put("man_made=pier", new KeyVal<Object>(S57obj.Obj.SLCONS, S57att.Att.UNKATT, null, null));
        OSMtags.put("man_made=jetty", new KeyVal<Object>(S57obj.Obj.SLCONS, S57att.Att.UNKATT, null, null));
        OSMtags.put("landuse=industrial", new KeyVal<Object>(S57obj.Obj.BUAARE, S57att.Att.UNKATT, null, null));
        OSMtags.put("landuse=commercial", new KeyVal<Object>(S57obj.Obj.BUAARE, S57att.Att.UNKATT, null, null));
        OSMtags.put("landuse=retail", new KeyVal<Object>(S57obj.Obj.BUAARE, S57att.Att.UNKATT, null, null));
        OSMtags.put("landuse=residential", new KeyVal<Object>(S57obj.Obj.BUAARE, S57att.Att.UNKATT, null, null));
        OSMtags.put("boundary_type=territorial_waters", new KeyVal<Object>(S57obj.Obj.TESARE, S57att.Att.UNKATT, null, null));
    }

    static class KeyVal<V> {
        S57obj.Obj obj;
        S57att.Att att;
        S57val.Conv conv;
        V val;

        KeyVal(S57obj.Obj o, S57att.Att a, S57val.Conv c, V v) {
            this.obj = o;
            this.att = a;
            this.conv = c;
            this.val = v;
        }
    }
}

