/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.changeset;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.CachingProperty;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.changeset.util.DataSetChangesetBuilder;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangesetLayer
extends Layer
implements ActionListener {
    private static final CachingProperty<Color> DELETED_COLOR = new NamedColorProperty("general", I18n.marktr((String)"changeset-viewer"), I18n.marktr((String)"Deleted objects"), new Color(197, 38, 63)).cached();
    private static final CachingProperty<Color> CREATED_COLOR = new NamedColorProperty("general", I18n.marktr((String)"changeset-viewer"), I18n.marktr((String)"Created objects"), new Color(50, 214, 184)).cached();
    private static final CachingProperty<Color> MODIFIED_OLD = new NamedColorProperty("general", I18n.marktr((String)"changeset-viewer"), I18n.marktr((String)"Modified objects (old)"), new Color(214, 138, 13)).cached();
    private static final CachingProperty<Color> MODIFIED_NEW = new NamedColorProperty("general", I18n.marktr((String)"changeset-viewer"), I18n.marktr((String)"Modified objects (new)"), new Color(229, 228, 61)).cached();
    DataSetChangesetBuilder.BoundedChangesetDataSet dataSet;

    public ChangesetLayer(String name) {
        super(name);
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"changeset_layer");
    }

    public String getToolTipText() {
        return I18n.tr((String)"Layer to draw OSM error", (Object[])new Object[0]);
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void setDataSet(DataSetChangesetBuilder.BoundedChangesetDataSet dataSet) {
        this.dataSet = dataSet;
        this.invalidate();
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        String action;
        DataSet data = this.dataSet.getDataSet();
        Stroke stroke = g.getStroke();
        if (data == null) {
            return;
        }
        float[] dash1 = new float[]{10.0f};
        BasicStroke defaultStroke = new BasicStroke(2.0f);
        for (Way way : data.searchWays(bounds.toBBox())) {
            g.setStroke(defaultStroke);
            action = way.get("action");
            ChangesetLayer.paintWay(g, mv, dash1, way, action);
        }
        for (Node node : data.searchNodes(bounds.toBBox())) {
            g.setStroke(defaultStroke);
            action = node.get("action");
            ChangesetLayer.paintNode(g, mv, node, action);
        }
        g.setStroke(stroke);
    }

    private static void paintWay(Graphics2D g, MapView mv, float[] dash1, Way way, String action) {
        switch (action) {
            case "create": {
                g.setColor((Color)CREATED_COLOR.get());
                break;
            }
            case "delete": {
                g.setColor((Color)DELETED_COLOR.get());
                break;
            }
            case "modify-old": {
                g.setColor((Color)MODIFIED_OLD.get());
                break;
            }
            case "modify-new": {
                g.setColor((Color)MODIFIED_NEW.get());
                break;
            }
            case "modify-new-rel": 
            case "modify-old-rel": 
            case "create-rel": 
            case "delete-rel": {
                ChangesetLayer.setRelationColor(g, action);
                g.setStroke(new BasicStroke(1.0f, 0, 1, 10.0f, dash1, 0.0f));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown action: " + action);
            }
        }
        List nodes = way.getNodes();
        if (nodes.size() < 2) {
            return;
        }
        Point previous = null;
        for (Node node : way.getNodes()) {
            boolean latLonKnown = node.isLatLonKnown();
            if (previous == null && latLonKnown) {
                previous = mv.getPoint(node);
                continue;
            }
            if (previous != null && !latLonKnown) {
                previous = null;
                continue;
            }
            if (!latLonKnown) continue;
            Point point = mv.getPoint(node);
            g.drawLine(previous.x, previous.y, point.x, point.y);
            previous = point;
        }
    }

    private static void setRelationColor(Graphics2D g, String action) {
        switch (action) {
            case "modify-new-rel": {
                g.setColor((Color)MODIFIED_NEW.get());
                break;
            }
            case "modify-old-rel": {
                g.setColor((Color)MODIFIED_OLD.get());
                break;
            }
            case "create-rel": {
                g.setColor((Color)CREATED_COLOR.get());
                break;
            }
            case "delete-rel": {
                g.setColor((Color)DELETED_COLOR.get());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown action: " + action);
            }
        }
    }

    private static void paintNode(Graphics2D g, MapView mv, Node node, String action) {
        if (!node.referrers(Way.class).findAny().isPresent()) {
            switch (action) {
                case "create": {
                    g.setColor((Color)CREATED_COLOR.get());
                    break;
                }
                case "delete": {
                    g.setColor((Color)DELETED_COLOR.get());
                    break;
                }
                case "modify-old": {
                    g.setColor((Color)MODIFIED_OLD.get());
                    break;
                }
                case "modify-new": {
                    g.setColor((Color)MODIFIED_NEW.get());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown action: " + action);
                }
            }
            Point pnt = mv.getPoint(node);
            g.fillOval(pnt.x, pnt.y, 7, 7);
        }
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), Layer.SeparatorLayerAction.INSTANCE, Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JOptionPane.showConfirmDialog(null, e.getSource());
    }

    public void mergeFrom(Layer layer) {
        throw new UnsupportedOperationException("Layer merge is not supported");
    }
}

