/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cubemap;

import javafx.animation.AnimationTimer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.Group;
import javafx.scene.PerspectiveCamera;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapUtils;
import org.openstreetmap.josm.plugins.streetside.utils.GraphicsUtils;

public class CubemapBox
extends Group {
    private final Affine affine = new Affine();
    private final ImageView front = new ImageView();
    private final ImageView right = new ImageView();
    private final ImageView back = new ImageView();
    private final ImageView left = new ImageView();
    private final ImageView up = new ImageView();
    private final ImageView down = new ImageView();
    private final ImageView[] views = new ImageView[]{this.front, this.right, this.back, this.left, this.up, this.down};
    private final Image frontImg;
    private final Image rightImg;
    private final Image backImg;
    private final Image leftImg;
    private final Image upImg;
    private final Image downImg;
    private final PerspectiveCamera camera;
    private final DoubleProperty size = new SimpleDoubleProperty();

    public CubemapBox(Image frontImg, Image rightImg, Image backImg, Image leftImg, Image upImg, Image downImg, double size, PerspectiveCamera camera) {
        this.front.setId(CubemapUtils.CubemapFaces.FRONT.getValue());
        this.right.setId(CubemapUtils.CubemapFaces.RIGHT.getValue());
        this.back.setId(CubemapUtils.CubemapFaces.BACK.getValue());
        this.left.setId(CubemapUtils.CubemapFaces.LEFT.getValue());
        this.up.setId(CubemapUtils.CubemapFaces.UP.getValue());
        this.down.setId(CubemapUtils.CubemapFaces.DOWN.getValue());
        this.frontImg = frontImg;
        this.rightImg = rightImg;
        this.backImg = backImg;
        this.leftImg = leftImg;
        this.upImg = upImg;
        this.downImg = downImg;
        this.size.set(size);
        this.camera = camera;
        this.loadImageViews();
        this.getTransforms().add((Object)this.affine);
        this.getChildren().addAll((Object[])this.views);
        this.startTimer();
    }

    public void loadImageViews() {
        for (ImageView iv : this.views) {
            iv.setSmooth(true);
            iv.setPreserveRatio(true);
        }
        this.validateImageType();
    }

    private void layoutViews() {
        for (ImageView v : this.views) {
            v.setFitWidth(this.getSize());
            v.setFitHeight(this.getSize());
        }
        this.back.setTranslateX(-0.5 * this.getSize());
        this.back.setTranslateY(-0.5 * this.getSize());
        this.back.setTranslateZ(-0.5 * this.getSize());
        this.front.setTranslateX(-0.5 * this.getSize());
        this.front.setTranslateY(-0.5 * this.getSize());
        this.front.setTranslateZ(0.5 * this.getSize());
        this.front.setRotationAxis(Rotate.Z_AXIS);
        this.front.setRotate(-180.0);
        this.front.getTransforms().add((Object)new Rotate(180.0, this.front.getFitHeight() / 2.0, 0.0, 0.0, Rotate.X_AXIS));
        this.front.setTranslateY(this.front.getTranslateY() - this.getSize());
        this.up.setTranslateX(-0.5 * this.getSize());
        this.up.setTranslateY(-1.0 * this.getSize());
        this.up.setRotationAxis(Rotate.X_AXIS);
        this.up.setRotate(-90.0);
        this.down.setTranslateX(-0.5 * this.getSize());
        this.down.setTranslateY(0.0);
        this.down.setRotationAxis(Rotate.X_AXIS);
        this.down.setRotate(90.0);
        this.left.setTranslateX(-1.0 * this.getSize());
        this.left.setTranslateY(-0.5 * this.getSize());
        this.left.setRotationAxis(Rotate.Y_AXIS);
        this.left.setRotate(90.0);
        this.right.setTranslateX(0.0);
        this.right.setTranslateY(-0.5 * this.getSize());
        this.right.setRotationAxis(Rotate.Y_AXIS);
        this.right.setRotate(-90.0);
    }

    private void validateImageType() {
        this.setMultipleImages();
    }

    private void setMultipleImages() {
        GraphicsUtils.PlatformHelper.run(() -> {
            this.layoutViews();
            this.front.setImage(this.frontImg);
            this.right.setImage(this.rightImg);
            this.back.setImage(this.backImg);
            this.left.setImage(this.leftImg);
            this.up.setImage(this.upImg);
            this.down.setImage(this.downImg);
        });
    }

    public void startTimer() {
        AnimationTimer timer = new AnimationTimer(){

            public void handle(long now) {
                Transform ct;
                Transform transform = ct = CubemapBox.this.camera != null ? CubemapBox.this.camera.getLocalToSceneTransform() : null;
                if (ct != null) {
                    CubemapBox.this.affine.setTx(ct.getTx());
                    CubemapBox.this.affine.setTy(ct.getTy());
                    CubemapBox.this.affine.setTz(ct.getTz());
                }
            }
        };
        timer.start();
    }

    public final double getSize() {
        return this.size.get();
    }

    public ImageView[] getViews() {
        return this.views;
    }
}

