/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.geotools.data.shapefile.files.ShpFileType;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.util.URLs;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.ReflectionUtils;

public class TabFiles
extends ShpFiles {
    private final Map<ShpFileType, URL> urls;

    public TabFiles(File headerFile, File dataFile) throws IllegalArgumentException {
        super(TabFiles.fakeShpFile(headerFile));
        try {
            Field furls = ShpFiles.class.getDeclaredField("urls");
            ReflectionUtils.setObjectsAccessible((AccessibleObject[])new AccessibleObject[]{furls});
            this.urls = (Map)furls.get((Object)this);
        }
        catch (ReflectiveOperationException e) {
            throw new JosmRuntimeException((Throwable)e);
        }
        this.init(URLs.fileToUrl((File)headerFile));
        this.urls.put(ShpFileType.DBF, URLs.fileToUrl((File)dataFile));
    }

    private static URL fakeShpFile(File headerFile) {
        return URLs.fileToUrl((File)new File(headerFile.getAbsolutePath() + ".shp"));
    }

    private static String baseName(Object obj) {
        if (obj instanceof URL) {
            return TabFiles.toBase(((URL)obj).toExternalForm());
        }
        return null;
    }

    private static String toBase(String path) {
        return path.substring(0, path.toLowerCase(Locale.ROOT).lastIndexOf(".tab"));
    }

    private void init(URL url) {
        String base = TabFiles.baseName(url);
        if (base == null) {
            throw new IllegalArgumentException(url.getPath() + " is not one of the files types that is known to be associated with a MapInfo TAB file");
        }
        String urlString = url.toExternalForm();
        char lastChar = urlString.charAt(urlString.length() - 1);
        boolean upperCase = Character.isUpperCase(lastChar);
        for (ShpFileType type : ShpFileType.values()) {
            URL newURL;
            String extensionWithPeriod = type.extensionWithPeriod;
            extensionWithPeriod = upperCase ? extensionWithPeriod.toUpperCase(Locale.ROOT) : extensionWithPeriod.toLowerCase(Locale.ROOT);
            String string = base + extensionWithPeriod;
            try {
                newURL = new URL(url, string);
            }
            catch (MalformedURLException e) {
                throw new JosmRuntimeException((Throwable)e);
            }
            this.urls.put(type, newURL);
        }
        if (this.isLocal()) {
            Set<Map.Entry<ShpFileType, URL>> entries = this.urls.entrySet();
            EnumMap<ShpFileType, URL> toUpdate = new EnumMap<ShpFileType, URL>(ShpFileType.class);
            for (Map.Entry<ShpFileType, URL> entry : entries) {
                if (this.exists(entry.getKey()) || (url = TabFiles.findExistingFile(entry.getValue())) == null) continue;
                toUpdate.put(entry.getKey(), url);
            }
            this.urls.putAll(toUpdate);
        }
    }

    private static URL findExistingFile(URL value) {
        File[] files;
        File file = URLs.urlToFile((URL)value);
        File directory = file.getParentFile();
        if (directory != null && directory.exists() && (files = directory.listFiles((dir, name) -> file.getName().equalsIgnoreCase(name))) != null && files.length > 0) {
            try {
                return files[0].toURI().toURL();
            }
            catch (MalformedURLException e) {
                Logging.error((Throwable)e);
            }
        }
        return null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public String getTypeName() {
        int slash;
        String path = ShpFileType.SHP.toBase(this.urls.get(ShpFileType.SHP));
        int dot = path.indexOf(46, slash = Math.max(0, path.lastIndexOf(47) + 1));
        if (dot < 0) {
            dot = path.length();
        }
        return path.substring(slash, dot);
    }
}

