/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.DBCellRecord;
import org.apache.poi.hssf.record.EOFRecord;
import org.apache.poi.hssf.record.FilePassRecord;
import org.apache.poi.hssf.record.MulRKRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactory;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.TextObjectRecord;
import org.apache.poi.hssf.record.UnknownRecord;

public final class RecordFactoryInputStream {
    private final RecordInputStream _recStream;
    private final boolean _shouldIncludeContinueRecords;
    private Record[] _unreadRecordBuffer;
    private int _unreadRecordIndex = -1;
    private Record _lastRecord = null;
    private int _bofDepth;
    private boolean _lastRecordWasEOFLevelZero;

    public RecordFactoryInputStream(InputStream inputStream, boolean bl) {
        RecordInputStream recordInputStream = new RecordInputStream(inputStream);
        ArrayList<Record> arrayList = new ArrayList<Record>();
        StreamEncryptionInfo streamEncryptionInfo = new StreamEncryptionInfo(recordInputStream, arrayList);
        if (!arrayList.isEmpty()) {
            this._unreadRecordBuffer = new Record[arrayList.size()];
            arrayList.toArray(this._unreadRecordBuffer);
            this._unreadRecordIndex = 0;
        }
        this._recStream = recordInputStream;
        this._shouldIncludeContinueRecords = bl;
        this._lastRecord = streamEncryptionInfo.getLastRecord();
        this._bofDepth = streamEncryptionInfo.hasBOFRecord() ? 1 : 0;
        this._lastRecordWasEOFLevelZero = false;
    }

    public Record nextRecord() {
        Record record = this.getNextUnreadRecord();
        if (record != null) {
            return record;
        }
        do {
            if (!this._recStream.hasNextRecord()) {
                return null;
            }
            if (this._lastRecordWasEOFLevelZero && this._recStream.getNextSid() != 2057) {
                return null;
            }
            this._recStream.nextRecord();
            record = this.readNextRecord();
        } while (record == null);
        return record;
    }

    private Record getNextUnreadRecord() {
        if (this._unreadRecordBuffer != null) {
            int n = this._unreadRecordIndex;
            if (n < this._unreadRecordBuffer.length) {
                Record record = this._unreadRecordBuffer[n];
                this._unreadRecordIndex = n + 1;
                return record;
            }
            this._unreadRecordIndex = -1;
            this._unreadRecordBuffer = null;
        }
        return null;
    }

    private Record readNextRecord() {
        Record record = RecordFactory.createSingleRecord(this._recStream);
        this._lastRecordWasEOFLevelZero = false;
        if (record instanceof BOFRecord) {
            ++this._bofDepth;
            return record;
        }
        if (record instanceof EOFRecord) {
            --this._bofDepth;
            if (this._bofDepth < 1) {
                this._lastRecordWasEOFLevelZero = true;
            }
            return record;
        }
        if (record instanceof DBCellRecord) {
            return null;
        }
        if (record instanceof RKRecord) {
            return RecordFactory.convertToNumberRecord((RKRecord)record);
        }
        if (record instanceof MulRKRecord) {
            NumberRecord[] numberRecordArray = RecordFactory.convertRKRecords((MulRKRecord)record);
            this._unreadRecordBuffer = numberRecordArray;
            this._unreadRecordIndex = 1;
            return numberRecordArray[0];
        }
        if (record.getSid() == 60) {
            if (this._lastRecord instanceof ObjRecord || this._lastRecord instanceof TextObjectRecord) {
                if (this._shouldIncludeContinueRecords) {
                    return record;
                }
                return null;
            }
            if (this._lastRecord instanceof UnknownRecord) {
                return record;
            }
            if (this._lastRecord instanceof EOFRecord) {
                return record;
            }
            throw new RecordFormatException("Unhandled Continue Record followining " + this._lastRecord.getClass());
        }
        this._lastRecord = record;
        return record;
    }

    private static final class StreamEncryptionInfo {
        private final Record _lastRecord;
        private final boolean _hasBOFRecord;

        public StreamEncryptionInfo(RecordInputStream recordInputStream, List<Record> list) {
            recordInputStream.nextRecord();
            Record record = RecordFactory.createSingleRecord(recordInputStream);
            list.add(record);
            if (record instanceof BOFRecord) {
                this._hasBOFRecord = true;
                if (recordInputStream.hasNextRecord()) {
                    recordInputStream.nextRecord();
                    record = RecordFactory.createSingleRecord(recordInputStream);
                    list.add(record);
                    if (record instanceof FilePassRecord) {
                        list.remove(list.size() - 1);
                        record = list.get(0);
                    } else if (record instanceof EOFRecord) {
                        throw new IllegalStateException("Nothing between BOF and EOF");
                    }
                }
            } else {
                this._hasBOFRecord = false;
            }
            this._lastRecord = record;
        }

        public Record getLastRecord() {
            return this._lastRecord;
        }

        public boolean hasBOFRecord() {
            return this._hasBOFRecord;
        }
    }
}

