/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import livegps.LiveGpsData;
import livegps.LiveGpsStatus;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.nmea.NmeaParser;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class LiveGpsAcquirerNMEA
implements Runnable {
    private String serName;
    private InputStreamReader serReader;
    private NmeaParser parser;
    private boolean connected = false;
    private boolean shutdownFlag = false;
    private final List<PropertyChangeListener> propertyChangeListener = new ArrayList<PropertyChangeListener>();
    private PropertyChangeEvent lastStatusEvent;
    private PropertyChangeEvent lastDataEvent;

    public LiveGpsAcquirerNMEA() {
        this.serName = Config.getPref().get("livegps.serial.port");
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.propertyChangeListener.contains(listener)) {
            this.propertyChangeListener.add(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeListener.contains(listener)) {
            this.propertyChangeListener.remove(listener);
        }
    }

    public void fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus status, String statusMessage) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "nmeastatus", null, new LiveGpsStatus(status, statusMessage));
        if (!event.equals(this.lastStatusEvent)) {
            this.firePropertyChangeEvent(event);
            this.lastStatusEvent = event;
        }
    }

    public void fireGpsDataChangeEvent(LiveGpsData oldData, LiveGpsData newData) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "gpsdata", oldData, newData);
        if (!event.equals(this.lastDataEvent)) {
            this.firePropertyChangeEvent(event);
            this.lastDataEvent = event;
        }
    }

    protected void firePropertyChangeEvent(PropertyChangeEvent event) {
        for (PropertyChangeListener listener : this.propertyChangeListener) {
            listener.propertyChange(event);
        }
    }

    @Override
    public void run() {
        LiveGpsData oldGpsData = null;
        this.shutdownFlag = false;
        while (!this.shutdownFlag) {
            while (!this.connected && !this.shutdownFlag) {
                try {
                    this.connect();
                }
                catch (IOException iox) {
                    this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.CONNECTION_FAILED, I18n.tr((String)"NMEA Connection Failed", (Object[])new Object[0]));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignore) {
                        Logging.info((Throwable)ignore);
                    }
                }
            }
            assert (this.connected);
            try {
                StringBuilder sb = new StringBuilder(1024);
                int loopstartChar = this.serReader.read();
                if (loopstartChar == -1) {
                    throw new IOException();
                }
                sb.append((char)loopstartChar);
                Instant lasttime = null;
                while (!this.shutdownFlag) {
                    int c;
                    if (sb.length() >= 1020) {
                        sb.delete(0, sb.length() - 1);
                    }
                    if ((c = this.serReader.read()) == 36) {
                        Logging.trace((String)("Parsing NMEA: " + sb.toString().replaceAll("[\r\n]", "")));
                        this.parser.parseNMEASentence(sb.toString());
                        sb.delete(0, sb.length());
                        sb.append('$');
                    } else {
                        if (c == -1) {
                            throw new IOException();
                        }
                        sb.append((char)c);
                    }
                    if (this.serReader.ready()) continue;
                    WayPoint last = null;
                    Collection wpts = this.parser.getAndDropWaypoints();
                    for (WayPoint w : wpts) {
                        if (w.getInstant() == null) continue;
                        if (w.getInstant().equals(lasttime)) {
                            Logging.info((String)("Skip double waypoint at " + lasttime));
                            continue;
                        }
                        last = w;
                        float course = 0.0f;
                        float speed = 0.0f;
                        if (w.getString("course") != null) {
                            course = Float.valueOf(w.getString("course")).floatValue();
                        }
                        if (w.getString("speed") != null) {
                            speed = Float.valueOf(w.getString("speed")).floatValue() / 3.6f;
                        }
                        Logging.trace((String)("New LiveGPS entry: " + w));
                        LiveGpsData gpsData = new LiveGpsData(w.lat(), w.lon(), course, speed, 0.0f, 0.0f);
                        gpsData.setWaypoint(w);
                        this.fireGpsDataChangeEvent(oldGpsData, gpsData);
                        oldGpsData = gpsData;
                    }
                    if (last != null) {
                        lasttime = last.getInstant();
                    }
                    if (this.serReader.ready()) continue;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException ignore) {
                        Logging.info((Throwable)ignore);
                    }
                }
            }
            catch (IOException iox) {
                Logging.log((Level)Logging.LEVEL_WARN, (String)"LiveGps: lost connection to NMEA", (Throwable)iox);
                this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.CONNECTION_FAILED, I18n.tr((String)"NMEA Connection Failed", (Object[])new Object[0]));
                this.disconnect();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignore) {
                    Logging.info((Throwable)ignore);
                }
            }
            catch (IllegalDataException ex) {
                Logging.log((Level)Logging.LEVEL_WARN, (String)"LiveGps: Illegal NMEA", (Throwable)ex);
            }
        }
        Logging.info((String)"LiveGps: Disconnected from NMEA");
        this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.DISCONNECTED, I18n.tr((String)"NMEA Not connected", (Object[])new Object[0]));
        this.disconnect();
    }

    public void shutdown() {
        Logging.info((String)"LiveGps: Shutdown NMEA");
        this.shutdownFlag = true;
    }

    private void connect() throws IOException {
        this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.CONNECTING, I18n.tr((String)"Connecting", (Object[])new Object[0]));
        this.serReader = new InputStreamReader((InputStream)new FileInputStream(this.serName), StandardCharsets.UTF_8);
        this.parser = new NmeaParser();
        this.fireGpsStatusChangeEvent(LiveGpsStatus.GpsStatus.CONNECTED, I18n.tr((String)"Connected", (Object[])new Object[0]));
        this.connected = true;
    }

    private void disconnect() {
        if (this.serReader != null) {
            try {
                this.serReader.close();
            }
            catch (IOException iox) {
                Logging.warn((String)"LiveGps: Unable to close NMEA; reconnection may not be possible");
            }
            this.serReader = null;
        }
        this.parser = null;
        this.connected = false;
    }
}

