/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.hot.sds;

import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.openstreetmap.hot.sds.SdsCredentialAgent;
import org.openstreetmap.hot.sds.SdsTransferException;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;
import org.openstreetmap.josm.tools.Logging;

public class SdsConnection {
    protected boolean cancel = false;
    protected HttpURLConnection activeConnection;
    private SdsCredentialAgent credAgent = new SdsCredentialAgent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.cancel = true;
        SdsConnection sdsConnection = this;
        synchronized (sdsConnection) {
            if (this.activeConnection != null) {
                this.activeConnection.setConnectTimeout(100);
                this.activeConnection.setReadTimeout(100);
            }
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            Logging.trace((Throwable)ex);
        }
        sdsConnection = this;
        synchronized (sdsConnection) {
            if (this.activeConnection != null) {
                this.activeConnection.disconnect();
            }
        }
    }

    protected void addBasicAuthorizationHeader(HttpURLConnection con) throws SdsTransferException {
        CredentialsAgentResponse response;
        try {
            response = this.credAgent.getCredentials(Authenticator.RequestorType.SERVER, con.getURL().getHost(), false);
        }
        catch (CredentialsAgentException e) {
            throw new SdsTransferException(e);
        }
        if (response == null) {
            String token = ":";
        } else {
            if (response.isCanceled()) {
                this.cancel = true;
                return;
            }
            String username = response.getUsername() == null ? "" : response.getUsername();
            String password = response.getPassword() == null ? "" : String.valueOf(response.getPassword());
            String token = username + ":" + password;
            con.addRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString(token.getBytes(StandardCharsets.UTF_8)));
        }
    }

    protected void addAuth(HttpURLConnection connection) throws SdsTransferException {
        this.addBasicAuthorizationHeader(connection);
    }

    public boolean isCanceled() {
        return this.cancel;
    }

    static {
        try {
            HttpURLConnection.setFollowRedirects(true);
        }
        catch (SecurityException e) {
            Logging.error((Throwable)e);
        }
    }
}

