/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.terracer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionItem;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompComboBox;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.plugins.terracer.HouseNumberInputHandler;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class HouseNumberInputDialog
extends ExtendedDialog {
    static final String DEFAULT_SEGMENTS = "plugins.terracer.segments";
    static final String HANDLE_RELATION = "plugins.terracer.handle_relation";
    static final String KEEP_OUTLINE = "plugins.terracer.keep_outline";
    static final String INTERPOLATION = "plugins.terracer.interpolation";
    private final String streetName;
    private final String buildingType;
    private final boolean relationExists;
    final List<Node> houseNumbers;
    protected static final String DEFAULT_MESSAGE = I18n.tr((String)"Enter housenumbers or amount of segments", (Object[])new Object[0]);
    private Container jContentPane;
    private JPanel inputPanel;
    JTextField lo;
    JTextField hi;
    private JLabel numbersLabel;
    JTextField numbers;
    AutoCompComboBox<String> streetComboBox;
    AutoCompComboBox<AutoCompletionItem> buildingComboBox;
    JTextField segments;
    JTextArea messageLabel;
    JosmComboBox<String> interpolationType;
    JCheckBox handleRelationCheckBox;
    JCheckBox keepOutlineCheckBox;
    HouseNumberInputHandler inputHandler;

    public HouseNumberInputDialog(HouseNumberInputHandler handler, Way street, String streetName, String buildingType, boolean relationExists, List<Node> houseNumbers) {
        super((Component)MainApplication.getMainFrame(), I18n.tr((String)"Terrace a house", (Object[])new Object[0]), new String[]{I18n.tr((String)"OK", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}, true);
        this.inputHandler = handler;
        this.streetName = streetName;
        this.buildingType = buildingType;
        this.relationExists = relationExists;
        this.houseNumbers = houseNumbers;
        handler.dialog = this;
        JPanel content = this.getInputPanel();
        this.setContent(content);
        this.setButtonIcons(new String[]{"ok", "cancel"});
        this.getJContentPane();
        this.initialize();
        this.setDefaultButton(1);
        this.setupDialog();
        this.getRootPane().setDefaultButton(this.defaultButton);
        this.pack();
        this.setRememberWindowGeometry(((Object)((Object)this)).getClass().getName() + ".geometry", WindowGeometry.centerInWindow((Component)MainApplication.getMainFrame(), (Dimension)this.getPreferredSize()));
        this.lo.requestFocusInWindow();
    }

    private void initialize() {
        this.lo.addFocusListener(this.inputHandler);
        this.hi.addFocusListener(this.inputHandler);
        this.segments.addFocusListener(this.inputHandler);
        this.interpolationType.addItemListener((ItemListener)this.inputHandler);
    }

    private Container getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = this.getContentPane();
            this.jContentPane.setLayout(new BoxLayout(this.jContentPane, 1));
            this.jContentPane.add((Component)this.getInputPanel(), (Object)this.jContentPane);
        }
        return this.jContentPane;
    }

    private JPanel getInputPanel() {
        if (this.inputPanel == null) {
            GridBagConstraints c = new GridBagConstraints();
            this.messageLabel = new JTextArea();
            this.messageLabel.setText(DEFAULT_MESSAGE);
            this.messageLabel.setAutoscrolls(true);
            this.messageLabel.setLineWrap(true);
            this.messageLabel.setRows(2);
            this.messageLabel.setBackground(new Color(238, 238, 238));
            this.messageLabel.setEditable(false);
            this.messageLabel.setFocusable(false);
            JLabel interpolationLabel = new JLabel(I18n.tr((String)"Interpolation", (Object[])new Object[0]));
            JLabel segmentsLabel = new JLabel(I18n.tr((String)"Segments", (Object[])new Object[0]));
            JLabel streetLabel = new JLabel(I18n.tr((String)"Street", (Object[])new Object[0]));
            JLabel buildingLabel = new JLabel(I18n.tr((String)"Building", (Object[])new Object[0]));
            JLabel loLabel = new JLabel(I18n.tr((String)"Lowest Number", (Object[])new Object[0]));
            loLabel.setPreferredSize(new Dimension(111, 16));
            loLabel.setToolTipText(I18n.tr((String)"Lowest housenumber of the terraced house", (Object[])new Object[0]));
            JLabel hiLabel = new JLabel(I18n.tr((String)"Highest Number", (Object[])new Object[0]));
            this.numbersLabel = new JLabel(I18n.tr((String)"List of Numbers", (Object[])new Object[0]));
            loLabel.setPreferredSize(new Dimension(111, 16));
            String txt = this.relationExists ? I18n.tr((String)"add to existing associatedStreet relation", (Object[])new Object[0]) : I18n.tr((String)"create an associatedStreet relation", (Object[])new Object[0]);
            this.handleRelationCheckBox = new JCheckBox(txt, this.relationExists && Config.getPref().getBoolean(HANDLE_RELATION, true));
            this.keepOutlineCheckBox = new JCheckBox(I18n.tr((String)"keep outline way", (Object[])new Object[0]), Config.getPref().getBoolean(KEEP_OUTLINE, false));
            this.inputPanel = new JPanel();
            this.inputPanel.setLayout(new GridBagLayout());
            c.fill = 2;
            c.gridwidth = 0;
            this.inputPanel.add((Component)this.messageLabel, c);
            this.inputPanel.add((Component)loLabel, GBC.std().insets(3, 3, 0, 0));
            this.inputPanel.add((Component)this.getLo(), GBC.eol().fill(2).insets(5, 3, 0, 0));
            this.inputPanel.add((Component)hiLabel, GBC.std().insets(3, 3, 0, 0));
            this.inputPanel.add((Component)this.getHi(), GBC.eol().fill(2).insets(5, 3, 0, 0));
            this.inputPanel.add((Component)this.numbersLabel, GBC.std().insets(3, 3, 0, 0));
            this.inputPanel.add((Component)this.getNumbers(), GBC.eol().fill(2).insets(5, 3, 0, 0));
            this.inputPanel.add((Component)interpolationLabel, GBC.std().insets(3, 3, 0, 0));
            this.inputPanel.add((Component)this.getInterpolation(), GBC.eol().insets(5, 3, 0, 0));
            this.inputPanel.add((Component)segmentsLabel, GBC.std().insets(3, 3, 0, 0));
            this.inputPanel.add((Component)this.getSegments(), GBC.eol().fill(2).insets(5, 3, 0, 0));
            if (this.streetName == null) {
                this.inputPanel.add((Component)streetLabel, GBC.std().insets(3, 3, 0, 0));
                this.inputPanel.add((Component)this.getStreet(), GBC.eol().insets(5, 3, 0, 0));
            } else {
                this.inputPanel.add((Component)new JLabel(I18n.tr((String)"Street name: ", (Object[])new Object[0]) + "\"" + this.streetName + "\""), GBC.eol().insets(3, 3, 0, 0));
            }
            this.inputPanel.add((Component)buildingLabel, GBC.std().insets(3, 3, 0, 0));
            this.inputPanel.add((Component)this.getBuilding(), GBC.eol().insets(5, 3, 0, 0));
            this.inputPanel.add((Component)this.handleRelationCheckBox, GBC.eol().insets(3, 3, 0, 0));
            this.inputPanel.add((Component)this.keepOutlineCheckBox, GBC.eol().insets(3, 3, 0, 0));
            if (this.numbers.isVisible()) {
                loLabel.setVisible(false);
                this.lo.setVisible(false);
                this.lo.setEnabled(false);
                hiLabel.setVisible(false);
                this.hi.setVisible(false);
                this.hi.setEnabled(false);
                interpolationLabel.setVisible(false);
                this.interpolationType.setVisible(false);
                this.interpolationType.setEnabled(false);
                this.segments.setText(String.valueOf(this.houseNumbers.size()));
                this.segments.setEditable(false);
            }
        }
        return this.inputPanel;
    }

    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        this.inputHandler.actionPerformed(evt);
    }

    private JTextField getLo() {
        if (this.lo == null) {
            this.lo = new JTextField();
            this.lo.setText("");
        }
        return this.lo;
    }

    private JTextField getHi() {
        if (this.hi == null) {
            this.hi = new JTextField();
            this.hi.setText("");
        }
        return this.hi;
    }

    private JTextField getNumbers() {
        if (this.numbers == null) {
            this.numbers = new JTextField();
            Iterator<Node> it = this.houseNumbers.iterator();
            StringBuilder s = new StringBuilder(256);
            if (it.hasNext()) {
                s.append(it.next().get("addr:housenumber"));
                while (it.hasNext()) {
                    s.append(';').append(it.next().get("addr:housenumber"));
                }
            } else {
                this.numbersLabel.setVisible(false);
                this.numbers.setVisible(false);
            }
            this.numbers.setText(s.toString());
            this.numbers.setEditable(false);
        }
        return this.numbers;
    }

    private AutoCompComboBox<String> getStreet() {
        if (this.streetComboBox == null) {
            this.streetComboBox = new AutoCompComboBox();
            this.streetComboBox.getModel().addAllElements(this.createAutoCompletionInfo());
            this.streetComboBox.setEditable(true);
            this.streetComboBox.setSelectedItem(null);
        }
        return this.streetComboBox;
    }

    private AutoCompComboBox<AutoCompletionItem> getBuilding() {
        if (this.buildingComboBox == null) {
            this.buildingComboBox = new AutoCompComboBox();
            this.buildingComboBox.getModel().addAllElements((Collection)AutoCompletionManager.of((DataSet)OsmDataManager.getInstance().getEditDataSet()).getTagValues("building"));
            this.buildingComboBox.setEditable(true);
            if (this.buildingType != null && !this.buildingType.isEmpty()) {
                this.buildingComboBox.setSelectedItem((Object)this.buildingType);
            } else {
                this.buildingComboBox.setSelectedItem((Object)"yes");
            }
        }
        return this.buildingComboBox;
    }

    private JTextField getSegments() {
        if (this.segments == null) {
            this.segments = new JTextField();
            this.segments.setText(Config.getPref().get(DEFAULT_SEGMENTS, "2"));
        }
        return this.segments;
    }

    private JComponent getInterpolation() {
        if (this.interpolationType == null) {
            this.interpolationType = new JosmComboBox();
            this.interpolationType.setEditable(false);
            this.interpolationType.addItem((Object)I18n.tr((String)"All", (Object[])new Object[0]));
            this.interpolationType.addItem((Object)I18n.tr((String)"Even/Odd", (Object[])new Object[0]));
            if (Config.getPref().getInt(INTERPOLATION, 2) == 1) {
                this.interpolationType.setSelectedItemText(I18n.tr((String)"All", (Object[])new Object[0]));
            } else {
                this.interpolationType.setSelectedItemText(I18n.tr((String)"Even/Odd", (Object[])new Object[0]));
            }
        }
        return this.interpolationType;
    }

    Set<String> createAutoCompletionInfo() {
        TreeSet<String> names = new TreeSet<String>();
        for (OsmPrimitive osm : MainApplication.getLayerManager().getEditDataSet().allNonDeletedPrimitives()) {
            if (osm.getKeys() == null || !osm.keySet().contains("highway") || !osm.keySet().contains("name")) continue;
            names.add(osm.get("name"));
        }
        return names;
    }
}

