/*
 * Decompiled with CFR 0.152.
 */
package relcontext.relationfix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.josm.command.ChangeMembersCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.MultipolygonBuilder;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import relcontext.relationfix.RelationFixer;

public class MultipolygonFixer
extends RelationFixer {
    public MultipolygonFixer() {
        super("multipolygon");
    }

    protected MultipolygonFixer(String ... types) {
        super(types);
    }

    @Override
    public boolean isRelationGood(Relation rel) {
        for (RelationMember m : rel.getMembers()) {
            if (m.getType() != OsmPrimitiveType.WAY || "outer".equals(m.getRole()) || "inner".equals(m.getRole())) continue;
            this.setWarningMessage(I18n.tr((String)"Way without ''inner'' or ''outer'' role found", (Object[])new Object[0]));
            return false;
        }
        this.clearWarningMessage();
        return true;
    }

    @Override
    public Command fixRelation(Relation rel) {
        List<RelationMember> members = this.fixMultipolygonRoles(rel.getMembers());
        if (members.isEmpty() || members.equals(rel.getMembers())) {
            return null;
        }
        DataSet ds = (DataSet)Utils.firstNonNull((Object[])new DataSet[]{rel.getDataSet(), MainApplication.getLayerManager().getEditDataSet()});
        return new ChangeMembersCommand(ds, rel, members);
    }

    protected List<RelationMember> fixMultipolygonRoles(List<RelationMember> origMembers) {
        MultipolygonBuilder mpc = new MultipolygonBuilder();
        List ways = origMembers.stream().filter(m -> m.isWay()).map(m -> m.getWay()).collect(Collectors.toList());
        String error = mpc.makeFromWays(ways);
        if (error != null) {
            return Collections.emptyList();
        }
        HashSet outerWays = new HashSet();
        for (Object poly : mpc.outerWays) {
            outerWays.addAll(((MultipolygonBuilder.JoinedPolygon)poly).ways);
        }
        HashSet innerWays = new HashSet();
        for (MultipolygonBuilder.JoinedPolygon poly : mpc.innerWays) {
            innerWays.addAll(poly.ways);
        }
        List<RelationMember> members = origMembers;
        for (int i = 0; i < members.size(); ++i) {
            RelationMember m2 = members.get(i);
            if (!m2.isWay()) continue;
            Way way = m2.getWay();
            String role = null;
            if (outerWays.contains(way)) {
                role = "outer";
            } else if (innerWays.contains(way)) {
                role = "inner";
            }
            if (role == null || role.equals(m2.getRole())) continue;
            if (members == origMembers) {
                members = new ArrayList<RelationMember>(origMembers);
            }
            members.set(i, new RelationMember(role, (OsmPrimitive)way));
        }
        return members;
    }
}

