/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.Position2D;
import org.geotools.referencing.operation.builder.Circle;
import org.geotools.referencing.operation.builder.Polygon;
import org.geotools.referencing.operation.builder.TriangulationException;

class TINTriangle
extends Polygon {
    public Position p0;
    public Position p1;
    public Position p2;
    private final List<TINTriangle> adjacentTriangles = new ArrayList<TINTriangle>();

    protected TINTriangle(Position p0, Position p1, Position p2) {
        super(p0, p1, p2, p0);
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
    }

    protected Circle getCircumCicle() {
        List<Position> reducedVertices = this.reduce();
        CoordinateReferenceSystem crs = reducedVertices.get(1).getCoordinateReferenceSystem();
        double x1 = reducedVertices.get(1).getCoordinate()[0];
        double y1 = reducedVertices.get(1).getCoordinate()[1];
        double x2 = reducedVertices.get(2).getCoordinate()[0];
        double y2 = reducedVertices.get(2).getCoordinate()[1];
        double t = 0.5 * (x1 * x1 + y1 * y1 - x1 * x2 - y1 * y2) / (y1 * x2 - x1 * y2);
        Position2D center = new Position2D(crs, x2 / 2.0 - t * y2 + this.p0.getCoordinate()[0], y2 / 2.0 + t * x2 + this.p0.getCoordinate()[1]);
        return new Circle(center.getDirectPosition(), center.distance(new Position2D(this.p0)));
    }

    public List<TINTriangle> subTriangles(Position newVertex) {
        ArrayList<TINTriangle> triangles = new ArrayList<TINTriangle>();
        TINTriangle trigA = new TINTriangle(this.p0, this.p1, newVertex);
        TINTriangle trigB = new TINTriangle(this.p1, this.p2, newVertex);
        TINTriangle trigC = new TINTriangle(this.p2, this.p0, newVertex);
        try {
            trigA.addAdjacentTriangle(trigB);
            trigA.addAdjacentTriangle(trigC);
            trigB.addAdjacentTriangle(trigA);
            trigB.addAdjacentTriangle(trigC);
            trigC.addAdjacentTriangle(trigA);
            trigC.addAdjacentTriangle(trigB);
        }
        catch (TriangulationException triangulationException) {
            // empty catch block
        }
        trigA.tryToAddAdjacent(this.getAdjacentTriangles());
        trigB.tryToAddAdjacent(this.getAdjacentTriangles());
        trigC.tryToAddAdjacent(this.getAdjacentTriangles());
        triangles.add(trigA);
        triangles.add(trigB);
        triangles.add(trigC);
        for (TINTriangle trig : this.getAdjacentTriangles()) {
            trig.removeAdjacent(this);
        }
        return triangles;
    }

    protected int tryToAddAdjacent(List<TINTriangle> adjacents) {
        Iterator<TINTriangle> i = adjacents.iterator();
        int count = 0;
        while (i.hasNext()) {
            try {
                TINTriangle candidate = i.next();
                if (candidate.isAdjacent(this) && !this.adjacentTriangles.contains(candidate)) {
                    this.addAdjacentTriangle(candidate);
                }
                if (!candidate.isAdjacent(this) || candidate.adjacentTriangles.contains(this)) continue;
                candidate.addAdjacentTriangle(this);
                ++count;
            }
            catch (TriangulationException triangulationException) {}
        }
        return count;
    }

    protected boolean addAdjacentTriangle(TINTriangle adjacent) throws TriangulationException {
        if (this.isAdjacent(adjacent)) {
            this.adjacentTriangles.add(adjacent);
            return true;
        }
        return false;
    }

    private boolean isAdjacent(TINTriangle adjacent) throws TriangulationException {
        int identicalVertices = 0;
        if (adjacent.hasVertex(this.p0)) {
            ++identicalVertices;
        }
        if (adjacent.hasVertex(this.p1)) {
            ++identicalVertices;
        }
        if (adjacent.hasVertex(this.p2)) {
            ++identicalVertices;
        }
        if (identicalVertices == 3) {
            throw new TriangulationException("Same triangle");
        }
        return identicalVertices == 2;
    }

    public List<TINTriangle> getAdjacentTriangles() {
        return this.adjacentTriangles;
    }

    protected void removeAdjacent(TINTriangle remAdjacent) {
        this.adjacentTriangles.remove(remAdjacent);
    }
}

