/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Map;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.ConicProjection;
import org.geotools.api.referencing.operation.Conversion;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.CylindricalProjection;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.Operation;
import org.geotools.api.referencing.operation.OperationMethod;
import org.geotools.api.referencing.operation.PlanarProjection;
import org.geotools.api.referencing.operation.Projection;
import org.geotools.api.referencing.operation.Transformation;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.operation.DefaultConicProjection;
import org.geotools.referencing.operation.DefaultConversion;
import org.geotools.referencing.operation.DefaultCylindricalProjection;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.operation.DefaultPlanarProjection;
import org.geotools.referencing.operation.DefaultProjection;
import org.geotools.referencing.operation.DefaultSingleOperation;
import org.geotools.referencing.operation.DefaultTransformation;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.PassThroughTransform;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.util.UnsupportedImplementationException;

public class DefaultOperation
extends DefaultSingleOperation
implements Operation {
    private static final long serialVersionUID = -8923365753849532179L;
    protected final OperationMethod method;

    DefaultOperation(Conversion definition, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) {
        super(definition, sourceCRS, targetCRS, transform);
        this.method = definition.getMethod();
    }

    public DefaultOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform, OperationMethod method) {
        super(properties, sourceCRS, targetCRS, transform);
        DefaultOperation.ensureNonNull("method", method);
        DefaultOperationMethod.checkDimensions(method, transform);
        this.method = method;
    }

    public static CoordinateOperation create(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform, OperationMethod method, Class<? extends CoordinateOperation> type) {
        if (method != null) {
            Class<? extends Operation> candidate;
            if (method instanceof MathTransformProvider && (candidate = ((MathTransformProvider)method).getOperationType()) != null && type.isAssignableFrom(candidate)) {
                type = candidate.asSubclass(type);
            }
            if (type != null) {
                if (Transformation.class.isAssignableFrom(type)) {
                    return new DefaultTransformation(properties, sourceCRS, targetCRS, transform, method);
                }
                if (ConicProjection.class.isAssignableFrom(type)) {
                    return new DefaultConicProjection(properties, sourceCRS, targetCRS, transform, method);
                }
                if (CylindricalProjection.class.isAssignableFrom(type)) {
                    return new DefaultCylindricalProjection(properties, sourceCRS, targetCRS, transform, method);
                }
                if (PlanarProjection.class.isAssignableFrom(type)) {
                    return new DefaultPlanarProjection(properties, sourceCRS, targetCRS, transform, method);
                }
                if (Projection.class.isAssignableFrom(type)) {
                    return new DefaultProjection(properties, sourceCRS, targetCRS, transform, method);
                }
                if (Conversion.class.isAssignableFrom(type)) {
                    return new DefaultConversion(properties, sourceCRS, targetCRS, transform, method);
                }
            }
            return new DefaultOperation(properties, sourceCRS, targetCRS, transform, method);
        }
        return new DefaultSingleOperation(properties, sourceCRS, targetCRS, transform);
    }

    @Override
    public OperationMethod getMethod() {
        return this.method;
    }

    @Override
    public ParameterValueGroup getParameterValues() throws UnsupportedOperationException {
        return DefaultOperation.getParameterValues(this.transform, this.method.getParameters(), true);
    }

    private static ParameterValueGroup getParameterValues(MathTransform mt, ParameterDescriptorGroup descriptor, boolean required) {
        while (mt != null) {
            ParameterValueGroup param;
            if (mt instanceof ConcatenatedTransform) {
                ConcatenatedTransform ct = (ConcatenatedTransform)mt;
                ParameterValueGroup param1 = DefaultOperation.getParameterValues(ct.transform1, descriptor, false);
                ParameterValueGroup param2 = DefaultOperation.getParameterValues(ct.transform2, descriptor, false);
                if (param1 == null && param2 != null) {
                    return param2;
                }
                if (param2 == null && param1 != null) {
                    return param1;
                }
                required = true;
            }
            if (mt instanceof AbstractMathTransform && (param = ((AbstractMathTransform)mt).getParameterValues()) != null) {
                return param;
            }
            if (!(mt instanceof PassThroughTransform)) break;
            mt = ((PassThroughTransform)mt).getSubTransform();
        }
        if (required) {
            throw new UnsupportedImplementationException(mt.getClass());
        }
        return null;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (super.equals(object, compareMetadata)) {
            DefaultOperation that = (DefaultOperation)object;
            if (compareMetadata) {
                return DefaultOperation.equals(this.method, that.method, compareMetadata);
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.method.hashCode();
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        String name = super.formatWKT(formatter);
        DefaultOperation.append(formatter, this.method, "METHOD");
        return name;
    }
}

