/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.gridshift;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.geotools.api.referencing.FactoryException;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.referencing.factory.gridshift.NADConGridShift;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.URLs;
import org.geotools.util.factory.BufferedFactory;
import org.geotools.util.logging.Logging;

public class NADCONGridShiftFactory
extends ReferencingFactory
implements BufferedFactory {
    private static final int GRID_CACHE_HARD_REFERENCES = 10;
    protected static final Logger LOGGER = Logging.getLogger(NADCONGridShiftFactory.class);
    private SoftValueHashMap<NADCONKey, NADConGridShift> gridCache = new SoftValueHashMap(10);

    public NADConGridShift loadGridShift(URL latGridURL, URL longGridURL) throws FactoryException {
        NADCONKey key = new NADCONKey(latGridURL.toExternalForm(), longGridURL.toExternalForm());
        SoftValueHashMap<NADCONKey, NADConGridShift> softValueHashMap = this.gridCache;
        synchronized (softValueHashMap) {
            NADConGridShift grid = this.gridCache.get(key);
            if (grid != null) {
                return grid;
            }
            grid = this.loadGridShiftInternal(latGridURL, longGridURL);
            if (grid != null) {
                this.gridCache.put(key, grid);
                return grid;
            }
            throw new FactoryException("NTv2 Grid " + latGridURL + ", " + longGridURL + " could not be created.");
        }
    }

    private NADConGridShift loadGridShiftInternal(URL latGridURL, URL longGridURL) throws FactoryException {
        String latGridName = URLs.urlToFile(latGridURL).getPath();
        String longGridName = URLs.urlToFile(longGridURL).getPath();
        try {
            if (latGridName.endsWith(".las") && longGridName.endsWith(".los") || latGridName.endsWith(".LAS") && longGridName.endsWith(".LOS")) {
                return this.loadBinaryGrid(latGridURL, longGridURL);
            }
            if (latGridName.endsWith(".laa") && longGridName.endsWith(".loa") || latGridName.endsWith(".LAA") && longGridName.endsWith(".LOA")) {
                return this.loadTextGrid(latGridURL, longGridURL);
            }
            throw new FactoryException(MessageFormat.format("Unsupported file type: {0} or {1}", latGridName.substring(latGridName.lastIndexOf(46) + 1), longGridName.substring(longGridName.lastIndexOf(46) + 1)));
        }
        catch (IOException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof FactoryException) {
                throw (FactoryException)cause;
            }
            throw new FactoryException(exception.getLocalizedMessage(), exception);
        }
    }

    private NADConGridShift loadBinaryGrid(URL latGridUrl, URL longGridUrl) throws IOException, FactoryException {
        int HEADER_BYTES = 96;
        int SEPARATOR_BYTES = 4;
        int DESCRIPTION_LENGTH = 64;
        NADConGridShift gridShift = null;
        try (ReadableByteChannel latChannel = this.getReadChannel(latGridUrl);
             ReadableByteChannel longChannel = this.getReadChannel(longGridUrl);){
            ByteBuffer latBuffer = this.fillBuffer(latChannel, 96);
            ByteBuffer longBuffer = this.fillBuffer(longChannel, 96);
            latBuffer.position(latBuffer.position() + 64);
            int nc = latBuffer.getInt();
            int nr = latBuffer.getInt();
            int nz = latBuffer.getInt();
            float xmin = latBuffer.getFloat();
            float dx = latBuffer.getFloat();
            float ymin = latBuffer.getFloat();
            float dy = latBuffer.getFloat();
            float angle = latBuffer.getFloat();
            float xmax = xmin + (float)(nc - 1) * dx;
            float ymax = ymin + (float)(nr - 1) * dy;
            longBuffer.position(longBuffer.position() + 64);
            if (nc != longBuffer.getInt() || nr != longBuffer.getInt() || nz != longBuffer.getInt() || xmin != longBuffer.getFloat() || dx != longBuffer.getFloat() || ymin != longBuffer.getFloat() || dy != longBuffer.getFloat() || angle != longBuffer.getFloat()) {
                throw new FactoryException("Latitude and Longitude grid locations are not equal");
            }
            int RECORD_LENGTH = nc * 4 + 4;
            int NUM_BYTES_LEFT = (nr + 1) * RECORD_LENGTH - 96;
            int START_OF_DATA = RECORD_LENGTH - 96;
            latBuffer = this.fillBuffer(latChannel, NUM_BYTES_LEFT);
            latBuffer.position(START_OF_DATA);
            longBuffer = this.fillBuffer(longChannel, NUM_BYTES_LEFT);
            longBuffer.position(START_OF_DATA);
            gridShift = new NADConGridShift(xmin, ymin, xmax, ymax, dx, dy, nc, nr);
            int i = 0;
            int j = 0;
            for (i = 0; i < nr; ++i) {
                latBuffer.position(latBuffer.position() + 4);
                longBuffer.position(longBuffer.position() + 4);
                for (j = 0; j < nc; ++j) {
                    gridShift.setLocalizationPoint(j, i, longBuffer.getFloat(), latBuffer.getFloat());
                }
            }
            assert (i == nr) : i;
            assert (j == nc) : j;
        }
        return gridShift;
    }

    private ByteBuffer fillBuffer(ReadableByteChannel channel, int numBytes) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(numBytes);
        if (this.fill(buf, channel) == -1) {
            throw new EOFException("Premature end of data file");
        }
        buf.flip();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        return buf;
    }

    private int fill(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        int r = buffer.remaining();
        while (buffer.remaining() > 0 && r != -1) {
            r = channel.read(buffer);
        }
        if (r == -1) {
            buffer.limit(buffer.position());
        }
        return r;
    }

    private ReadableByteChannel getReadChannel(URL url) throws IOException {
        ReadableByteChannel channel = null;
        if (url.getProtocol().equals("file")) {
            File file = URLs.urlToFile(url);
            if (!file.exists() || !file.canRead()) {
                throw new IOException(MessageFormat.format("File does not exist or is unreadable: {0}", file));
            }
            FileInputStream in = new FileInputStream(file);
            channel = in.getChannel();
        } else {
            InputStream in = url.openConnection().getInputStream();
            channel = Channels.newChannel(in);
        }
        return channel;
    }

    private NADConGridShift loadTextGrid(URL latGridUrl, URL longGridUrl) throws IOException, FactoryException {
        try (BufferedReader latBr = new BufferedReader(new InputStreamReader(latGridUrl.openStream()));){
            NADConGridShift nADConGridShift;
            try (BufferedReader longBr = new BufferedReader(new InputStreamReader(longGridUrl.openStream()));){
                latBr.readLine();
                String latLine = latBr.readLine();
                if (latLine == null) {
                    throw new IOException("Invalid lat grid file, does not contain a grid");
                }
                StringTokenizer latSt = new StringTokenizer(latLine, " ");
                if (latSt.countTokens() != 8) {
                    String arg0 = String.valueOf(latSt.countTokens());
                    throw new FactoryException(MessageFormat.format("Grid header has unexpected length: {0}", arg0));
                }
                int nc = Integer.parseInt(latSt.nextToken());
                int nr = Integer.parseInt(latSt.nextToken());
                int nz = Integer.parseInt(latSt.nextToken());
                float xmin = Float.parseFloat(latSt.nextToken());
                float dx = Float.parseFloat(latSt.nextToken());
                float ymin = Float.parseFloat(latSt.nextToken());
                float dy = Float.parseFloat(latSt.nextToken());
                float angle = Float.parseFloat(latSt.nextToken());
                float xmax = xmin + (float)(nc - 1) * dx;
                float ymax = ymin + (float)(nr - 1) * dy;
                longBr.readLine();
                String longLine = longBr.readLine();
                if (longLine == null) {
                    throw new IOException("Invalid lon grid file, does not contain a grid");
                }
                StringTokenizer longSt = new StringTokenizer(longLine, " ");
                if (longSt.countTokens() != 8) {
                    String arg0 = String.valueOf(longSt.countTokens());
                    throw new FactoryException(MessageFormat.format("Grid header has unexpected length: {0}", arg0));
                }
                if (nc != Integer.parseInt(longSt.nextToken()) || nr != Integer.parseInt(longSt.nextToken()) || nz != Integer.parseInt(longSt.nextToken()) || xmin != Float.parseFloat(longSt.nextToken()) || dx != Float.parseFloat(longSt.nextToken()) || ymin != Float.parseFloat(longSt.nextToken()) || dy != Float.parseFloat(longSt.nextToken()) || angle != Float.parseFloat(longSt.nextToken())) {
                    throw new FactoryException("Latitude and Longitude grid locations are not equal");
                }
                NADConGridShift gridShift = new NADConGridShift(xmin, ymin, xmax, ymax, dx, dy, nc, nr);
                int i = 0;
                int j = 0;
                for (i = 0; i < nr; ++i) {
                    j = 0;
                    while (j < nc) {
                        latLine = latBr.readLine();
                        if (latLine == null) {
                            throw new IOException("Was expecting one more line in the lat file");
                        }
                        latSt = new StringTokenizer(latLine, " ");
                        longLine = longBr.readLine();
                        if (longLine == null) {
                            throw new IOException("Was expecting one more line in the lat file");
                        }
                        longSt = new StringTokenizer(longLine, " ");
                        while (latSt.hasMoreTokens() && longSt.hasMoreTokens()) {
                            gridShift.setLocalizationPoint(j, i, Float.parseFloat(longSt.nextToken()), Float.parseFloat(latSt.nextToken()));
                            ++j;
                        }
                    }
                }
                assert (i == nr) : i;
                assert (j == nc) : j;
                nADConGridShift = gridShift;
            }
            return nADConGridShift;
        }
    }

    static final class NADCONKey {
        String latFile;
        String longFile;

        public NADCONKey(String latFile, String longFile) {
            this.latFile = latFile;
            this.longFile = longFile;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.latFile == null ? 0 : this.latFile.hashCode());
            result = 31 * result + (this.longFile == null ? 0 : this.longFile.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NADCONKey other = (NADCONKey)obj;
            if (this.latFile == null ? other.latFile != null : !this.latFile.equals(other.latFile)) {
                return false;
            }
            return !(this.longFile == null ? other.longFile != null : !this.longFile.equals(other.longFile));
        }
    }
}

