/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.metadata.extent.Extent;
import org.geotools.api.metadata.extent.GeographicBoundingBox;
import org.geotools.api.metadata.extent.GeographicExtent;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.crs.CompoundCRS;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeneralDerivedCRS;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.crs.SingleCRS;
import org.geotools.api.referencing.crs.TemporalCRS;
import org.geotools.api.referencing.crs.VerticalCRS;
import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.api.referencing.cs.CartesianCS;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.api.referencing.cs.EllipsoidalCS;
import org.geotools.api.referencing.datum.Datum;
import org.geotools.api.referencing.datum.Ellipsoid;
import org.geotools.api.referencing.datum.GeodeticDatum;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.CoordinateOperationFactory;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.Projection;
import org.geotools.api.referencing.operation.SingleOperation;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.GeneralPosition;
import org.geotools.geometry.util.XRectangle2D;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.Command;
import org.geotools.referencing.DefaultAuthorityFactory;
import org.geotools.referencing.EnvelopeReprojector;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.operation.AbstractCoordinateOperation;
import org.geotools.referencing.operation.DefaultConcatenatedOperation;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.referencing.operation.DefaultTransformation;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.util.CRSUtilities;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.UnsupportedImplementationException;
import org.geotools.util.Version;
import org.geotools.util.factory.Factory;
import org.geotools.util.factory.FactoryNotFoundException;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public final class CRS {
    static final Logger LOGGER = Logging.getLogger(CRS.class);
    static volatile AtomicBoolean FORCED_LON_LAT = null;
    private static final Hints FORCE_LONGITUDE_FIRST_AXIS_ORDER = new Hints(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.TRUE);
    private static CRSAuthorityFactory defaultFactory;
    private static CRSAuthorityFactory xyFactory;
    private static volatile CoordinateOperationFactory strictFactory;
    private static volatile CoordinateOperationFactory lenientFactory;
    private static SoftValueHashMap<String, CoordinateReferenceSystem> defaultCache;
    private static SoftValueHashMap<String, CoordinateReferenceSystem> xyCache;
    private static SoftValueHashMap<String, CoordinateReferenceSystem> wktCache;

    private CRS() {
    }

    public static synchronized CRSAuthorityFactory getAuthorityFactory(boolean longitudeFirst) throws FactoryRegistryException {
        CRSAuthorityFactory factory;
        CRSAuthorityFactory cRSAuthorityFactory = factory = longitudeFirst ? xyFactory : defaultFactory;
        if (factory == null) {
            try {
                CRS.updateForcedLonLat();
                factory = new DefaultAuthorityFactory(longitudeFirst);
                if (longitudeFirst) {
                    xyFactory = factory;
                } else {
                    defaultFactory = factory;
                }
            }
            catch (NoSuchElementException exception) {
                throw new FactoryNotFoundException(null, exception);
            }
        }
        return factory;
    }

    private static void updateForcedLonLat() {
        boolean forcedLonLat = false;
        try {
            forcedLonLat = Boolean.getBoolean("org.geotools.referencing.forceXY") || Boolean.TRUE.equals(Hints.getSystemDefault(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER));
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to determine if we are in forced lon/lat mode", e);
        }
        FORCED_LON_LAT = new AtomicBoolean(forcedLonLat);
    }

    private static boolean isForcedLonLat() {
        if (FORCED_LON_LAT == null) {
            CRS.updateForcedLonLat();
        }
        return FORCED_LON_LAT.get();
    }

    public static boolean isCompatible(CoordinateReferenceSystem sourceCrs, CoordinateReferenceSystem targetCrs, boolean allowDifferentDimension) {
        if (sourceCrs == null || targetCrs == null) {
            return true;
        }
        if (CRS.equalsIgnoreMetadata(sourceCrs, targetCrs)) {
            return true;
        }
        if (!allowDifferentDimension && sourceCrs.getCoordinateSystem().getDimension() != targetCrs.getCoordinateSystem().getDimension()) {
            return false;
        }
        try {
            return CRS.findMathTransform(sourceCrs, targetCrs, true) != null;
        }
        catch (FactoryException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CoordinateOperationFactory getCoordinateOperationFactory(boolean lenient) {
        CoordinateOperationFactory factory;
        CoordinateOperationFactory coordinateOperationFactory = factory = lenient ? lenientFactory : strictFactory;
        if (factory != null) return factory;
        Class<CRS> clazz = CRS.class;
        synchronized (CRS.class) {
            CoordinateOperationFactory coordinateOperationFactory2 = factory = lenient ? lenientFactory : strictFactory;
            if (factory != null) return factory;
            Hints hints = GeoTools.getDefaultHints();
            if (lenient) {
                hints.put(Hints.LENIENT_DATUM_SHIFT, Boolean.TRUE);
            }
            factory = ReferencingFactoryFinder.getCoordinateOperationFactory(hints);
            if (lenient) {
                lenientFactory = factory;
            } else {
                strictFactory = factory;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return factory;
        }
    }

    public static Version getVersion(String authority) throws FactoryRegistryException {
        Factory factory;
        CRSAuthorityFactory candidate = ReferencingFactoryFinder.getCRSAuthorityFactory(authority, null);
        HashSet<Factory> guard = new HashSet<Factory>();
        while (candidate instanceof Factory && guard.add(factory = (Factory)((Object)candidate))) {
            Map<RenderingHints.Key, ?> hints = factory.getImplementationHints();
            Object version = hints.get(Hints.VERSION);
            if (version instanceof Version) {
                return (Version)version;
            }
            candidate = hints.get(Hints.CRS_AUTHORITY_FACTORY);
        }
        return null;
    }

    public static Set<String> getSupportedCodes(String authority) {
        return DefaultAuthorityFactory.getSupportedCodes(authority);
    }

    public static Set<String> getSupportedAuthorities(boolean returnAliases) {
        return DefaultAuthorityFactory.getSupportedAuthorities(returnAliases);
    }

    public static CoordinateReferenceSystem decode(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return CRS.decode(code, false);
    }

    public static CoordinateReferenceSystem decode(String code, boolean longitudeFirst) throws NoSuchAuthorityCodeException, FactoryException {
        code = code.trim().toUpperCase();
        CoordinateReferenceSystem result = longitudeFirst ? defaultCache.get(code) : xyCache.get(code);
        if (result == null) {
            result = CRS.getAuthorityFactory(longitudeFirst).createCoordinateReferenceSystem(code);
            if (longitudeFirst) {
                defaultCache.put(code, result);
            } else {
                xyCache.put(code, result);
            }
        }
        return result;
    }

    public static CoordinateReferenceSystem parseWKT(String wkt) throws FactoryException {
        CoordinateReferenceSystem result = wktCache.get(wkt);
        if (result == null) {
            result = ReferencingFactoryFinder.getCRSFactory(null).createFromWKT(wkt);
            wktCache.put(wkt, result);
        }
        return result;
    }

    public static Bounds getEnvelope(CoordinateReferenceSystem crs) {
        GeneralBounds envelope = null;
        GeneralBounds merged = null;
        GeographicBoundingBox bounds = CRS.getGeographicBoundingBox(crs);
        if (bounds != null && !Boolean.FALSE.equals(bounds.getInclusion())) {
            envelope = merged = new GeneralBounds(new double[]{bounds.getWestBoundLongitude(), bounds.getSouthBoundLatitude()}, new double[]{bounds.getEastBoundLongitude(), bounds.getNorthBoundLatitude()});
            SingleCRS targetCRS = CRS.getHorizontalCRS(crs);
            GeographicCRS sourceCRS = CRSUtilities.getStandardGeographicCRS2D(targetCRS);
            merged.setCoordinateReferenceSystem(sourceCRS);
            try {
                envelope = CRS.transform(envelope, targetCRS);
            }
            catch (TransformException exception) {
                envelope = null;
                CRS.unexpectedException("getEnvelope", exception);
            }
            merged.setCoordinateReferenceSystem(targetCRS);
        }
        return envelope;
    }

    public static GeographicBoundingBox getGeographicBoundingBox(CoordinateReferenceSystem crs) {
        Extent domainOfValidity;
        GeographicBoundingBox bounds = null;
        GeographicBoundingBoxImpl merged = null;
        if (crs != null && (domainOfValidity = crs.getDomainOfValidity()) != null) {
            for (GeographicExtent geographicExtent : domainOfValidity.getGeographicElements()) {
                if (!(geographicExtent instanceof GeographicBoundingBox)) continue;
                GeographicBoundingBox candidate = (GeographicBoundingBox)geographicExtent;
                if (bounds == null) {
                    bounds = candidate;
                    continue;
                }
                if (merged == null) {
                    merged = new GeographicBoundingBoxImpl(bounds);
                    bounds = merged;
                }
                merged.add(candidate);
            }
        }
        return bounds;
    }

    public static SingleCRS getHorizontalCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof SingleCRS) {
            CoordinateSystem cs = crs.getCoordinateSystem();
            int dimension = cs.getDimension();
            if (dimension == 2) {
                CoordinateReferenceSystem base = crs;
                while (base instanceof GeneralDerivedCRS) {
                    base = ((GeneralDerivedCRS)base).getBaseCRS();
                }
                if (base instanceof GeographicCRS) {
                    return (SingleCRS)crs;
                }
                if (base.getCoordinateSystem() instanceof CartesianCS) {
                    return (SingleCRS)crs;
                }
            } else if (dimension >= 3 && crs instanceof GeographicCRS) {
                CoordinateSystemAxis axis0 = null;
                CoordinateSystemAxis axis1 = null;
                int count = 0;
                block9: for (int i = 0; i < dimension; ++i) {
                    CoordinateSystemAxis axis = cs.getAxis(i);
                    if (!DefaultCoordinateSystemAxis.isCompassDirection(axis.getDirection())) continue;
                    switch (count++) {
                        case 0: {
                            axis0 = axis;
                            continue block9;
                        }
                        case 1: {
                            axis1 = axis;
                            continue block9;
                        }
                    }
                }
                if (count == 2) {
                    GeographicCRS horizontalCRS;
                    EllipsoidalCS horizontalCS;
                    GeodeticDatum datum = ((GeographicCRS)crs).getDatum();
                    Map<String, ?> properties = CRSUtilities.changeDimensionInName(cs, "3D", "2D");
                    try {
                        horizontalCS = ReferencingFactoryFinder.getCSFactory(null).createEllipsoidalCS(properties, axis0, axis1);
                    }
                    catch (FactoryException e) {
                        Logging.recoverableException(CRS.class, "getHorizontalCRS", e);
                        horizontalCS = new DefaultEllipsoidalCS(properties, axis0, axis1);
                    }
                    properties = CRSUtilities.changeDimensionInName(crs, "3D", "2D");
                    try {
                        horizontalCRS = ReferencingFactoryFinder.getCRSFactory(null).createGeographicCRS(properties, datum, horizontalCS);
                    }
                    catch (FactoryException e) {
                        Logging.recoverableException(CRS.class, "getHorizontalCRS", e);
                        horizontalCRS = new DefaultGeographicCRS(properties, datum, horizontalCS);
                    }
                    return horizontalCRS;
                }
            }
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            for (CoordinateReferenceSystem c : cp.getCoordinateReferenceSystems()) {
                SingleCRS candidate = CRS.getHorizontalCRS(c);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static ProjectedCRS getProjectedCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof ProjectedCRS) {
            return (ProjectedCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            for (CoordinateReferenceSystem c : cp.getCoordinateReferenceSystems()) {
                ProjectedCRS candidate = CRS.getProjectedCRS(c);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static MapProjection getMapProjection(CoordinateReferenceSystem crs) {
        ProjectedCRS projectedCRS = CRS.getProjectedCRS(crs);
        if (projectedCRS == null) {
            return null;
        }
        Projection conversion = projectedCRS.getConversionFromBase();
        MathTransform mt = conversion.getMathTransform();
        return CRS.unrollProjection(mt);
    }

    private static MapProjection unrollProjection(MathTransform mt) {
        if (mt instanceof MapProjection) {
            return (MapProjection)mt;
        }
        if (mt instanceof ConcatenatedTransform) {
            ConcatenatedTransform ct = (ConcatenatedTransform)mt;
            MapProjection result = CRS.unrollProjection(ct.transform1);
            if (result == null) {
                result = CRS.unrollProjection(ct.transform2);
            }
            return result;
        }
        return null;
    }

    public static VerticalCRS getVerticalCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof VerticalCRS) {
            return (VerticalCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            for (CoordinateReferenceSystem c : cp.getCoordinateReferenceSystems()) {
                VerticalCRS candidate = CRS.getVerticalCRS(c);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static TemporalCRS getTemporalCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof TemporalCRS) {
            return (TemporalCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            for (CoordinateReferenceSystem c : cp.getCoordinateReferenceSystems()) {
                TemporalCRS candidate = CRS.getTemporalCRS(c);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static Ellipsoid getEllipsoid(CoordinateReferenceSystem crs) {
        Datum datum = CRSUtilities.getDatum(crs);
        if (datum instanceof GeodeticDatum) {
            return ((GeodeticDatum)datum).getEllipsoid();
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            for (CoordinateReferenceSystem c : cp.getCoordinateReferenceSystems()) {
                Ellipsoid candidate = CRS.getEllipsoid(c);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static boolean equalsIgnoreMetadata(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 instanceof AbstractIdentifiedObject && object2 instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object1).equals((AbstractIdentifiedObject)object2, false);
        }
        return object1 != null && object1.equals(object2);
    }

    public static boolean isTransformationRequired(CoordinateReferenceSystem source, CoordinateReferenceSystem target) throws FactoryException {
        if (source == null || target == null) {
            return false;
        }
        if (source instanceof DefaultEngineeringCRS && ((DefaultEngineeringCRS)source).isWildcard()) {
            return false;
        }
        if (target instanceof DefaultEngineeringCRS && ((DefaultEngineeringCRS)target).isWildcard()) {
            return false;
        }
        if (CRS.equalsIgnoreMetadata(source, target)) {
            return false;
        }
        MathTransform mathTransform = CRS.findMathTransform(source, target);
        return !mathTransform.isIdentity();
    }

    public static String toSRS(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return null;
        }
        if (CRS.isForcedLonLat() && CRS.getAxisOrder(crs, false) == AxisOrder.NORTH_EAST) {
            try {
                Integer code = CRS.lookupEpsgCode(crs, false);
                if (code != null) {
                    return "urn:ogc:def:crs:EPSG::" + code;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Failed to determine EPSG code", e);
            }
        }
        if (crs == DefaultGeographicCRS.WGS84) {
            return "CRS:84";
        }
        Set<ReferenceIdentifier> identifiers = crs.getIdentifiers();
        if (identifiers.isEmpty()) {
            ReferenceIdentifier name = crs.getName();
            if (name != null) {
                return name.toString();
            }
            return null;
        }
        for (ReferenceIdentifier identifier : crs.getIdentifiers()) {
            String srs = identifier.toString();
            if (!srs.contains("EPSG:") && !srs.contains("CRS:")) continue;
            return srs;
        }
        ReferenceIdentifier name = crs.getName();
        if (name != null && (name.toString().contains("EPSG:") || name.toString().contains("CRS:"))) {
            return name.toString();
        }
        return identifiers.iterator().next().toString();
    }

    public static String toSRS(CoordinateReferenceSystem crs, boolean codeOnly) {
        if (crs == null) {
            return null;
        }
        String srsName = CRS.toSRS(crs);
        if (codeOnly && srsName != null) {
            int index = srsName.lastIndexOf(58);
            if (index > 0) {
                srsName = srsName.substring(index + 1).trim();
            }
            return srsName;
        }
        return srsName;
    }

    public static String lookupIdentifier(IdentifiedObject object, boolean fullScan) throws FactoryException {
        AbstractAuthorityFactory xyFactory = (AbstractAuthorityFactory)((Object)CRS.getAuthorityFactory(true));
        IdentifiedObjectFinder finder = xyFactory.getIdentifiedObjectFinder(object.getClass());
        finder.setFullScanAllowed(fullScan);
        return finder.findIdentifier(object);
    }

    public static String lookupIdentifier(Citation authority, CoordinateReferenceSystem crs, boolean fullScan) throws FactoryException {
        ReferenceIdentifier id = AbstractIdentifiedObject.getIdentifier(crs, authority);
        if (id != null) {
            return id.getCode();
        }
        for (CRSAuthorityFactory factory : ReferencingFactoryFinder.getCRSAuthorityFactories(FORCE_LONGITUDE_FIRST_AXIS_ORDER)) {
            if (!Citations.identifierMatches(factory.getAuthority(), authority) || !(factory instanceof AbstractAuthorityFactory)) continue;
            AbstractAuthorityFactory f = (AbstractAuthorityFactory)((Object)factory);
            IdentifiedObjectFinder finder = f.getIdentifiedObjectFinder(crs.getClass());
            finder.setFullScanAllowed(fullScan);
            String code = finder.findIdentifier(crs);
            if (code == null) continue;
            return code;
        }
        return null;
    }

    public static Integer lookupEpsgCode(CoordinateReferenceSystem crs, boolean fullScan) throws FactoryException {
        String identifier = CRS.lookupIdentifier(Citations.EPSG, crs, fullScan);
        if (identifier != null) {
            int split = identifier.lastIndexOf(58);
            String code = identifier.substring(split + 1);
            try {
                return Integer.parseInt(code);
            }
            catch (NumberFormatException e) {
                throw new FactoryException(MessageFormat.format("\"{0}\" is not a valid identifier.", identifier), e);
            }
        }
        return null;
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException {
        return CRS.findMathTransform(sourceCRS, targetCRS, false);
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, String transformCode) throws FactoryException {
        Map<String, AbstractCoordinateOperation> transforms = CRS.getTransforms(sourceCRS, targetCRS);
        MathTransform ret = null;
        for (Map.Entry<String, AbstractCoordinateOperation> entry : transforms.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(transformCode)) continue;
            ret = entry.getValue().getMathTransform();
        }
        if (ret == null) {
            LOGGER.info("No transform matching " + transformCode + " can be found");
            ret = CRS.findMathTransform(sourceCRS, targetCRS);
        }
        return ret;
    }

    public static Map<String, AbstractCoordinateOperation> getTransforms(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException {
        Set<CoordinateOperation> ops = CRS.getCoordinateOperationFactory(true).findOperations(sourceCRS, targetCRS);
        HashMap<String, AbstractCoordinateOperation> transforms = new HashMap<String, AbstractCoordinateOperation>();
        for (CoordinateOperation op : ops) {
            if (op instanceof DefaultConcatenatedOperation) {
                for (SingleOperation opx : ((DefaultConcatenatedOperation)op).getOperations()) {
                    if (!opx.getClass().isAssignableFrom(DefaultTransformation.class)) continue;
                    for (ReferenceIdentifier id : opx.getIdentifiers()) {
                        transforms.put(id.toString(), (DefaultConcatenatedOperation)op);
                    }
                }
                continue;
            }
            if (!(op instanceof DefaultTransformation)) continue;
            for (ReferenceIdentifier id : op.getIdentifiers()) {
                transforms.put(id.toString(), (DefaultTransformation)op);
            }
        }
        return transforms;
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, boolean lenient) throws FactoryException {
        if (CRS.equalsIgnoreMetadata(sourceCRS, targetCRS)) {
            return IdentityTransform.create(sourceCRS.getCoordinateSystem().getDimension());
        }
        CoordinateOperationFactory operationFactory = CRS.getCoordinateOperationFactory(lenient);
        return operationFactory.createOperation(sourceCRS, targetCRS).getMathTransform();
    }

    public static GeneralBounds transform(Bounds envelope, CoordinateReferenceSystem targetCRS) throws TransformException {
        CoordinateReferenceSystem sourceCRS;
        if (envelope != null && targetCRS != null && (sourceCRS = envelope.getCoordinateReferenceSystem()) != null) {
            if (!CRS.equalsIgnoreMetadata(sourceCRS, targetCRS)) {
                CoordinateOperation operation;
                CoordinateOperationFactory factory = CRS.getCoordinateOperationFactory(true);
                try {
                    operation = factory.createOperation(sourceCRS, targetCRS);
                }
                catch (FactoryException exception) {
                    throw new TransformException("Can't transform envelope.", exception);
                }
                if (!operation.getMathTransform().isIdentity()) {
                    envelope = CRS.transform(operation, envelope);
                } else if (!CRS.equalsIgnoreMetadata(envelope.getCoordinateReferenceSystem(), targetCRS)) {
                    GeneralBounds tx = new GeneralBounds(envelope);
                    tx.setCoordinateReferenceSystem(targetCRS);
                    envelope = tx;
                }
            }
            assert (CRS.equalsIgnoreMetadata(envelope.getCoordinateReferenceSystem(), targetCRS));
        }
        return GeneralBounds.toGeneralEnvelope(envelope);
    }

    public static GeneralBounds transform(MathTransform transform, Bounds envelope) throws TransformException {
        return CRS.transform(transform, envelope, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    static GeneralBounds transform(MathTransform transform, Bounds envelope, GeneralPosition targetPt) throws TransformException {
        int n;
        if (envelope == null) {
            return null;
        }
        if (transform.isIdentity()) {
            GeneralBounds e = new GeneralBounds(envelope);
            e.setCoordinateReferenceSystem(null);
            if (targetPt != null) {
                int i = envelope.getDimension();
                while (--i >= 0) {
                    targetPt.setOrdinate(i, e.getMedian(i));
                }
            }
            return e;
        }
        int sourceDim = transform.getSourceDimensions();
        if (envelope.getDimension() != sourceDim) {
            Integer arg1 = envelope.getDimension();
            throw new MismatchedDimensionException(MessageFormat.format("Mismatched object dimension: {0}D and {1}D.", sourceDim, arg1));
        }
        int coordinateNumber = 0;
        GeneralBounds transformed = null;
        if (targetPt == null) {
            targetPt = new GeneralPosition(transform.getTargetDimensions());
        }
        GeneralPosition sourcePt = new GeneralPosition(sourceDim);
        int i = sourceDim;
        while (--i >= 0) {
            sourcePt.setOrdinate(i, envelope.getMinimum(i));
        }
        block9: while (true) {
            if (targetPt != transform.transform(sourcePt, targetPt)) {
                throw new UnsupportedImplementationException(transform.getClass());
            }
            if (transformed != null) {
                transformed.add(targetPt);
            } else {
                transformed = new GeneralBounds(targetPt, targetPt);
            }
            n = ++coordinateNumber;
            int i2 = sourceDim;
            block10: while (true) {
                if (--i2 < 0) {
                    return transformed;
                }
                switch (n % 5) {
                    case 0: {
                        sourcePt.setOrdinate(i2, envelope.getMinimum(i2));
                        n /= 5;
                        continue block10;
                    }
                    case 1: {
                        sourcePt.setOrdinate(i2, envelope.getMaximum(i2));
                        continue block9;
                    }
                    case 2: {
                        sourcePt.setOrdinate(i2, (envelope.getMinimum(i2) + envelope.getMedian(i2)) / 2.0);
                        continue block9;
                    }
                    case 3: {
                        sourcePt.setOrdinate(i2, (envelope.getMedian(i2) + envelope.getMaximum(i2)) / 2.0);
                        continue block9;
                    }
                    case 4: {
                        sourcePt.setOrdinate(i2, envelope.getMedian(i2));
                        continue block9;
                    }
                }
                break;
            }
            break;
        }
        throw new AssertionError(n);
    }

    public static GeneralBounds transform(CoordinateOperation operation, Bounds envelope) throws TransformException {
        return EnvelopeReprojector.transform(operation, envelope);
    }

    public static Rectangle2D transform(MathTransform2D transform, Rectangle2D rectangle) throws TransformException {
        return CRS.transform(transform, rectangle, (Rectangle2D)null);
    }

    public static Rectangle2D transform(MathTransform2D transform, Rectangle2D envelope, Rectangle2D destination) throws TransformException {
        return CRS.transform(transform, envelope, destination, new Point2D.Double());
    }

    private static Rectangle2D transform(MathTransform2D transform, Rectangle2D envelope, Rectangle2D destination, Point2D.Double point) throws TransformException {
        if (envelope == null) {
            return null;
        }
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i <= 8; ++i) {
            point.x = (i & 1) == 0 ? envelope.getMinX() : envelope.getMaxX();
            point.y = (i & 2) == 0 ? envelope.getMinY() : envelope.getMaxY();
            switch (i) {
                case 5: 
                case 6: {
                    point.x = envelope.getCenterX();
                    break;
                }
                case 8: {
                    point.x = envelope.getCenterX();
                }
                case 4: 
                case 7: {
                    point.y = envelope.getCenterY();
                }
            }
            if (point != transform.transform(point, point)) {
                throw new UnsupportedImplementationException(transform.getClass());
            }
            if (point.x < xmin) {
                xmin = point.x;
            }
            if (point.x > xmax) {
                xmax = point.x;
            }
            if (point.y < ymin) {
                ymin = point.y;
            }
            if (!(point.y > ymax)) continue;
            ymax = point.y;
        }
        if (destination != null) {
            destination.setRect(xmin, ymin, xmax - xmin, ymax - ymin);
        } else {
            destination = XRectangle2D.createFromExtremums(xmin, ymin, xmax, ymax);
        }
        assert (destination == envelope || !(destination instanceof Rectangle2D.Double) && !(destination instanceof Rectangle2D.Float) || XRectangle2D.equalsEpsilon(destination, CRS.transform(transform, new Rectangle2D.Double(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY())))) : destination;
        return destination;
    }

    public static Rectangle2D transform(CoordinateOperation operation, Rectangle2D envelope, Rectangle2D destination) throws TransformException {
        if (envelope == null) {
            return null;
        }
        GeneralBounds result = CRS.transform(operation, (Bounds)new GeneralBounds(envelope));
        if (destination == null) {
            return result.toRectangle2D();
        }
        destination.setFrame(result.getMinimum(0), result.getMinimum(1), result.getSpan(0), result.getSpan(1));
        return destination;
    }

    static void unexpectedException(String methodName, Exception exception) {
        Logging.unexpectedException(CRS.class, methodName, exception);
    }

    public static void reset(String aspects) {
        StringTokenizer tokens = new StringTokenizer(aspects, ", \t\n\r\f");
        while (tokens.hasMoreTokens()) {
            String aspect = tokens.nextToken().trim();
            boolean all = aspect.equalsIgnoreCase("all");
            if (all || aspect.equalsIgnoreCase("plugins")) {
                ReferencingFactoryFinder.reset();
                ReferencingFactoryFinder.scanForPlugins();
            }
            if (!all && !aspect.equalsIgnoreCase("warnings")) continue;
            MapProjection.resetWarnings();
        }
        xyCache.clear();
        defaultCache.clear();
        FORCED_LON_LAT = null;
        defaultFactory = null;
        xyFactory = null;
        strictFactory = null;
        lenientFactory = null;
    }

    public static void cleanupThreadLocals() {
        DefaultMathTransformFactory.cleanupThreadLocals();
        Formattable.cleanupThreadLocals();
    }

    public static AxisOrder getAxisOrder(CoordinateReferenceSystem crs) {
        return CRS.getAxisOrder(crs, false);
    }

    public static AxisOrder getAxisOrder(CoordinateReferenceSystem crs, boolean useBaseGeoCRS) {
        CoordinateSystem cs = null;
        if (crs instanceof CompoundCRS) {
            crs = ((CompoundCRS)crs).getCoordinateReferenceSystems().get(0);
        }
        if (crs instanceof ProjectedCRS) {
            cs = !useBaseGeoCRS ? crs.getCoordinateSystem() : ((ProjectedCRS)crs).getBaseCRS().getCoordinateSystem();
        } else if (crs instanceof GeographicCRS) {
            cs = crs.getCoordinateSystem();
        } else {
            return AxisOrder.INAPPLICABLE;
        }
        int dimension = cs.getDimension();
        int longitudeDim = -1;
        int latitudeDim = -1;
        for (int i = 0; i < dimension; ++i) {
            AxisDirection dir = cs.getAxis(i).getDirection().absolute();
            if (dir.equals(AxisDirection.EAST)) {
                longitudeDim = i;
            }
            if (!dir.equals(AxisDirection.NORTH)) continue;
            latitudeDim = i;
        }
        if (longitudeDim >= 0 && latitudeDim >= 0) {
            if (longitudeDim < latitudeDim) {
                return AxisOrder.EAST_NORTH;
            }
            return AxisOrder.NORTH_EAST;
        }
        String labelFirst = cs.getAxis(0).getAbbreviation();
        String labelSecond = cs.getAxis(1).getAbbreviation();
        if (labelFirst.equals(DefaultCoordinateSystemAxis.NORTHING.getAbbreviation()) && labelSecond.equals(DefaultCoordinateSystemAxis.EASTING.getAbbreviation())) {
            return AxisOrder.NORTH_EAST;
        }
        if (labelFirst.equals(DefaultCoordinateSystemAxis.EASTING.getAbbreviation()) && labelSecond.equals(DefaultCoordinateSystemAxis.NORTHING.getAbbreviation())) {
            return AxisOrder.EAST_NORTH;
        }
        return AxisOrder.INAPPLICABLE;
    }

    public static void main(String ... args) {
        Command.execute(args);
    }

    static {
        defaultCache = new SoftValueHashMap();
        xyCache = new SoftValueHashMap();
        wktCache = new SoftValueHashMap();
        GeoTools.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent e) {
                Class<CRS> clazz = CRS.class;
                synchronized (CRS.class) {
                    defaultFactory = null;
                    xyFactory = null;
                    strictFactory = null;
                    lenientFactory = null;
                    xyCache.clear();
                    wktCache.clear();
                    defaultCache.clear();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    public static enum AxisOrder {
        EAST_NORTH,
        NORTH_EAST,
        INAPPLICABLE;

    }
}

