/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import java.io.IOException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import org.geotools.measure.PrefixDefinition;
import org.geotools.measure.UnitDefinition;
import org.geotools.measure.UnitFormatter;
import tech.units.indriya.format.SimpleUnitFormat;

public class BaseUnitFormatter
extends SimpleUnitFormat
implements UnitFormatter {
    private static final char MIDDLE_DOT = '\u00b7';
    private static final char EXPONENT_ONE = '\u00b9';
    private static final char EXPONENT_TWO = '\u00b2';
    private static final char EXPONENT_THREE = '\u00b3';
    private SimpleUnitFormat delegateFormatter = SimpleUnitFormat.getNewInstance();
    @Deprecated
    private Map<String, Unit<?>> nameToUnit = new HashMap();
    @Deprecated
    private Map<Unit<?>, String> unitToName = new HashMap();

    public BaseUnitFormatter(UnitDefinition ... unitDefinitions) {
        this(Arrays.asList(unitDefinitions));
    }

    public BaseUnitFormatter(List<UnitDefinition> unitDefinitions) {
        for (UnitDefinition unitDefinition : unitDefinitions) {
            Unit<?> unit = unitDefinition.getUnit();
            String unitSymbol = unitDefinition.getSymbolOverride() != null ? unitDefinition.getSymbolOverride() : unit.getSymbol();
            this.label(unit, unitSymbol);
            for (PrefixDefinition prefix : unitDefinition.getPrefixes()) {
                this.addUnit(unit, unitSymbol, prefix);
            }
            for (String alias : unitDefinition.getAliases()) {
                this.alias(unit, alias);
            }
            for (PrefixDefinition prefix : unitDefinition.getPrefixes()) {
                for (String alias : unitDefinition.getAliases()) {
                    this.addAlias(unit, alias, prefix);
                }
            }
        }
    }

    @Deprecated
    public Map<Unit<?>, String> getUnitToSymbolMap() {
        return Collections.unmodifiableMap(this.unitToName);
    }

    @Deprecated
    public Map<String, Unit<?>> getSymbolToUnitMap() {
        return Collections.unmodifiableMap(this.nameToUnit);
    }

    protected void addUnit(Unit<?> unit) {
    }

    private void addUnit(Unit<?> unit, String unitSymbol, PrefixDefinition prefix) {
        this.nameToUnit.put(unitSymbol, unit);
        this.unitToName.put(unit, unitSymbol);
        Unit<?> prefixedUnit = unit.prefix(prefix.getPrefix());
        String prefixString = prefix.getPrefix().getSymbol();
        String prefixedSymbol = prefixString + unitSymbol;
        this.label(prefixedUnit, prefixedSymbol);
        for (String prefixAlias : prefix.getPrefixAliases()) {
            this.label(prefixedUnit, prefixAlias + unitSymbol);
        }
    }

    private void addAlias(Unit<?> unit, String unitSymbol, PrefixDefinition prefix) {
        this.nameToUnit.put(unitSymbol, unit);
        this.unitToName.put(unit, unitSymbol);
        Unit<?> prefixedUnit = unit.prefix(prefix.getPrefix());
        String prefixString = prefix.getPrefix().getSymbol();
        String prefixedSymbol = prefixString + unitSymbol;
        this.alias(prefixedUnit, prefixedSymbol);
        for (String prefixAlias : prefix.getPrefixAliases()) {
            this.alias(prefixedUnit, prefixAlias + unitSymbol);
        }
    }

    @Override
    public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
        return this.delegateFormatter.format(unit, appendable);
    }

    @Override
    public Unit<? extends Quantity> parseProductUnit(CharSequence csq, ParsePosition pos) throws MeasurementParseException {
        return this.delegateFormatter.parseProductUnit(csq, pos);
    }

    @Override
    public Unit<? extends Quantity> parseSingleUnit(CharSequence csq, ParsePosition pos) throws MeasurementParseException {
        return this.delegateFormatter.parseSingleUnit(csq, pos);
    }

    @Override
    public void label(Unit<?> unit, String label) {
        this.nameToUnit.put(label, unit);
        this.unitToName.put(unit, label);
        this.delegateFormatter.label(unit, label);
        this.addUnit(unit);
    }

    @Override
    public Unit<?> parse(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException {
        return this.delegateFormatter.parse(csq, cursor);
    }

    @Override
    public Unit<?> parse(CharSequence csq) throws MeasurementParseException {
        return this.delegateFormatter.parse(csq);
    }

    @Override
    protected Unit<?> parse(CharSequence csq, int index) throws IllegalArgumentException {
        return this.parse(csq, new ParsePosition(index));
    }

    @Override
    public void alias(Unit<?> unit, String alias) {
        this.nameToUnit.put(alias, unit);
        this.delegateFormatter.alias(unit, alias);
    }

    @Override
    protected boolean isValidIdentifier(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        return BaseUnitFormatter.isUnitIdentifierPart(name.charAt(0));
    }

    protected static boolean isUnitIdentifierPart(char ch) {
        return Character.isLetter(ch) || !Character.isWhitespace(ch) && !Character.isDigit(ch) && ch != '\u00b7' && ch != '*' && ch != '/' && ch != '(' && ch != ')' && ch != '[' && ch != ']' && ch != '\u00b9' && ch != '\u00b2' && ch != '\u00b3' && ch != '^' && ch != '+' && ch != '-';
    }
}

