/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.locationtech.jts.awt.ShapeWriter;
import org.locationtech.jts.geom.Geometry;

public class DrawableBitSet {
    BufferedImage image;
    WritableRaster raster;
    int[] pixel = new int[1];

    public DrawableBitSet(int width, int height) {
        this.image = new BufferedImage(width, height, 12);
        this.raster = this.image.getRaster();
    }

    public boolean get(int x, int y) {
        this.raster.getPixel(x, y, this.pixel);
        return this.pixel[0] > 0;
    }

    public void set(int x, int y) {
        this.pixel[0] = 1;
        this.raster.setPixel(x, y, this.pixel);
    }

    public void set(Geometry geom) {
        if (geom == null) {
            return;
        }
        this.set(new ShapeWriter().toShape(geom));
    }

    public void set(Shape shape) {
        Graphics2D g2d = this.image.createGraphics();
        g2d.setColor(Color.WHITE);
        g2d.draw(shape);
        g2d.fill(shape);
        g2d.dispose();
    }

    public BufferedImage getImage() {
        return this.image;
    }
}

