/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.http.DelegateHTTPClient;
import org.geotools.http.DelegateHTTPResponse;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPResponse;
import org.geotools.util.logging.Logging;

public class LoggingHTTPClient
extends DelegateHTTPClient {
    private String charsetName;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final Logger LOGGER = Logging.getLogger(LoggingHTTPClient.class);
    private int counter = 0;

    public LoggingHTTPClient(HTTPClient delegate) {
        this(delegate, "UTF-8");
    }

    public LoggingHTTPClient(HTTPClient delegate, String charsetName) {
        super(delegate);
        this.charsetName = charsetName;
    }

    @Override
    public HTTPResponse post(URL url, InputStream postContent, String postContentType) throws IOException {
        int myCount = ++this.counter;
        LOGGER.info(String.format("POST Request #%d URL: %s", myCount, url));
        if (LOGGER.isLoggable(Level.FINEST)) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            LoggingHTTPClient.copy(postContent, out);
            LOGGER.finest("POST Request Body: \n" + out.toString(this.charsetName));
            postContent = new ByteArrayInputStream(out.toByteArray());
        }
        return new LoggingHTTPResponse(this.delegate.post(url, postContent, postContentType), this.charsetName, myCount);
    }

    @Override
    public HTTPResponse post(URL url, InputStream postContent, String postContentType, Map<String, String> headers) throws IOException {
        int myCount = ++this.counter;
        LOGGER.info(String.format("POST Request #%d URL with additional headers %s : %s", myCount, headers, url));
        if (LOGGER.isLoggable(Level.FINEST)) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            LoggingHTTPClient.copy(postContent, out);
            LOGGER.finest("POST Request Body: \n" + out.toString(this.charsetName));
            postContent = new ByteArrayInputStream(out.toByteArray());
        }
        return new LoggingHTTPResponse(this.delegate.post(url, postContent, postContentType, headers), this.charsetName, myCount);
    }

    @Override
    public HTTPResponse get(URL url) throws IOException {
        int myCount = ++this.counter;
        LOGGER.info(String.format("GET Request #%d URL: %s", myCount, url));
        return new LoggingHTTPResponse(this.delegate.get(url), this.charsetName, myCount);
    }

    @Override
    public HTTPResponse get(URL url, Map<String, String> headers) throws IOException {
        int myCount = ++this.counter;
        LOGGER.info(String.format("GET Request #%d URL with additional headers %s : %s", myCount, headers, url));
        return new LoggingHTTPResponse(this.delegate.get(url, headers), this.charsetName, myCount);
    }

    static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }

    private class LoggingHTTPResponse
    extends DelegateHTTPResponse {
        private InputStream input;

        public LoggingHTTPResponse(HTTPResponse delegate, String charsetName, int myCount) throws IOException {
            super(delegate);
            LOGGER.info(String.format("Response #%d received.", myCount));
            if (LOGGER.isLoggable(Level.FINEST)) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                LoggingHTTPClient.copy(delegate.getResponseStream(), output);
                LOGGER.finest("Body: \n" + output.toString(charsetName));
                this.input = new ByteArrayInputStream(output.toByteArray());
            } else {
                this.input = delegate.getResponseStream();
            }
        }

        @Override
        public InputStream getResponseStream() throws IOException {
            return this.input;
        }
    }
}

