/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.temporal;

import org.geotools.api.filter.MultiValuedFilter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.temporal.BinaryTemporalOperator;
import org.geotools.api.temporal.Instant;
import org.geotools.api.temporal.Period;
import org.geotools.api.temporal.RelativePosition;
import org.geotools.api.temporal.TemporalGeometricPrimitive;
import org.geotools.api.temporal.TemporalPrimitive;
import org.geotools.filter.visitor.OperatorNameFilterVisitor;

public abstract class BinaryTemporalOperatorImpl
implements BinaryTemporalOperator {
    private static final OperatorNameFilterVisitor operationNameVisitor = new OperatorNameFilterVisitor();
    protected Expression e1;
    protected Expression e2;
    protected MultiValuedFilter.MatchAction matchAction;

    protected BinaryTemporalOperatorImpl(Expression e1, Expression e2) {
        this(e1, e2, MultiValuedFilter.MatchAction.ANY);
    }

    protected BinaryTemporalOperatorImpl(Expression e1, Expression e2, MultiValuedFilter.MatchAction matchAction) {
        this.e1 = e1;
        this.e2 = e2;
        this.matchAction = matchAction;
    }

    @Override
    public Expression getExpression1() {
        return this.e1;
    }

    @Override
    public Expression getExpression2() {
        return this.e2;
    }

    @Override
    public MultiValuedFilter.MatchAction getMatchAction() {
        return this.matchAction;
    }

    @Override
    public boolean evaluate(Object object) {
        TemporalPrimitive left = this.toTemporal(object, this.e1);
        TemporalPrimitive right = this.toTemporal(object, this.e2);
        if (left == null || right == null) {
            return false;
        }
        RelativePosition pos = left.relativePosition(right);
        return pos != null && this.doEvaluate(pos);
    }

    protected Instant toInstant(Object object, Expression e) {
        return e.evaluate(object, Instant.class);
    }

    protected Period toPeriod(Object object, Expression e) {
        return e.evaluate(object, Period.class);
    }

    protected TemporalPrimitive toTemporal(Object object, Expression e) {
        TemporalGeometricPrimitive p = this.toPeriod(object, e);
        if (p != null) {
            return p;
        }
        p = this.toInstant(object, e);
        if (p != null) {
            return p;
        }
        return null;
    }

    protected abstract boolean doEvaluate(RelativePosition var1);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.e1 == null ? 0 : this.e1.hashCode());
        result = 31 * result + (this.e2 == null ? 0 : this.e2.hashCode());
        result = 31 * result + (this.matchAction == null ? 0 : this.matchAction.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryTemporalOperatorImpl other = (BinaryTemporalOperatorImpl)obj;
        if (this.e1 == null ? other.e1 != null : !this.e1.equals(other.e1)) {
            return false;
        }
        if (this.e2 == null ? other.e2 != null : !this.e2.equals(other.e2)) {
            return false;
        }
        return this.matchAction == other.matchAction;
    }

    public String toString() {
        Object operator = this.accept(operationNameVisitor, null);
        return "[ " + this.getExpression1() + " " + operator + " " + this.getExpression2() + " ]";
    }
}

