/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.logging.Logger;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.JsonFunctionUtils;
import org.geotools.util.logging.Logging;

public class JsonArrayContainsFunction
extends FunctionExpressionImpl {
    private static final Logger LOGGER = Logging.getLogger(JsonArrayContainsFunction.class);
    private static final HashMap<String, JsonPointer> jsonPointerCache = new HashMap();
    private static final JsonToken END_OF_STREAM = null;
    private final JsonFactory factory = new JsonFactory();
    public static FunctionName NAME = new FunctionNameImpl("jsonArrayContains", Boolean.class, FunctionNameImpl.parameter("column", String.class), FunctionNameImpl.parameter("pointer", String.class), FunctionNameImpl.parameter("expected", String.class));

    public JsonArrayContainsFunction() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object object) {
        String json = this.getExpression(0).evaluate(object, String.class);
        boolean found = false;
        if (json != null) {
            try (JsonParser parser = this.factory.createParser(json);){
                found = this.checkExpected(parser, object);
            }
            catch (IOException e) {
                LOGGER.severe("Error when parsing the JSON: " + json + ". Exception: " + e.getLocalizedMessage());
                throw new RuntimeException(e);
            }
        }
        return found;
    }

    private boolean checkExpected(JsonParser parser, Object object) throws IOException {
        String pointerSpec = this.getExpression(1).evaluate(object, String.class);
        String expected = this.getExpression(2).evaluate(object, String.class);
        boolean found = false;
        JsonPointer expectedPointer = jsonPointerCache.getOrDefault(pointerSpec, JsonPointer.compile((String)pointerSpec));
        jsonPointerCache.put(pointerSpec, expectedPointer);
        while (parser.nextToken() != END_OF_STREAM && !found) {
            JsonPointer pointer = parser.getParsingContext().pathAsPointer();
            if (!pointer.equals((Object)expectedPointer) || parser.currentTokenId() != 3) continue;
            StringWriter writer = new StringWriter();
            try (JsonGenerator generator = this.factory.createGenerator((Writer)writer);){
                JsonFunctionUtils.serializeArray(parser, generator);
            }
            found = writer.toString().contains(expected);
        }
        return found;
    }
}

