/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sort;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureReader;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.DelegateSimpleFeatureReader;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.sort.FeatureBlockReader;
import org.geotools.data.sort.MergeSortReader;
import org.geotools.data.sort.SimpleFeatureIO;
import org.geotools.data.sort.SortedFeatureReader;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Geometry;

class MergeSortDumper {
    MergeSortDumper() {
    }

    static final boolean canSort(SimpleFeatureType schema, SortBy ... sortBy) {
        if (sortBy == SortBy.UNSORTED) {
            return true;
        }
        for (AttributeDescriptor ad : schema.getAttributeDescriptors()) {
            Class<?> binding = ad.getType().getBinding();
            if (Serializable.class.isAssignableFrom(binding)) continue;
            return false;
        }
        for (SortBy sb : sortBy) {
            if (sb == SortBy.NATURAL_ORDER || sb == SortBy.REVERSE_ORDER) continue;
            AttributeDescriptor ad = schema.getDescriptor(sb.getPropertyName().getPropertyName());
            if (ad == null) {
                return false;
            }
            Class<?> binding = ad.getType().getBinding();
            if (Comparable.class.isAssignableFrom(binding) && !Geometry.class.isAssignableFrom(binding)) continue;
            return false;
        }
        return true;
    }

    static SimpleFeatureReader getDelegateReader(SimpleFeatureReader reader, Query query) throws IOException {
        int maxFeatures = MergeSortDumper.getMaxFeatures(query);
        return MergeSortDumper.getDelegateReader(reader, query.getSortBy(), maxFeatures);
    }

    static int getMaxFeatures(Query query) {
        Hints hints = null;
        if (query != null) {
            hints = query.getHints();
        }
        int maxFeatures = 1000;
        if (hints != null && hints.get(Hints.MAX_MEMORY_SORT) != null) {
            maxFeatures = (Integer)hints.get(Hints.MAX_MEMORY_SORT);
        } else if (Hints.getSystemDefault(Hints.MAX_MEMORY_SORT) != null) {
            maxFeatures = (Integer)Hints.getSystemDefault(Hints.MAX_MEMORY_SORT);
        }
        return maxFeatures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SimpleFeatureReader getDelegateReader(SimpleFeatureReader reader, SortBy[] sortBy, int maxFeatures) throws IOException {
        Comparator<SimpleFeature> comparator;
        if (maxFeatures < 0) {
            maxFeatures = MergeSortDumper.getMaxFeatures(Query.ALL);
        }
        if ((comparator = SortedFeatureReader.getComparator(sortBy, (SimpleFeatureType)reader.getFeatureType())) == null) {
            return reader;
        }
        SimpleFeatureType schema = (SimpleFeatureType)reader.getFeatureType();
        if (!MergeSortDumper.canSort(schema, sortBy)) {
            throw new IllegalArgumentException("The specified reader cannot be sorted, either the sorting properties are not comparable or the attributes are not serializable: " + ((SimpleFeatureType)reader.getFeatureType()).getTypeName() + "\n " + Arrays.toString(sortBy));
        }
        int count = 0;
        File file = null;
        SimpleFeatureIO io = null;
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        ArrayList<FeatureBlockReader> readers = new ArrayList<FeatureBlockReader>();
        boolean cleanFile = true;
        try {
            while (reader.hasNext()) {
                SimpleFeature f = (SimpleFeature)reader.next();
                features.add(f);
                if (++count <= maxFeatures) continue;
                Collections.sort(features, comparator);
                if (io == null) {
                    file = File.createTempFile("sorted", ".features");
                    file.delete();
                    io = new SimpleFeatureIO(file, schema);
                }
                FeatureBlockReader fbr = MergeSortDumper.storeToFile(io, features);
                readers.add(fbr);
                count = 0;
                features.clear();
            }
            if (count > 0 && io != null) {
                Collections.sort(features, comparator);
                file = File.createTempFile("sorted", ".features");
                file.delete();
                FeatureBlockReader fbr = MergeSortDumper.storeToFile(io, features);
                readers.add(fbr);
            }
            if (io == null) {
                Collections.sort(features, comparator);
                SimpleFeatureIterator fi = new ListFeatureCollection(schema, features).features();
                DelegateSimpleFeatureReader delegateSimpleFeatureReader = new DelegateSimpleFeatureReader(schema, fi);
                return delegateSimpleFeatureReader;
            }
            cleanFile = false;
            MergeSortReader mergeSortReader = new MergeSortReader(schema, io, readers, comparator);
            return mergeSortReader;
        }
        finally {
            if (cleanFile && io != null) {
                io.close(true);
                file.delete();
            }
            reader.close();
        }
    }

    static FeatureBlockReader storeToFile(SimpleFeatureIO io, List<SimpleFeature> features) throws IOException {
        long start = io.getOffset();
        for (SimpleFeature sf : features) {
            io.write(sf);
        }
        return new FeatureBlockReader(io, start, features.size());
    }
}

