/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import java.io.IOException;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.memory.MemoryFeatureSource;
import org.geotools.data.memory.MemoryFeatureWriter;
import org.geotools.data.memory.MemoryState;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class MemoryFeatureStore
extends ContentFeatureStore {
    MemoryFeatureSource delegate;

    public MemoryFeatureStore(ContentEntry entry, Query query) {
        super(entry, query);
        this.delegate = new MemoryFeatureSource(this.entry, this.query){

            @Override
            public void setTransaction(Transaction transaction) {
                super.setTransaction(transaction);
                MemoryFeatureStore.this.setTransaction(transaction);
            }
        };
    }

    @Override
    public MemoryState getState() {
        return (MemoryState)super.getState();
    }

    @Override
    protected FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(Query query, int flags) throws IOException {
        return new MemoryFeatureWriter(this.getState(), query);
    }

    @Override
    public void setTransaction(Transaction transaction) {
        super.setTransaction(transaction);
        if (this.delegate.getTransaction() != transaction) {
            this.delegate.setTransaction(transaction);
        }
    }

    @Override
    protected SimpleFeatureType buildFeatureType() throws IOException {
        return this.delegate.buildFeatureType();
    }

    @Override
    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        return this.delegate.getBoundsInternal(query);
    }

    @Override
    protected int getCountInternal(Query query) throws IOException {
        return this.delegate.getCountInternal(query);
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return this.delegate.getReaderInternal(query);
    }

    @Override
    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return this.delegate.handleVisitor(query, visitor);
    }

    @Override
    protected QueryCapabilities buildQueryCapabilities() {
        return new QueryCapabilities(){

            @Override
            public boolean isUseProvidedFIDSupported() {
                return true;
            }
        };
    }
}

