/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.algebra.AlgebraDescriptor;
import java.awt.image.RenderedImage;
import java.util.Map;
import javax.media.jai.ParameterBlockJAI;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.util.NumberRange;

public class AddConst
extends OperationJAI {
    private static final String OPERATION_CONST = "operationConst";
    private static final String ADD_CONST = "AddConst";
    private static final long serialVersionUID = 5443686039059774671L;

    public AddConst() {
        super(ADD_CONST, AddConst.getOperationDescriptor(JAIExt.getOperationName(ADD_CONST)));
    }

    @Override
    public String getName() {
        return ADD_CONST;
    }

    @Override
    protected NumberRange<? extends Number> deriveRange(NumberRange<? extends Number>[] ranges, OperationJAI.Parameters parameters) {
        double[] constants = (double[])parameters.parameters.getObjectParameter("constants");
        if (constants.length == 1) {
            double c = constants[0];
            NumberRange<? extends Number> range = ranges[0];
            double min = range.getMinimum() + c;
            double max = range.getMaximum() + c;
            return NumberRange.create(min, max);
        }
        return super.deriveRange(ranges, parameters);
    }

    @Override
    protected void handleJAIEXTParams(ParameterBlockJAI parameters, ParameterValueGroup parameters2) {
        GridCoverage2D source = (GridCoverage2D)parameters2.parameter("source0").getValue();
        if (JAIExt.isJAIExtOperation(OPERATION_CONST)) {
            parameters.set((Object)AlgebraDescriptor.Operator.SUM, 1);
        }
        AddConst.handleROINoDataInternal(parameters, source, OPERATION_CONST, 2, 3);
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform gridToCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        return AddConst.handleROINoDataProperties(null, parameters.parameters, sources[0], OPERATION_CONST, 2, 3, 4);
    }
}

