/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.impl;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.geotools.api.coverage.CannotEvaluateException;
import org.geotools.api.coverage.PointOutsideCoverageException;
import org.geotools.api.coverage.SampleDimension;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.coverage.grid.GridGeometry;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.Record;
import org.geotools.api.util.RecordType;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.io.GridCoverageResponse;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;

public class DefaultGridCoverageResponse
implements GridCoverageResponse {
    private GridCoverage gridCoverage;
    private DateRange temporalExtent;
    private NumberRange<Double> verticalExtent;

    public DefaultGridCoverageResponse(GridCoverage gridCoverage, DateRange temporalExtent, NumberRange<Double> verticalExtent) {
        this.temporalExtent = temporalExtent;
        this.verticalExtent = verticalExtent;
        this.gridCoverage = gridCoverage;
    }

    @Override
    public DateRange getTemporalExtent() {
        return this.temporalExtent;
    }

    @Override
    public NumberRange<Double> getVerticalExtent() {
        return this.verticalExtent;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.gridCoverage.getCoordinateReferenceSystem();
    }

    @Override
    public Bounds getEnvelope() {
        return this.gridCoverage.getEnvelope();
    }

    @Override
    public RecordType getRangeType() {
        return this.gridCoverage.getRangeType();
    }

    @Override
    public Set<Record> evaluate(Position p, Collection<String> list) throws PointOutsideCoverageException, CannotEvaluateException {
        return this.gridCoverage.evaluate(p, list);
    }

    @Override
    public Object evaluate(Position point) throws PointOutsideCoverageException, CannotEvaluateException {
        return this.gridCoverage.evaluate(point);
    }

    @Override
    public boolean[] evaluate(Position point, boolean[] destination) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        return this.gridCoverage.evaluate(point, destination);
    }

    @Override
    public byte[] evaluate(Position point, byte[] destination) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        return this.gridCoverage.evaluate(point, destination);
    }

    @Override
    public int[] evaluate(Position point, int[] destination) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        return this.gridCoverage.evaluate(point, destination);
    }

    @Override
    public float[] evaluate(Position point, float[] destination) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        return this.gridCoverage.evaluate(point, destination);
    }

    @Override
    public double[] evaluate(Position point, double[] destination) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        return this.gridCoverage.evaluate(point, destination);
    }

    @Override
    public int getNumSampleDimensions() {
        return this.gridCoverage.getNumSampleDimensions();
    }

    @Override
    public SampleDimension getSampleDimension(int index) throws IndexOutOfBoundsException {
        return this.gridCoverage.getSampleDimension(index);
    }

    @Override
    public RenderableImage getRenderableImage(int xAxis, int yAxis) throws UnsupportedOperationException, IndexOutOfBoundsException {
        return this.gridCoverage.getRenderableImage(xAxis, yAxis);
    }

    @Override
    public boolean isDataEditable() {
        return this.gridCoverage.isDataEditable();
    }

    @Override
    public GridGeometry getGridGeometry() {
        return this.gridCoverage.getGridGeometry();
    }

    @Override
    public int[] getOptimalDataBlockSizes() {
        return this.gridCoverage.getOptimalDataBlockSizes();
    }

    @Override
    public int getNumOverviews() {
        return this.gridCoverage.getNumOverviews();
    }

    @Override
    public GridGeometry getOverviewGridGeometry(int index) throws IndexOutOfBoundsException {
        return this.gridCoverage.getOverviewGridGeometry(index);
    }

    @Override
    public GridCoverage getOverview(int index) throws IndexOutOfBoundsException {
        return this.gridCoverage.getOverview(index);
    }

    @Override
    public List<GridCoverage> getSources() {
        return this.gridCoverage.getSources();
    }

    @Override
    public RenderedImage getRenderedImage() {
        return this.gridCoverage.getRenderedImage();
    }

    @Override
    public GridCoverage2D getGridCoverage2D() {
        return (GridCoverage2D)this.gridCoverage;
    }
}

