/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.webp.chunks;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.webp.chunks.WebPChunk;

public final class WebPChunkVp8x
extends WebPChunk {
    private final boolean hasIcc;
    private final boolean hasAlpha;
    private final boolean hasExif;
    private final boolean hasXmp;
    private final boolean hasAnimation;
    private final int canvasWidth;
    private final int canvasHeight;

    public WebPChunkVp8x(int type, int size, byte[] bytes) throws ImagingException {
        super(type, size, bytes);
        if (size != 10) {
            throw new ImagingException("VP8X chunk size must be 10");
        }
        int mark = bytes[0] & 0xFF;
        this.hasIcc = (mark & 0x20) != 0;
        this.hasAlpha = (mark & 0x10) != 0;
        this.hasExif = (mark & 8) != 0;
        this.hasXmp = (mark & 4) != 0;
        this.hasAnimation = (mark & 2) != 0;
        this.canvasWidth = (bytes[4] & 0xFF) + ((bytes[5] & 0xFF) << 8) + ((bytes[6] & 0xFF) << 16) + 1;
        this.canvasHeight = (bytes[7] & 0xFF) + ((bytes[8] & 0xFF) << 8) + ((bytes[9] & 0xFF) << 16) + 1;
        if (this.canvasWidth * this.canvasHeight < 0) {
            throw new ImagingException("Illegal canvas size");
        }
    }

    @Override
    public void dump(PrintWriter pw, int offset) throws ImagingException, IOException {
        super.dump(pw, offset);
        pw.println("  ICCP: " + this.hasIcc());
        pw.println("  Alpha: " + this.hasAlpha());
        pw.println("  EXIF: " + this.hasExif());
        pw.println("  XMP: " + this.hasXmp());
        pw.println("  Animation: " + this.hasAnimation());
        pw.println("  Canvas Width: " + this.getCanvasWidth());
        pw.println("  Canvas Height: " + this.getCanvasHeight());
    }

    public int getCanvasHeight() {
        return this.canvasHeight;
    }

    public int getCanvasWidth() {
        return this.canvasWidth;
    }

    public boolean hasAlpha() {
        return this.hasAlpha;
    }

    public boolean hasAnimation() {
        return this.hasAnimation;
    }

    public boolean hasExif() {
        return this.hasExif;
    }

    public boolean hasIcc() {
        return this.hasIcc;
    }

    public boolean hasXmp() {
        return this.hasXmp;
    }
}

