/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common.historic;

import javax.measure.MetricPrefix;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Length;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Time;
import si.uom.quantity.DynamicViscosity;
import si.uom.quantity.KinematicViscosity;
import tech.units.indriya.AbstractSystemOfUnits;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.unit.ProductUnit;
import tech.units.indriya.unit.Units;

public final class CGS
extends AbstractSystemOfUnits {
    private static final String SYSTEM_NAME = "Centimetre\u2013gram\u2013second System of Units";
    static final int AVOIRDUPOIS_POUND_DIVIDEND = 45359237;
    static final int AVOIRDUPOIS_POUND_DIVISOR = 100000000;
    private static final CGS INSTANCE = new CGS();
    public static final Unit<Length> CENTIMETRE = CGS.addUnit(MetricPrefix.CENTI(Units.METRE), Length.class);
    public static final Unit<Mass> GRAM = CGS.addUnit(Units.GRAM, Mass.class);
    public static final Unit<Time> SECOND = CGS.addUnit(Units.SECOND, Time.class);
    public static final Unit<Speed> CENTIMETRE_PER_SECOND = CGS.addUnit(CENTIMETRE.divide(SECOND).asType(Speed.class), "centimetre per second", "cm/s");
    public static final Unit<Acceleration> GAL = CGS.addUnit(new ProductUnit(CENTIMETRE_PER_SECOND.divide(SECOND)).asType(Acceleration.class), "Gal", "Gal");
    public static final Unit<Energy> ERG = CGS.addUnit(Units.JOULE.divide(1.0E7), "Erg", "erg");
    public static final Unit<Force> DYNE = CGS.addUnit(Units.NEWTON.divide(100000.0), "Dyne", "dyn");
    public static final Unit<Power> ERG_PER_SECOND = CGS.addUnit(ERG.divide(SECOND).asType(Power.class), "Erg per second", "erg/s");
    public static final Unit<Pressure> BARYE = CGS.addUnit(Units.PASCAL.divide(10.0), "Barye", "Ba");
    public static final Unit<DynamicViscosity> POISE = CGS.addUnit(GRAM.divide(MetricPrefix.CENTI(Units.METRE).multiply(SECOND)).asType(DynamicViscosity.class), "Poise", "P");
    public static final Unit<KinematicViscosity> STOKES = CGS.addUnit(MetricPrefix.CENTI(Units.METRE).pow(2).divide(SECOND).asType(KinematicViscosity.class), "Stokes", "St");
    public static final Unit<KinematicViscosity> KAYSER = CGS.addUnit(AbstractUnit.ONE.divide(CENTIMETRE).asType(KinematicViscosity.class), "Kayser", "cm\u207b\u00b9");

    private CGS() {
    }

    public static CGS getInstance() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return SYSTEM_NAME;
    }

    private static <U extends Unit<?>> U addUnit(U unit, Class<? extends Quantity<?>> type) {
        CGS.INSTANCE.units.add(unit);
        CGS.INSTANCE.quantityToUnit.put(type, unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text, boolean isLabel) {
        if (isLabel && text != null) {
            SimpleUnitFormat.getInstance().label(unit, text);
        }
        if (name != null && unit instanceof AbstractUnit) {
            return AbstractSystemOfUnits.Helper.addUnit(CGS.INSTANCE.units, unit, name);
        }
        CGS.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text) {
        return CGS.addUnit(unit, name, text, true);
    }
}

