/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.schema.impl;

import java.io.IOException;
import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.geotools.xml.PrintHandler;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.AttributeValue;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementValue;
import org.geotools.xml.schema.Facet;
import org.geotools.xml.schema.SimpleType;
import org.geotools.xml.schema.impl.AttributeGT;
import org.geotools.xml.schema.impl.AttributeValueGT;
import org.geotools.xml.schema.impl.ElementValueGT;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SimpleTypeGT
implements SimpleType {
    private int finaL;
    private String id;
    private String name;
    private URI namespace;
    private SimpleType[] parents = null;
    private int type = 0;
    private Facet[] constraints;

    private SimpleTypeGT() {
    }

    public SimpleTypeGT(String id, String name, URI namespace, int type, SimpleType[] parents, Facet[] constraints, int finaL) {
        this.id = id;
        this.name = name;
        this.namespace = namespace;
        this.parents = parents;
        this.type = type;
        this.constraints = constraints;
        if (constraints != null) {
            for (int i = 0; i < constraints.length; ++i) {
                if (constraints[i] != null) continue;
                throw new NullPointerException(name + " constraint #" + i + " is null");
            }
        }
    }

    @Override
    public Class getInstanceType() {
        return this.parents[0].getInstanceType();
    }

    @Override
    public Element findChildElement(String name1) {
        return null;
    }

    @Override
    public int getFinal() {
        return this.finaL;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getNamespace() {
        return this.namespace;
    }

    @Override
    public SimpleType[] getParents() {
        return this.parents;
    }

    @Override
    public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map<String, Object> hints) throws OperationNotSupportedException, SAXException {
        if (value == null || value.length != 1) {
            throw new SAXException("can only have one text value ... and one is required");
        }
        if (this.type == 1) {
            return this.getUnionValue(element, value[0], attrs, hints);
        }
        if (this.type == 2) {
            return this.getListValue(element, value[0], attrs, hints);
        }
        return this.getRestValue(element, value[0], attrs, hints);
    }

    private Object getUnionValue(Element element, ElementValue value, Attributes attrs, Map<String, Object> hints) throws OperationNotSupportedException, SAXException {
        if (this.parents == null) {
            return null;
        }
        ElementValue[] valss = new ElementValue[]{value};
        for (SimpleType parent : this.parents) {
            Object o = parent.getValue(element, valss, attrs, hints);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    private Object getListValue(Element element, ElementValue value, Attributes attrs, Map<String, Object> hints) throws OperationNotSupportedException, SAXException {
        if (this.parents == null || this.parents[0] == null) {
            return null;
        }
        String[] vals = ((String)value.getValue()).split("\\s");
        LinkedList<Object> l = new LinkedList<Object>();
        ElementValue[] valss = new ElementValueGT[1];
        for (String val : vals) {
            valss[0] = new ElementValueGT(value.getElement(), val);
            l.add(this.parents[0].getValue(element, valss, attrs, hints));
        }
        valss[0] = new ElementValueGT(value.getElement(), l);
        return valss[0];
    }

    private Object getRestValue(Element element, ElementValue value, Attributes attrs, Map<String, Object> hints) throws OperationNotSupportedException, SAXException {
        if (this.parents == null || this.parents[0] == null) {
            return null;
        }
        if (this.constraints == null) {
            return null;
        }
        if (this.constraints.length == 0) {
            ElementValue[] t = new ElementValue[]{value};
            return this.parents[0].getValue(element, t, attrs, hints);
        }
        String val = (String)value.getValue();
        if (val != null && this.constraints[0].getFacetType() == 1) {
            for (Facet constraint : this.constraints) {
                if (!val.equalsIgnoreCase(constraint.getValue())) continue;
                ElementValue[] t = new ElementValue[]{value};
                return this.parents[0].getValue(element, t, attrs, hints);
            }
            return null;
        }
        Number nval = null;
        Date dval = null;
        ElementValue[] t = new ElementValue[]{value};
        Object o = this.parents[0].getValue(element, t, attrs, hints);
        if (o instanceof Number) {
            nval = (Number)o;
        }
        if (o instanceof Date) {
            dval = (Date)o;
        }
        block22: for (Facet constraint : this.constraints) {
            switch (constraint.getFacetType()) {
                case 1: {
                    continue block22;
                }
                case 2: {
                    int decimals = val.length() - val.indexOf(".");
                    int maxDec = Integer.parseInt(constraint.getValue());
                    if (decimals <= maxDec) continue block22;
                    throw new SAXException("Too many decimal places");
                }
                case 3: {
                    int maxLength = Integer.parseInt(constraint.getValue());
                    if (val.length() == maxLength) continue block22;
                    throw new SAXException("Too long places");
                }
                case 4: {
                    Comparable<Double> max;
                    if (nval != null) {
                        max = Double.valueOf(constraint.getValue());
                        if (nval.doubleValue() > max) {
                            throw new SAXException("Too large a value");
                        }
                    }
                    if (dval == null) continue block22;
                    try {
                        max = DateFormat.getDateTimeInstance().parse(constraint.getValue());
                    }
                    catch (ParseException e) {
                        throw new SAXException(e);
                    }
                    if (!dval.after((Date)max)) continue block22;
                    throw new SAXException("Too large a value");
                }
                case 5: {
                    Comparable<Double> max;
                    if (nval != null) {
                        max = Double.valueOf(constraint.getValue());
                        if (nval.doubleValue() >= max) {
                            throw new SAXException("Too large a value");
                        }
                    }
                    if (dval != null) {
                        try {
                            max = DateFormat.getDateTimeInstance().parse(constraint.getValue());
                        }
                        catch (ParseException e) {
                            throw new SAXException(e);
                        }
                        if (dval.compareTo((Date)max) > 0) {
                            throw new SAXException("Too large a value");
                        }
                    }
                }
                case 6: {
                    int maxLength = Integer.parseInt(constraint.getValue());
                    if (val.length() <= maxLength) continue block22;
                    throw new SAXException("Too long places");
                }
                case 7: {
                    Comparable<Double> max;
                    if (nval != null) {
                        max = Double.valueOf(constraint.getValue());
                        if (nval.doubleValue() < max) {
                            throw new SAXException("Too large a value");
                        }
                    }
                    if (dval != null) {
                        try {
                            max = DateFormat.getDateTimeInstance().parse(constraint.getValue());
                        }
                        catch (ParseException e) {
                            throw new SAXException(e);
                        }
                        if (dval.before((Date)max)) {
                            throw new SAXException("Too large a value");
                        }
                    }
                }
                case 8: {
                    Comparable<Double> max;
                    if (nval != null) {
                        max = Double.valueOf(constraint.getValue());
                        if (nval.doubleValue() <= max) {
                            throw new SAXException("Too large a value");
                        }
                    }
                    if (dval != null) {
                        try {
                            max = DateFormat.getDateTimeInstance().parse(constraint.getValue());
                        }
                        catch (ParseException e) {
                            throw new SAXException(e);
                        }
                        if (dval.compareTo((Date)max) < 0) {
                            throw new SAXException("Too large a value");
                        }
                    }
                }
                case 9: {
                    int maxLength = Integer.parseInt(constraint.getValue());
                    if (val.length() >= maxLength) continue block22;
                    throw new SAXException("Too short places");
                }
                case 10: {
                    if (val.split(constraint.getValue()).length == 0) continue block22;
                    throw new SAXException("Does not match pattern");
                }
                case 11: {
                    int maxLength = Integer.parseInt(constraint.getValue()) + 1;
                    if (val.length() <= maxLength) continue block22;
                    throw new SAXException("Too many digits");
                }
            }
        }
        return o;
    }

    @Override
    public int getChildType() {
        return this.type;
    }

    @Override
    public Facet[] getFacets() {
        return this.constraints;
    }

    @Override
    public AttributeValue toAttribute(Attribute attribute, Object value, Map<String, Object> hints) throws OperationNotSupportedException {
        if (value == null) {
            return null;
        }
        if (this.type == 1) {
            for (SimpleType parent : this.parents) {
                if (!parent.equals(attribute.getSimpleType()) || !parent.canCreateAttributes(attribute, value, hints)) continue;
                return parent.toAttribute(attribute, value, hints);
            }
            return this.parents[0].toAttribute(attribute, value, hints);
        }
        if (this.type == 2) {
            List l = (List)value;
            Iterator i = l.iterator();
            Object s = "";
            if (i.hasNext()) {
                String t = this.parents[0].toAttribute(attribute, i.next(), hints).getValue();
                s = t.toString();
                while (i.hasNext()) {
                    t = this.parents[0].toAttribute(attribute, i.next(), hints).getValue();
                    s = (String)s + " " + t.toString();
                }
            }
            return new AttributeValueGT(attribute, (String)s);
        }
        return this.parents[0].toAttribute(attribute, value, hints);
    }

    @Override
    public boolean canCreateAttributes(Attribute attribute, Object value, Map<String, Object> hints) {
        if (value == null) {
            return false;
        }
        if (this.type == 1) {
            for (SimpleType parent : this.parents) {
                if (!parent.equals(attribute.getSimpleType()) || !parent.canCreateAttributes(attribute, value, hints)) continue;
                return true;
            }
            return false;
        }
        if (this.type == 2) {
            return this.parents[0].canCreateAttributes(attribute, value, hints);
        }
        return this.parents[0].canCreateAttributes(attribute, value, hints);
    }

    @Override
    public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
        if (value == null) {
            return false;
        }
        if (this.type == 1) {
            for (SimpleType parent : this.parents) {
                if (!parent.equals(element.getType()) || !parent.canEncode(element, value, hints)) continue;
                return true;
            }
            return false;
        }
        if (this.type == 2) {
            return this.parents[0].canEncode(element, value, hints);
        }
        return this.parents[0].canEncode(element, value, hints);
    }

    @Override
    public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws IOException, OperationNotSupportedException {
        if (value == null) {
            return;
        }
        if (this.type == 1) {
            int n = 0;
            SimpleType[] simpleTypeArray = this.parents;
            int n2 = simpleTypeArray.length;
            if (n < n2) {
                SimpleType parent = simpleTypeArray[n];
                if (parent.equals(element.getType()) && parent.canEncode(element, value, hints)) {
                    parent.encode(element, value, output, hints);
                }
                return;
            }
            this.parents[0].encode(element, value, output, hints);
            return;
        }
        if (this.type == 2) {
            List l = (List)value;
            Iterator i = l.iterator();
            Object s = "";
            if (i.hasNext()) {
                String t = this.parents[0].toAttribute(new AttributeGT(null, null, this.namespace, this.parents[0], 0, null, null, false), value, hints).getValue();
                s = t.toString();
                while (i.hasNext()) {
                    t = this.parents[0].toAttribute(new AttributeGT(null, null, this.namespace, this.parents[0], 0, null, null, false), value, hints).getValue();
                    s = (String)s + " " + t.toString();
                }
            }
            this.parents[0].encode(element, s, output, hints);
            return;
        }
        this.parents[0].encode(element, value, output, hints);
    }
}

