/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.handlers;

import java.net.URI;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.Type;

public class XMLTypeHelper {
    public static Element findChildElement(Type type, String localName, URI namespaceURI) {
        if (type instanceof ComplexType) {
            Element found;
            ComplexType complexType = (ComplexType)type;
            ElementGrouping child = complexType.getChild();
            if (child != null && (found = child.findChildElement(localName, namespaceURI)) != null) {
                return found;
            }
            Element[] children = complexType.getChildElements();
            if (children == null || children.length == 0) {
                return null;
            }
            for (Element element : children) {
                if (!localName.equals(element.getName()) || !namespaceURI.equals(element.getNamespace())) continue;
                return element;
            }
            if (complexType.getParent() != null) {
                Type parent = complexType.getParent();
                return XMLTypeHelper.findChildElement(parent, localName, namespaceURI);
            }
        } else {
            return type.findChildElement(localName);
        }
        return null;
    }
}

