/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.geotools.api.style.Description;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.api.util.Cloneable;
import org.geotools.styling.AbstractSymbolizer;
import org.geotools.styling.DescriptionImpl;
import org.geotools.styling.GraphicImpl;
import org.geotools.util.SimpleInternationalString;

public class PointSymbolizerImpl
extends AbstractSymbolizer
implements PointSymbolizer,
Cloneable {
    private GraphicImpl graphic = new GraphicImpl();

    protected PointSymbolizerImpl() {
        this(new GraphicImpl(), null, null, null, new DescriptionImpl(new SimpleInternationalString("title"), new SimpleInternationalString("abstract")));
    }

    protected PointSymbolizerImpl(Graphic graphic, Unit<Length> uom, String geom, String name, Description desc) {
        super(name, desc, geom, uom);
        this.graphic = GraphicImpl.cast(graphic);
    }

    @Override
    public Graphic getGraphic() {
        return this.graphic;
    }

    @Override
    public void setGraphic(Graphic graphic) {
        if (this.graphic == graphic) {
            return;
        }
        this.graphic = GraphicImpl.cast(graphic);
    }

    @Override
    public Object accept(TraversingStyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        PointSymbolizerImpl clone;
        try {
            clone = (PointSymbolizerImpl)super.clone();
            if (this.graphic != null) {
                clone.graphic = (GraphicImpl)this.graphic.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.graphic == null ? 0 : this.graphic.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PointSymbolizerImpl other = (PointSymbolizerImpl)obj;
        return !(this.graphic == null ? other.graphic != null : !this.graphic.equals(other.graphic));
    }

    static PointSymbolizerImpl cast(Symbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        if (symbolizer instanceof PointSymbolizerImpl) {
            return (PointSymbolizerImpl)symbolizer;
        }
        if (symbolizer instanceof PointSymbolizer) {
            PointSymbolizer pointSymbolizer = (PointSymbolizer)symbolizer;
            PointSymbolizerImpl copy = new PointSymbolizerImpl();
            copy.setDescription(pointSymbolizer.getDescription());
            copy.setGeometryPropertyName(pointSymbolizer.getGeometryPropertyName());
            copy.setGraphic(pointSymbolizer.getGraphic());
            copy.setName(pointSymbolizer.getName());
            copy.setUnitOfMeasure(pointSymbolizer.getUnitOfMeasure());
            return copy;
        }
        return null;
    }
}

