/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.jdbc.AutoGeneratedPrimaryKeyColumn;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.NonIncrementingPrimaryKeyColumn;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.PrimaryKeyFinder;
import org.geotools.jdbc.SequencedPrimaryKeyColumn;
import org.geotools.util.logging.Logging;

public class MetadataTablePrimaryKeyFinder
extends PrimaryKeyFinder {
    protected static final Logger LOGGER = Logging.getLogger(MetadataTablePrimaryKeyFinder.class);
    public static final String DEFAULT_TABLE = "GT_PK_METADATA";
    volatile Boolean metadataTableExists = null;
    String tableSchema;
    String tableName = "GT_PK_METADATA";

    public String getTableSchema() {
        return this.tableSchema;
    }

    public void setTableSchema(String tableSchema) {
        this.tableSchema = tableSchema;
        this.metadataTableExists = null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
        this.metadataTableExists = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PrimaryKey getPrimaryKey(JDBCDataStore store, String schema, String table, Connection cx) throws SQLException {
        PrimaryKey primaryKey;
        PreparedStatement st;
        ResultSet rs;
        block35: {
            block34: {
                rs = null;
                ResultSet tablesRs = null;
                st = null;
                String metadataSchema = this.getMetadataSchema(store);
                try {
                    MetadataTablePrimaryKeyFinder metadataTablePrimaryKeyFinder;
                    if (this.metadataTableExists == null) {
                        metadataTablePrimaryKeyFinder = this;
                        synchronized (metadataTablePrimaryKeyFinder) {
                            if (this.metadataTableExists == null) {
                                try {
                                    tablesRs = cx.getMetaData().getTables(null, metadataSchema, "%", store.getSQLDialect().getDesiredTablesType());
                                    this.metadataTableExists = false;
                                    while (tablesRs.next()) {
                                        String tblName = tablesRs.getString(3);
                                        if (!tblName.toLowerCase().equals(this.tableName.toLowerCase())) continue;
                                        this.metadataTableExists = true;
                                        break;
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.log(Level.WARNING, "Error retrieving database metadata: ", e);
                                    if (e instanceof SQLException && !cx.getAutoCommit()) {
                                        cx.rollback();
                                    }
                                    this.metadataTableExists = false;
                                }
                                finally {
                                    store.closeSafe(rs);
                                    store.closeSafe(st);
                                    store.closeSafe(tablesRs);
                                }
                            }
                        }
                    }
                    LOGGER.log(Level.FINE, this.metadataTableExists != false ? "Metadata table " + this.tableName + " was found" : "Metadata table " + this.tableName + " was not found");
                    if (!this.metadataTableExists.booleanValue()) {
                        metadataTablePrimaryKeyFinder = null;
                        return metadataTablePrimaryKeyFinder;
                    }
                    ArrayList<String> parameters = new ArrayList<String>();
                    StringBuffer sb = new StringBuffer();
                    sb.append("SELECT * FROM ");
                    if (metadataSchema != null) {
                        store.getSQLDialect().encodeSchemaName(metadataSchema, sb);
                        sb.append(".");
                    }
                    sb.append(this.tableName);
                    sb.append(" WHERE ");
                    if (schema != null) {
                        sb.append("table_schema = ? AND ");
                        parameters.add(schema);
                    }
                    sb.append("table_name = ?");
                    parameters.add(table);
                    sb.append(" ORDER BY ");
                    sb.append("pk_column_idx");
                    sb.append(" ASC");
                    String sql = sb.toString();
                    LOGGER.log(Level.FINE, "Reading metadata table metadata: {0} [ parameters = {1} ]", new Object[]{sql, parameters});
                    DatabaseMetaData metaData = cx.getMetaData();
                    st = cx.prepareStatement(sql);
                    for (int i = 0; i < parameters.size(); ++i) {
                        st.setString(i + 1, (String)parameters.get(i));
                    }
                    rs = st.executeQuery();
                    ArrayList<PrimaryKeyColumn> columns = new ArrayList<PrimaryKeyColumn>();
                    Set<String> colNames = null;
                    while (rs.next()) {
                        String colName = rs.getString("pk_column");
                        String policyStr = rs.getString("pk_policy");
                        String sequence = rs.getString("pk_sequence");
                        if (colNames == null) {
                            colNames = this.getColumnNames(store, metaData, schema, table);
                        }
                        if (!colNames.contains(colName)) {
                            LOGGER.warning("Unknown column " + colName + " in table " + table);
                            PrimaryKey primaryKey2 = null;
                            store.closeSafe(rs);
                            store.closeSafe(st);
                            return primaryKey2;
                        }
                        Policy policy = Policy.assigned;
                        if (policyStr != null) {
                            try {
                                policy = Policy.valueOf(policyStr.toLowerCase());
                            }
                            catch (IllegalArgumentException e) {
                                LOGGER.warning("Invalid policy value " + policyStr + ", valid values are" + Arrays.asList(Policy.values()));
                                PrimaryKey primaryKey3 = null;
                                store.closeSafe(rs);
                                store.closeSafe(st);
                                return primaryKey3;
                            }
                        }
                        Class columnType = store.getColumnType(metaData, schema, table, colName);
                        if (policy == Policy.assigned) {
                            columns.add(new NonIncrementingPrimaryKeyColumn(colName, columnType));
                            continue;
                        }
                        if (policy == Policy.autogenerated) {
                            columns.add(new AutoGeneratedPrimaryKeyColumn(colName, columnType));
                            continue;
                        }
                        if (policy != Policy.sequence) continue;
                        columns.add(new SequencedPrimaryKeyColumn(colName, columnType, sequence));
                    }
                    if (!columns.isEmpty()) {
                        primaryKey = new PrimaryKey(table, columns);
                        store.closeSafe(rs);
                        break block34;
                    }
                    primaryKey = null;
                    store.closeSafe(rs);
                    break block35;
                }
                catch (SQLException e) {
                    LOGGER.log(Level.WARNING, "Errors occurred accessing the primary key metadata table ", e);
                    PrimaryKey primaryKey4 = null;
                    return primaryKey4;
                }
            }
            store.closeSafe(st);
            return primaryKey;
        }
        store.closeSafe(st);
        return primaryKey;
        finally {
            store.closeSafe(rs);
            store.closeSafe(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getColumnNames(JDBCDataStore store, DatabaseMetaData metaData, String schema, String table) throws SQLException {
        ResultSet rs = null;
        HashSet<String> result = new HashSet<String>();
        try {
            rs = metaData.getColumns(null, store.escapeNamePattern(metaData, schema), store.escapeNamePattern(metaData, table), null);
            while (rs.next()) {
                result.add(rs.getString("COLUMN_NAME"));
            }
            store.closeSafe(rs);
        }
        catch (Throwable throwable) {
            store.closeSafe(rs);
            throw throwable;
        }
        return result;
    }

    String getMetadataSchema(JDBCDataStore store) {
        if (this.tableSchema != null) {
            return this.tableSchema;
        }
        return store.getDatabaseSchema();
    }

    static enum Policy {
        assigned,
        sequence,
        autogenerated;

    }
}

