/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.AverageVisitor;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.CollectionFeatureMemberFilterVisitor;
import org.geotools.util.logging.Logging;

public class Collection_AverageFunction
extends FunctionExpressionImpl {
    private static final Logger LOGGER = Logging.getLogger(Collection_AverageFunction.class);
    FeatureCollection<FeatureType, Feature> previousFeatureCollection = null;
    Object average = null;
    Expression expr;
    public static FunctionName NAME = new FunctionNameImpl("Collection_Average", FunctionNameImpl.parameter("average", Number.class), FunctionNameImpl.parameter("expression", Number.class));

    public Collection_AverageFunction() {
        super(NAME);
    }

    static CalcResult calculateAverage(FeatureCollection<? extends FeatureType, ? extends Feature> collection, Expression expression) throws IllegalFilterException, IOException {
        AverageVisitor averageVisitor = new AverageVisitor(expression);
        collection.accepts(averageVisitor, null);
        return averageVisitor.getResult();
    }

    @Override
    public void setParameters(List<Expression> params) {
        super.setParameters(params);
        if (params.size() != 1) {
            throw new IllegalArgumentException("Require a single argument for average");
        }
        this.expr = this.getExpression(0);
        this.expr = (Expression)this.expr.accept(new CollectionFeatureMemberFilterVisitor(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Object feature) {
        FeatureCollection featureCollection;
        if (feature == null) {
            return 0;
        }
        FeatureCollection featureCollection2 = featureCollection = (FeatureCollection)feature;
        synchronized (featureCollection2) {
            if (featureCollection != this.previousFeatureCollection) {
                this.previousFeatureCollection = featureCollection;
                this.average = null;
                try {
                    CalcResult result = Collection_AverageFunction.calculateAverage(featureCollection, this.expr);
                    if (result != null) {
                        this.average = result.getValue();
                    }
                }
                catch (IOException | IllegalFilterException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
            }
        }
        return this.average;
    }

    public void setExpression(Expression e) {
        this.setParameters(Collections.singletonList(e));
    }

    @Override
    public String toString() {
        return "Collection_Average(" + this.expr + ")";
    }
}

