/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.api.data.Parameter;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.feature.type.Name;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.ProgressListener;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.io.CoverageCapabilities;
import org.geotools.coverage.io.CoverageSource;
import org.geotools.coverage.io.CoverageSourceDescriptor;
import org.geotools.coverage.io.RasterLayout;
import org.geotools.coverage.io.metadata.MetadataNode;
import org.geotools.coverage.io.range.RangeType;

public abstract class DefaultCoverageSource
implements CoverageSource {
    protected static final EnumSet<CoverageCapabilities> CAPABILITIES = EnumSet.of(CoverageCapabilities.READ_HORIZONTAL_DOMAIN_SUBSAMBLING, CoverageCapabilities.READ_RANGE_SUBSETTING, CoverageCapabilities.READ_REPROJECTION, CoverageCapabilities.READ_SUBSAMPLING);
    protected final Name name;
    protected final CoverageSourceDescriptor coverageDescriptor;
    private boolean disposed;

    protected DefaultCoverageSource(Name name, CoverageSourceDescriptor descriptor) {
        this.name = name;
        this.coverageDescriptor = descriptor;
    }

    @Override
    public Map<String, Parameter<?>> getReadParameterInfo() {
        return null;
    }

    @Override
    public MetadataNode getMetadata(String metadataDomain, ProgressListener listener) {
        return null;
    }

    @Override
    public Set<Name> getMetadataDomains() {
        return null;
    }

    @Override
    public List<? extends RasterLayout> getOverviewsLayouts(ProgressListener listener) throws IOException {
        return Collections.emptyList();
    }

    @Override
    public int getOverviewsNumber(ProgressListener listener) throws IOException {
        return 0;
    }

    @Override
    public Name getName(ProgressListener listener) {
        this.ensureNotDisposed();
        return this.name;
    }

    protected void ensureNotDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("Disposed");
        }
    }

    @Override
    public EnumSet<CoverageCapabilities> getCapabilities() {
        return EnumSet.copyOf(CAPABILITIES);
    }

    @Override
    public RangeType getRangeType(ProgressListener listener) throws IOException {
        this.ensureNotDisposed();
        return this.coverageDescriptor.getRangeType();
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.coverageDescriptor.getSpatialDomain().getCoordinateReferenceSystem2D();
    }

    @Override
    public CoverageSource.SpatialDomain getSpatialDomain() throws IOException {
        return this.coverageDescriptor.getSpatialDomain();
    }

    @Override
    public CoverageSource.TemporalDomain getTemporalDomain() throws IOException {
        return this.coverageDescriptor.getTemporalDomain();
    }

    @Override
    public CoverageSource.VerticalDomain getVerticalDomain() throws IOException {
        return this.coverageDescriptor.getVerticalDomain();
    }

    @Override
    public List<CoverageSource.AdditionalDomain> getAdditionalDomains() throws IOException {
        return this.coverageDescriptor.getAdditionalDomains();
    }

    @Override
    public List<DimensionDescriptor> getDimensionDescriptors() throws IOException {
        return this.coverageDescriptor.getDimensionDescriptors();
    }

    @Override
    public ResourceInfo getInfo(ProgressListener listener) {
        this.ensureNotDisposed();
        return null;
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.coverageDescriptor.dispose();
    }
}

