/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.affine;

import it.geosolutions.jaiext.affine.AffineOpImage;
import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;

public class AffineNearestOpImage
extends AffineOpImage {
    protected InterpolationNearest interpN = null;
    protected byte[][] byteLookupTable;
    static final BorderExtender roiExtender = BorderExtender.createInstance(0);
    private boolean setDestinationNoData;

    public AffineNearestOpImage(RenderedImage source, BorderExtender extender, Map config, ImageLayout layout, AffineTransform transform, Interpolation interp, double[] backgroundValues, boolean setDestinationNoData, boolean useROIAccessor, Range nodata) {
        super(source, extender, config, layout, transform, interp, backgroundValues);
        this.affineOpInitialization(source, interp, layout, useROIAccessor, setDestinationNoData, backgroundValues, nodata);
    }

    private void affineOpInitialization(RenderedImage source, Interpolation interp, ImageLayout layout, boolean useROIAccessor, boolean setDestinationNoData, double[] backgroundValues, Range nodata) {
        int i;
        SampleModel sm = source.getSampleModel();
        ColorModel srcColorModel = source.getColorModel();
        if (srcColorModel instanceof IndexColorModel) {
            this.sampleModel = source.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = srcColorModel;
        }
        int numBands = this.getSampleModel().getNumBands();
        int srcDataType = sm.getDataType();
        Range nod = nodata;
        double[] destNod = null;
        if (backgroundValues != null && backgroundValues.length > 0) {
            destNod = backgroundValues;
        }
        if (interp instanceof InterpolationNearest) {
            this.interpN = (InterpolationNearest)interp;
            this.interp = this.interpN;
            this.interpN.setROIBounds(this.roiBounds);
            if (nod == null) {
                nod = this.interpN.getNoDataRange();
            }
            if (destNod == null) {
                destNod = new double[]{this.interpN.getDestinationNoData()};
            }
        }
        if (nod != null) {
            this.hasNoData = true;
            this.noData = nod;
        }
        if (destNod != null) {
            this.destinationNoDataDouble = destNod;
        } else if (this.backgroundValues != null && this.backgroundValues.length > 0) {
            this.destinationNoDataDouble = this.backgroundValues;
        }
        if (this.destinationNoDataDouble != null && this.destinationNoDataDouble.length < numBands) {
            double[] tmp = new double[numBands];
            Arrays.fill(tmp, this.destinationNoDataDouble[0]);
            this.destinationNoDataDouble = tmp;
        }
        if (this.hasROI) {
            this.useROIAccessor = useROIAccessor;
        }
        this.setDestinationNoData = setDestinationNoData;
        this.setBackground = setDestinationNoData;
        this.destinationNoDataByte = new byte[numBands];
        this.destinationNoDataShort = new short[numBands];
        this.destinationNoDataUShort = new short[numBands];
        this.destinationNoDataInt = new int[numBands];
        this.destinationNoDataFloat = new float[numBands];
        for (i = 0; i < numBands; ++i) {
            this.destinationNoDataByte[i] = (byte)((int)this.destinationNoDataDouble[i] & 0xFF);
            this.destinationNoDataUShort[i] = (short)((short)this.destinationNoDataDouble[i] & 0xFFFF);
            this.destinationNoDataShort[i] = (short)this.destinationNoDataDouble[i];
            this.destinationNoDataInt[i] = (int)this.destinationNoDataDouble[i];
            this.destinationNoDataFloat[i] = (float)this.destinationNoDataDouble[i];
        }
        if (srcDataType == 0 && this.hasNoData) {
            this.byteLookupTable = new byte[numBands][256];
            for (i = 0; i < this.byteLookupTable[0].length; ++i) {
                byte value = (byte)i;
                for (int b = 0; b < numBands; ++b) {
                    if (this.noData.contains(value)) {
                        if (setDestinationNoData) {
                            this.byteLookupTable[b][i] = this.destinationNoDataByte[b];
                            continue;
                        }
                        this.byteLookupTable[b][i] = 0;
                        continue;
                    }
                    this.byteLookupTable[b][i] = value;
                }
            }
        }
        this.caseA = !this.hasROI && !this.hasNoData;
        this.caseB = this.hasROI && !this.hasNoData;
        this.caseC = !this.hasROI && this.hasNoData;
    }

    @Override
    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = source.getBounds();
        int srcRectX = srcRect.x;
        int srcRectY = srcRect.y;
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor(dest, destRect, formatTags[1], this.getColorModel());
        RasterAccessor roiAccessor = null;
        Raster roi = null;
        RandomIter roiIter = null;
        if (this.hasROI) {
            if (this.useROIAccessor) {
                roi = this.srcROIImage.getBounds().contains(srcRect) ? this.srcROIImage.getData(srcRect) : this.srcROIImgExt.getData(srcRect);
                roiAccessor = new RasterAccessor(roi, srcRect, RasterAccessor.findCompatibleTags(new RenderedImage[]{this.srcROIImage}, this.srcROIImage)[0], this.srcROIImage.getColorModel());
            } else {
                roiIter = RandomIterFactory.create(this.srcROIImgExt, this.roiRect, true, true);
            }
        }
        int dataType = dest.getSampleModel().getDataType();
        switch (dataType) {
            case 0: {
                this.byteLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor, roiIter);
                break;
            }
            case 3: {
                this.intLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor, roiIter);
                break;
            }
            case 2: {
                this.shortLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor, roiIter);
                break;
            }
            case 1: {
                this.ushortLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor, roiIter);
                break;
            }
            case 4: {
                this.floatLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor, roiIter);
                break;
            }
            case 5: {
                this.doubleLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor, roiIter);
            }
        }
        if (dstAccessor.isDataCopy()) {
            dstAccessor.clampDataArrays();
            dstAccessor.copyDataToRaster();
        }
    }

    private void byteLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiScanlineStride;
        int roiDataLength;
        byte[] roiDataArray;
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        byte[][] srcDataArrays = src.getByteDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int incxStride = this.incx * srcPixelStride;
        int incx1Stride = this.incx1 * srcPixelStride;
        int incyStride = this.incy * srcScanlineStride;
        int incy1Stride = this.incy1 * srcScanlineStride;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiScanlineStride = roi.getScanlineStride();
        } else {
            roiDataArray = null;
            roiDataLength = 0;
            roiScanlineStride = 0;
        }
        if (this.caseA) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    for (k2 = 0; k2 < dst_num_bands; ++k2) {
                        dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = srcDataArrays[k2][src_pos + bandOffsets[k2]];
                    }
                    if (ifracx < this.ifracdx1) {
                        src_pos += incxStride;
                        ifracx += this.ifracdx;
                    } else {
                        src_pos += incx1Stride;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        src_pos += incyStride;
                        ifracy += this.ifracdy;
                    } else {
                        src_pos += incy1Stride;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint((Point2D)dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    double fracx = (double)s_x - (double)s_ix * 1.0;
                    double fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    ifracx = startPts[1].x;
                    ifracy = startPts[1].y;
                    int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k22;
                        int w;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                        src_pos = posx + posy;
                        int windex = posx / dst_num_bands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w == 0) {
                            if (this.setDestinationNoData) {
                                for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataByte[k22];
                                }
                            }
                        } else {
                            for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = srcDataArrays[k22][src_pos + bandOffsets[k22]];
                            }
                        }
                        if (ifracx < this.ifracdx1) {
                            s_ix += this.incx;
                            ifracx += this.ifracdx;
                        } else {
                            s_ix += this.incx1;
                            ifracx -= this.ifracdx1;
                        }
                        if (ifracy < this.ifracdy1) {
                            s_iy += this.incy;
                            ifracy += this.ifracdy;
                        } else {
                            s_iy += this.incy1;
                            ifracy -= this.ifracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            } else {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint((Point2D)dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    double fracx = (double)s_x - (double)s_ix * 1.0;
                    double fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    ifracx = startPts[1].x;
                    ifracy = startPts[1].y;
                    int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int y0;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        src_pos = posx + posy;
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                            int k23;
                            int w = roiIter.getSample(x0, y0, 0) & 0xFF;
                            if (w == 0) {
                                if (this.setDestinationNoData) {
                                    for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                        dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataByte[k23];
                                    }
                                }
                            } else {
                                for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = srcDataArrays[k23][src_pos + bandOffsets[k23]];
                                }
                            }
                        } else if (this.setDestinationNoData) {
                            for (int k24 = 0; k24 < dst_num_bands; ++k24) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataByte[k24];
                            }
                        }
                        if (ifracx < this.ifracdx1) {
                            s_ix += this.incx;
                            ifracx += this.ifracdx;
                        } else {
                            s_ix += this.incx1;
                            ifracx -= this.ifracdx1;
                        }
                        if (ifracy < this.ifracdy1) {
                            s_iy += this.incy;
                            ifracy += this.ifracdy;
                        } else {
                            s_iy += this.incy1;
                            ifracy -= this.ifracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int posy = (s_iy - srcRectY) * srcScanlineStride;
                int src_pos = posy + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    for (k2 = 0; k2 < dst_num_bands; ++k2) {
                        byte value = srcDataArrays[k2][src_pos + bandOffsets[k2]];
                        dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.byteLookupTable[k2][value & 0xFF];
                    }
                    if (ifracx < this.ifracdx1) {
                        src_pos += incxStride;
                        ifracx += this.ifracdx;
                    } else {
                        src_pos += incx1Stride;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        src_pos += incyStride;
                        ifracy += this.ifracdy;
                    } else {
                        src_pos += incy1Stride;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.useROIAccessor) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k25;
                    int w;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                    src_pos = posx + posy;
                    int windex = posx / dst_num_bands + posyROI;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w == 0) {
                        if (this.setDestinationNoData) {
                            for (k25 = 0; k25 < dst_num_bands; ++k25) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataByte[k25];
                            }
                        }
                    } else {
                        for (k25 = 0; k25 < dst_num_bands; ++k25) {
                            byte value = srcDataArrays[k25][src_pos + bandOffsets[k25]];
                            dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.byteLookupTable[k25][value & 0xFF];
                        }
                    }
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int y0;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    src_pos = posx + posy;
                    int x0 = src.getX() + posx / srcPixelStride;
                    if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                        int k26;
                        int w = roiIter.getSample(x0, y0, 0) & 0xFF;
                        if (w == 0) {
                            if (this.setDestinationNoData) {
                                for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataByte[k26];
                                }
                            }
                        } else {
                            for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                byte value = srcDataArrays[k26][src_pos + bandOffsets[k26]];
                                dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.byteLookupTable[k26][value & 0xFF];
                            }
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k27 = 0; k27 < dst_num_bands; ++k27) {
                            dstDataArrays[k27][dstPixelOffset + dstBandOffsets[k27]] = this.destinationNoDataByte[k27];
                        }
                    }
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        }
    }

    private void intLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiScanlineStride;
        int roiDataLength;
        byte[] roiDataArray;
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        int[][] dstDataArrays = dst.getIntDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[][] srcDataArrays = src.getIntDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int incxStride = this.incx * srcPixelStride;
        int incx1Stride = this.incx1 * srcPixelStride;
        int incyStride = this.incy * srcScanlineStride;
        int incy1Stride = this.incy1 * srcScanlineStride;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiScanlineStride = roi.getScanlineStride();
        } else {
            roiDataArray = null;
            roiDataLength = 0;
            roiScanlineStride = 0;
        }
        if (this.caseA) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    for (k2 = 0; k2 < dst_num_bands; ++k2) {
                        dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = srcDataArrays[k2][src_pos + bandOffsets[k2]];
                    }
                    if (ifracx < this.ifracdx1) {
                        src_pos += incxStride;
                        ifracx += this.ifracdx;
                    } else {
                        src_pos += incx1Stride;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        src_pos += incyStride;
                        ifracy += this.ifracdy;
                    } else {
                        src_pos += incy1Stride;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint((Point2D)dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    double fracx = (double)s_x - (double)s_ix * 1.0;
                    double fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    ifracx = startPts[1].x;
                    ifracy = startPts[1].y;
                    int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k22;
                        int w;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                        src_pos = posx + posy;
                        int windex = posx / dst_num_bands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w == 0) {
                            if (this.setDestinationNoData) {
                                for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataInt[k22];
                                }
                            }
                        } else {
                            for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = srcDataArrays[k22][src_pos + bandOffsets[k22]];
                            }
                        }
                        if (ifracx < this.ifracdx1) {
                            s_ix += this.incx;
                            ifracx += this.ifracdx;
                        } else {
                            s_ix += this.incx1;
                            ifracx -= this.ifracdx1;
                        }
                        if (ifracy < this.ifracdy1) {
                            s_iy += this.incy;
                            ifracy += this.ifracdy;
                        } else {
                            s_iy += this.incy1;
                            ifracy -= this.ifracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            } else {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint((Point2D)dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    double fracx = (double)s_x - (double)s_ix * 1.0;
                    double fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    ifracx = startPts[1].x;
                    ifracy = startPts[1].y;
                    int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int y0;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        src_pos = posx + posy;
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                            int k23;
                            int w = roiIter.getSample(x0, y0, 0) & 0xFF;
                            if (w == 0) {
                                if (this.setDestinationNoData) {
                                    for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                        dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataInt[k23];
                                    }
                                }
                            } else {
                                for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = srcDataArrays[k23][src_pos + bandOffsets[k23]];
                                }
                            }
                        } else if (this.setDestinationNoData) {
                            for (int k24 = 0; k24 < dst_num_bands; ++k24) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataInt[k24];
                            }
                        }
                        if (ifracx < this.ifracdx1) {
                            s_ix += this.incx;
                            ifracx += this.ifracdx;
                        } else {
                            s_ix += this.incx1;
                            ifracx -= this.ifracdx1;
                        }
                        if (ifracy < this.ifracdy1) {
                            s_iy += this.incy;
                            ifracy += this.ifracdy;
                        } else {
                            s_iy += this.incy1;
                            ifracy -= this.ifracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int posy = (s_iy - srcRectY) * srcScanlineStride;
                int src_pos = posy + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    for (k2 = 0; k2 < dst_num_bands; ++k2) {
                        int value = srcDataArrays[k2][src_pos + bandOffsets[k2]];
                        if (this.noData.contains(value)) {
                            if (!this.setDestinationNoData) continue;
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                            continue;
                        }
                        dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = value;
                    }
                    if (ifracx < this.ifracdx1) {
                        src_pos += incxStride;
                        ifracx += this.ifracdx;
                    } else {
                        src_pos += incx1Stride;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        src_pos += incyStride;
                        ifracy += this.ifracdy;
                    } else {
                        src_pos += incy1Stride;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.useROIAccessor) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k25;
                    int w;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                    src_pos = posx + posy;
                    int windex = posx / dst_num_bands + posyROI;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w == 0) {
                        if (this.setDestinationNoData) {
                            for (k25 = 0; k25 < dst_num_bands; ++k25) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataInt[k25];
                            }
                        }
                    } else {
                        for (k25 = 0; k25 < dst_num_bands; ++k25) {
                            int value = srcDataArrays[k25][src_pos + bandOffsets[k25]];
                            if (this.noData.contains(value)) {
                                if (!this.setDestinationNoData) continue;
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataInt[k25];
                                continue;
                            }
                            dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = value;
                        }
                    }
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int y0;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    src_pos = posx + posy;
                    int x0 = src.getX() + posx / srcPixelStride;
                    if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                        int k26;
                        int w = roiIter.getSample(x0, y0, 0) & 0xFF;
                        if (w == 0) {
                            if (this.setDestinationNoData) {
                                for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataInt[k26];
                                }
                            }
                        } else {
                            for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                int value = srcDataArrays[k26][src_pos + bandOffsets[k26]];
                                if (this.noData.contains(value)) {
                                    if (!this.setDestinationNoData) continue;
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataInt[k26];
                                    continue;
                                }
                                dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = value;
                            }
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k27 = 0; k27 < dst_num_bands; ++k27) {
                            dstDataArrays[k27][dstPixelOffset + dstBandOffsets[k27]] = this.destinationNoDataInt[k27];
                        }
                    }
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        }
    }

    private void shortLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiScanlineStride;
        int roiDataLength;
        byte[] roiDataArray;
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int incxStride = this.incx * srcPixelStride;
        int incx1Stride = this.incx1 * srcPixelStride;
        int incyStride = this.incy * srcScanlineStride;
        int incy1Stride = this.incy1 * srcScanlineStride;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiScanlineStride = roi.getScanlineStride();
        } else {
            roiDataArray = null;
            roiDataLength = 0;
            roiScanlineStride = 0;
        }
        if (this.caseA) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    for (k2 = 0; k2 < dst_num_bands; ++k2) {
                        dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = srcDataArrays[k2][src_pos + bandOffsets[k2]];
                    }
                    if (ifracx < this.ifracdx1) {
                        src_pos += incxStride;
                        ifracx += this.ifracdx;
                    } else {
                        src_pos += incx1Stride;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        src_pos += incyStride;
                        ifracy += this.ifracdy;
                    } else {
                        src_pos += incy1Stride;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint((Point2D)dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    double fracx = (double)s_x - (double)s_ix * 1.0;
                    double fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    ifracx = startPts[1].x;
                    ifracy = startPts[1].y;
                    int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k22;
                        int w;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                        src_pos = posx + posy;
                        int windex = posx / dst_num_bands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w == 0) {
                            if (this.setDestinationNoData) {
                                for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataShort[k22];
                                }
                            }
                        } else {
                            for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = srcDataArrays[k22][src_pos + bandOffsets[k22]];
                            }
                        }
                        if (ifracx < this.ifracdx1) {
                            s_ix += this.incx;
                            ifracx += this.ifracdx;
                        } else {
                            s_ix += this.incx1;
                            ifracx -= this.ifracdx1;
                        }
                        if (ifracy < this.ifracdy1) {
                            s_iy += this.incy;
                            ifracy += this.ifracdy;
                        } else {
                            s_iy += this.incy1;
                            ifracy -= this.ifracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            } else {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint((Point2D)dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    double fracx = (double)s_x - (double)s_ix * 1.0;
                    double fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    ifracx = startPts[1].x;
                    ifracy = startPts[1].y;
                    int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int y0;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        src_pos = posx + posy;
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                            int k23;
                            int w = roiIter.getSample(x0, y0, 0) & 0xFF;
                            if (w == 0) {
                                if (this.setDestinationNoData) {
                                    for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                        dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataShort[k23];
                                    }
                                }
                            } else {
                                for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = srcDataArrays[k23][src_pos + bandOffsets[k23]];
                                }
                            }
                        } else if (this.setDestinationNoData) {
                            for (int k24 = 0; k24 < dst_num_bands; ++k24) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataShort[k24];
                            }
                        }
                        if (ifracx < this.ifracdx1) {
                            s_ix += this.incx;
                            ifracx += this.ifracdx;
                        } else {
                            s_ix += this.incx1;
                            ifracx -= this.ifracdx1;
                        }
                        if (ifracy < this.ifracdy1) {
                            s_iy += this.incy;
                            ifracy += this.ifracdy;
                        } else {
                            s_iy += this.incy1;
                            ifracy -= this.ifracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int posy = (s_iy - srcRectY) * srcScanlineStride;
                int src_pos = posy + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    for (k2 = 0; k2 < dst_num_bands; ++k2) {
                        short value = srcDataArrays[k2][src_pos + bandOffsets[k2]];
                        if (this.noData.contains(value)) {
                            if (!this.setDestinationNoData) continue;
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                            continue;
                        }
                        dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = value;
                    }
                    if (ifracx < this.ifracdx1) {
                        src_pos += incxStride;
                        ifracx += this.ifracdx;
                    } else {
                        src_pos += incx1Stride;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        src_pos += incyStride;
                        ifracy += this.ifracdy;
                    } else {
                        src_pos += incy1Stride;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.useROIAccessor) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k25;
                    int w;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                    src_pos = posx + posy;
                    int windex = posx / dst_num_bands + posyROI;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w == 0) {
                        if (this.setDestinationNoData) {
                            for (k25 = 0; k25 < dst_num_bands; ++k25) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataShort[k25];
                            }
                        }
                    } else {
                        for (k25 = 0; k25 < dst_num_bands; ++k25) {
                            short value = srcDataArrays[k25][src_pos + bandOffsets[k25]];
                            if (this.noData.contains(value)) {
                                if (!this.setDestinationNoData) continue;
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataShort[k25];
                                continue;
                            }
                            dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = value;
                        }
                    }
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int y0;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    src_pos = posx + posy;
                    int x0 = src.getX() + posx / srcPixelStride;
                    if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                        int k26;
                        int w = roiIter.getSample(x0, y0, 0) & 0xFF;
                        if (w == 0) {
                            if (this.setDestinationNoData) {
                                for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataShort[k26];
                                }
                            }
                        } else {
                            for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                short value = srcDataArrays[k26][src_pos + bandOffsets[k26]];
                                if (this.noData.contains(value)) {
                                    if (!this.setDestinationNoData) continue;
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataShort[k26];
                                    continue;
                                }
                                dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = value;
                            }
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k27 = 0; k27 < dst_num_bands; ++k27) {
                            dstDataArrays[k27][dstPixelOffset + dstBandOffsets[k27]] = this.destinationNoDataShort[k27];
                        }
                    }
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        }
    }

    private void ushortLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiScanlineStride;
        int roiDataLength;
        byte[] roiDataArray;
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int incxStride = this.incx * srcPixelStride;
        int incx1Stride = this.incx1 * srcPixelStride;
        int incyStride = this.incy * srcScanlineStride;
        int incy1Stride = this.incy1 * srcScanlineStride;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiScanlineStride = roi.getScanlineStride();
        } else {
            roiDataArray = null;
            roiDataLength = 0;
            roiScanlineStride = 0;
        }
        if (this.caseA) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    for (k2 = 0; k2 < dst_num_bands; ++k2) {
                        dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = srcDataArrays[k2][src_pos + bandOffsets[k2]];
                    }
                    if (ifracx < this.ifracdx1) {
                        src_pos += incxStride;
                        ifracx += this.ifracdx;
                    } else {
                        src_pos += incx1Stride;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        src_pos += incyStride;
                        ifracy += this.ifracdy;
                    } else {
                        src_pos += incy1Stride;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint((Point2D)dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    double fracx = (double)s_x - (double)s_ix * 1.0;
                    double fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    ifracx = startPts[1].x;
                    ifracy = startPts[1].y;
                    int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k22;
                        int w;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                        src_pos = posx + posy;
                        int windex = posx / dst_num_bands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w == 0) {
                            if (this.setDestinationNoData) {
                                for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataUShort[k22];
                                }
                            }
                        } else {
                            for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = srcDataArrays[k22][src_pos + bandOffsets[k22]];
                            }
                        }
                        if (ifracx < this.ifracdx1) {
                            s_ix += this.incx;
                            ifracx += this.ifracdx;
                        } else {
                            s_ix += this.incx1;
                            ifracx -= this.ifracdx1;
                        }
                        if (ifracy < this.ifracdy1) {
                            s_iy += this.incy;
                            ifracy += this.ifracdy;
                        } else {
                            s_iy += this.incy1;
                            ifracy -= this.ifracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            } else {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint((Point2D)dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    double fracx = (double)s_x - (double)s_ix * 1.0;
                    double fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    ifracx = startPts[1].x;
                    ifracy = startPts[1].y;
                    int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int y0;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        src_pos = posx + posy;
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                            int k23;
                            int w = roiIter.getSample(x0, y0, 0) & 0xFF;
                            if (w == 0) {
                                if (this.setDestinationNoData) {
                                    for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                        dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataUShort[k23];
                                    }
                                }
                            } else {
                                for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = srcDataArrays[k23][src_pos + bandOffsets[k23]];
                                }
                            }
                        } else if (this.setDestinationNoData) {
                            for (int k24 = 0; k24 < dst_num_bands; ++k24) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataUShort[k24];
                            }
                        }
                        if (ifracx < this.ifracdx1) {
                            s_ix += this.incx;
                            ifracx += this.ifracdx;
                        } else {
                            s_ix += this.incx1;
                            ifracx -= this.ifracdx1;
                        }
                        if (ifracy < this.ifracdy1) {
                            s_iy += this.incy;
                            ifracy += this.ifracdy;
                        } else {
                            s_iy += this.incy1;
                            ifracy -= this.ifracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int posy = (s_iy - srcRectY) * srcScanlineStride;
                int src_pos = posy + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    for (k2 = 0; k2 < dst_num_bands; ++k2) {
                        short value = (short)(srcDataArrays[k2][src_pos + bandOffsets[k2]] & 0xFFFF);
                        if (this.noData.contains(value)) {
                            if (!this.setDestinationNoData) continue;
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                            continue;
                        }
                        dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = value;
                    }
                    if (ifracx < this.ifracdx1) {
                        src_pos += incxStride;
                        ifracx += this.ifracdx;
                    } else {
                        src_pos += incx1Stride;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        src_pos += incyStride;
                        ifracy += this.ifracdy;
                    } else {
                        src_pos += incy1Stride;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.useROIAccessor) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k25;
                    int w;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                    src_pos = posx + posy;
                    int windex = posx / dst_num_bands + posyROI;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w == 0) {
                        if (this.setDestinationNoData) {
                            for (k25 = 0; k25 < dst_num_bands; ++k25) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataUShort[k25];
                            }
                        }
                    } else {
                        for (k25 = 0; k25 < dst_num_bands; ++k25) {
                            short value = (short)(srcDataArrays[k25][src_pos + bandOffsets[k25]] & 0xFFFF);
                            if (this.noData.contains(value)) {
                                if (!this.setDestinationNoData) continue;
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataUShort[k25];
                                continue;
                            }
                            dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = value;
                        }
                    }
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int y0;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    src_pos = posx + posy;
                    int x0 = src.getX() + posx / srcPixelStride;
                    if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                        int k26;
                        int w = roiIter.getSample(x0, y0, 0) & 0xFF;
                        if (w == 0) {
                            if (this.setDestinationNoData) {
                                for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataUShort[k26];
                                }
                            }
                        } else {
                            for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                short value = (short)(srcDataArrays[k26][src_pos + bandOffsets[k26]] & 0xFFFF);
                                if (this.noData.contains(value)) {
                                    if (!this.setDestinationNoData) continue;
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataUShort[k26];
                                    continue;
                                }
                                dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = value;
                            }
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k27 = 0; k27 < dst_num_bands; ++k27) {
                            dstDataArrays[k27][dstPixelOffset + dstBandOffsets[k27]] = this.destinationNoDataUShort[k27];
                        }
                    }
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        }
    }

    private void floatLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiScanlineStride;
        int roiDataLength;
        byte[] roiDataArray;
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        float[][] dstDataArrays = dst.getFloatDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        float[][] srcDataArrays = src.getFloatDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int incxStride = this.incx * srcPixelStride;
        int incx1Stride = this.incx1 * srcPixelStride;
        int incyStride = this.incy * srcScanlineStride;
        int incy1Stride = this.incy1 * srcScanlineStride;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiScanlineStride = roi.getScanlineStride();
        } else {
            roiDataArray = null;
            roiDataLength = 0;
            roiScanlineStride = 0;
        }
        if (this.caseA) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    for (k2 = 0; k2 < dst_num_bands; ++k2) {
                        dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = srcDataArrays[k2][src_pos + bandOffsets[k2]];
                    }
                    if (ifracx < this.ifracdx1) {
                        src_pos += incxStride;
                        ifracx += this.ifracdx;
                    } else {
                        src_pos += incx1Stride;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        src_pos += incyStride;
                        ifracy += this.ifracdy;
                    } else {
                        src_pos += incy1Stride;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint((Point2D)dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    double fracx = (double)s_x - (double)s_ix * 1.0;
                    double fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    ifracx = startPts[1].x;
                    ifracy = startPts[1].y;
                    int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k22;
                        int w;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                        src_pos = posx + posy;
                        int windex = posx / dst_num_bands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w == 0) {
                            if (this.setDestinationNoData) {
                                for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataFloat[k22];
                                }
                            }
                        } else {
                            for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = srcDataArrays[k22][src_pos + bandOffsets[k22]];
                            }
                        }
                        if (ifracx < this.ifracdx1) {
                            s_ix += this.incx;
                            ifracx += this.ifracdx;
                        } else {
                            s_ix += this.incx1;
                            ifracx -= this.ifracdx1;
                        }
                        if (ifracy < this.ifracdy1) {
                            s_iy += this.incy;
                            ifracy += this.ifracdy;
                        } else {
                            s_iy += this.incy1;
                            ifracy -= this.ifracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            } else {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint((Point2D)dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    double fracx = (double)s_x - (double)s_ix * 1.0;
                    double fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    ifracx = startPts[1].x;
                    ifracy = startPts[1].y;
                    int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int y0;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        src_pos = posx + posy;
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                            int k23;
                            int w = roiIter.getSample(x0, y0, 0) & 0xFF;
                            if (w == 0) {
                                if (this.setDestinationNoData) {
                                    for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                        dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataFloat[k23];
                                    }
                                }
                            } else {
                                for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = srcDataArrays[k23][src_pos + bandOffsets[k23]];
                                }
                            }
                        } else if (this.setDestinationNoData) {
                            for (int k24 = 0; k24 < dst_num_bands; ++k24) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataFloat[k24];
                            }
                        }
                        if (ifracx < this.ifracdx1) {
                            s_ix += this.incx;
                            ifracx += this.ifracdx;
                        } else {
                            s_ix += this.incx1;
                            ifracx -= this.ifracdx1;
                        }
                        if (ifracy < this.ifracdy1) {
                            s_iy += this.incy;
                            ifracy += this.ifracdy;
                        } else {
                            s_iy += this.incy1;
                            ifracy -= this.ifracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int posy = (s_iy - srcRectY) * srcScanlineStride;
                int src_pos = posy + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    for (k2 = 0; k2 < dst_num_bands; ++k2) {
                        float value = srcDataArrays[k2][src_pos + bandOffsets[k2]];
                        if (this.noData.contains(value)) {
                            if (!this.setDestinationNoData) continue;
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                            continue;
                        }
                        dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = value;
                    }
                    if (ifracx < this.ifracdx1) {
                        src_pos += incxStride;
                        ifracx += this.ifracdx;
                    } else {
                        src_pos += incx1Stride;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        src_pos += incyStride;
                        ifracy += this.ifracdy;
                    } else {
                        src_pos += incy1Stride;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.useROIAccessor) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k25;
                    int w;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                    src_pos = posx + posy;
                    int windex = posx / dst_num_bands + posyROI;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w == 0) {
                        if (this.setDestinationNoData) {
                            for (k25 = 0; k25 < dst_num_bands; ++k25) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataFloat[k25];
                            }
                        }
                    } else {
                        for (k25 = 0; k25 < dst_num_bands; ++k25) {
                            float value = srcDataArrays[k25][src_pos + bandOffsets[k25]];
                            if (this.noData.contains(value)) {
                                if (!this.setDestinationNoData) continue;
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataFloat[k25];
                                continue;
                            }
                            dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = value;
                        }
                    }
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int y0;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    src_pos = posx + posy;
                    int x0 = src.getX() + posx / srcPixelStride;
                    if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                        int k26;
                        int w = roiIter.getSample(x0, y0, 0) & 0xFF;
                        if (w == 0) {
                            if (this.setDestinationNoData) {
                                for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataFloat[k26];
                                }
                            }
                        } else {
                            for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                float value = srcDataArrays[k26][src_pos + bandOffsets[k26]];
                                if (this.noData.contains(value)) {
                                    if (!this.setDestinationNoData) continue;
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataFloat[k26];
                                    continue;
                                }
                                dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = value;
                            }
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k27 = 0; k27 < dst_num_bands; ++k27) {
                            dstDataArrays[k27][dstPixelOffset + dstBandOffsets[k27]] = this.destinationNoDataFloat[k27];
                        }
                    }
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        }
    }

    private void doubleLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiScanlineStride;
        int roiDataLength;
        byte[] roiDataArray;
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        double[][] dstDataArrays = dst.getDoubleDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        double[][] srcDataArrays = src.getDoubleDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        int incxStride = this.incx * srcPixelStride;
        int incx1Stride = this.incx1 * srcPixelStride;
        int incyStride = this.incy * srcScanlineStride;
        int incy1Stride = this.incy1 * srcScanlineStride;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiScanlineStride = roi.getScanlineStride();
        } else {
            roiDataArray = null;
            roiDataLength = 0;
            roiScanlineStride = 0;
        }
        if (this.caseA) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    for (k2 = 0; k2 < dst_num_bands; ++k2) {
                        dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = srcDataArrays[k2][src_pos + bandOffsets[k2]];
                    }
                    if (ifracx < this.ifracdx1) {
                        src_pos += incxStride;
                        ifracx += this.ifracdx;
                    } else {
                        src_pos += incx1Stride;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        src_pos += incyStride;
                        ifracy += this.ifracdy;
                    } else {
                        src_pos += incy1Stride;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint((Point2D)dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    double fracx = (double)s_x - (double)s_ix * 1.0;
                    double fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    ifracx = startPts[1].x;
                    ifracy = startPts[1].y;
                    int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k22;
                        int w;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                        src_pos = posx + posy;
                        int windex = posx / dst_num_bands + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w == 0) {
                            if (this.setDestinationNoData) {
                                for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataDouble[k22];
                                }
                            }
                        } else {
                            for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = srcDataArrays[k22][src_pos + bandOffsets[k22]];
                            }
                        }
                        if (ifracx < this.ifracdx1) {
                            s_ix += this.incx;
                            ifracx += this.ifracdx;
                        } else {
                            s_ix += this.incx1;
                            ifracx -= this.ifracdx1;
                        }
                        if (ifracy < this.ifracdy1) {
                            s_iy += this.incy;
                            ifracy += this.ifracdy;
                        } else {
                            s_iy += this.incy1;
                            ifracy -= this.ifracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            } else {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint((Point2D)dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    double fracx = (double)s_x - (double)s_ix * 1.0;
                    double fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    ifracx = startPts[1].x;
                    ifracy = startPts[1].y;
                    int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int y0;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        src_pos = posx + posy;
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                            int k23;
                            int w = roiIter.getSample(x0, y0, 0) & 0xFF;
                            if (w == 0) {
                                if (this.setDestinationNoData) {
                                    for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                        dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataDouble[k23];
                                    }
                                }
                            } else {
                                for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = srcDataArrays[k23][src_pos + bandOffsets[k23]];
                                }
                            }
                        } else if (this.setDestinationNoData) {
                            for (int k24 = 0; k24 < dst_num_bands; ++k24) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataDouble[k24];
                            }
                        }
                        if (ifracx < this.ifracdx1) {
                            s_ix += this.incx;
                            ifracx += this.ifracdx;
                        } else {
                            s_ix += this.incx1;
                            ifracx -= this.ifracdx1;
                        }
                        if (ifracy < this.ifracdy1) {
                            s_iy += this.incy;
                            ifracy += this.ifracdy;
                        } else {
                            s_iy += this.incy1;
                            ifracy -= this.ifracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int posy = (s_iy - srcRectY) * srcScanlineStride;
                int src_pos = posy + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    for (k2 = 0; k2 < dst_num_bands; ++k2) {
                        double value = srcDataArrays[k2][src_pos + bandOffsets[k2]];
                        if (this.noData.contains(value)) {
                            if (!this.setDestinationNoData) continue;
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                            continue;
                        }
                        dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = value;
                    }
                    if (ifracx < this.ifracdx1) {
                        src_pos += incxStride;
                        ifracx += this.ifracdx;
                    } else {
                        src_pos += incx1Stride;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        src_pos += incyStride;
                        ifracy += this.ifracdy;
                    } else {
                        src_pos += incy1Stride;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.useROIAccessor) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k25;
                    int w;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                    src_pos = posx + posy;
                    int windex = posx / dst_num_bands + posyROI;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w == 0) {
                        if (this.setDestinationNoData) {
                            for (k25 = 0; k25 < dst_num_bands; ++k25) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataDouble[k25];
                            }
                        }
                    } else {
                        for (k25 = 0; k25 < dst_num_bands; ++k25) {
                            double value = srcDataArrays[k25][src_pos + bandOffsets[k25]];
                            if (this.noData.contains(value)) {
                                if (!this.setDestinationNoData) continue;
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataDouble[k25];
                                continue;
                            }
                            dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = value;
                        }
                    }
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint((Point2D)dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                double fracx = (double)s_x - (double)s_ix * 1.0;
                double fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 0, 0, 0);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                ifracx = startPts[1].x;
                ifracy = startPts[1].y;
                int src_pos = (s_iy - srcRectY) * srcScanlineStride + (s_ix - srcRectX) * srcPixelStride;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int y0;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    src_pos = posx + posy;
                    int x0 = src.getX() + posx / srcPixelStride;
                    if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                        int k26;
                        int w = roiIter.getSample(x0, y0, 0) & 0xFF;
                        if (w == 0) {
                            if (this.setDestinationNoData) {
                                for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataDouble[k26];
                                }
                            }
                        } else {
                            for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                double value = srcDataArrays[k26][src_pos + bandOffsets[k26]];
                                if (this.noData.contains(value)) {
                                    if (!this.setDestinationNoData) continue;
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataDouble[k26];
                                    continue;
                                }
                                dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = value;
                            }
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k27 = 0; k27 < dst_num_bands; ++k27) {
                            dstDataArrays[k27][dstPixelOffset + dstBandOffsets[k27]] = this.destinationNoDataDouble[k27];
                        }
                    }
                    if (ifracx < this.ifracdx1) {
                        s_ix += this.incx;
                        ifracx += this.ifracdx;
                    } else {
                        s_ix += this.incx1;
                        ifracx -= this.ifracdx1;
                    }
                    if (ifracy < this.ifracdy1) {
                        s_iy += this.incy;
                        ifracy += this.ifracdy;
                    } else {
                        s_iy += this.incy1;
                        ifracy -= this.ifracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        }
    }
}

