/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.jna;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.tools.Logging;

public abstract class JosmNativeLogHandler
extends Handler {
    private static final BooleanProperty PROP_ERROR = new BooleanProperty("native.log.redirect.error", Boolean.TRUE.booleanValue());
    private static final BooleanProperty PROP_WARN = new BooleanProperty("native.log.redirect.warn", Boolean.TRUE.booleanValue());
    private static final BooleanProperty PROP_INFO = new BooleanProperty("native.log.redirect.info", Boolean.FALSE.booleanValue());
    private static final BooleanProperty PROP_DEBUG = new BooleanProperty("native.log.redirect.debug", Boolean.FALSE.booleanValue());
    private static final BooleanProperty PROP_TRACE = new BooleanProperty("native.log.redirect.trace", Boolean.FALSE.booleanValue());

    protected JosmNativeLogHandler() {
        this.setFormatter(new SimpleFormatter());
    }

    @Override
    public final boolean isLoggable(LogRecord record) {
        return record != null && (JosmNativeLogHandler.isLoggable(record, Logging.LEVEL_ERROR, PROP_ERROR) || JosmNativeLogHandler.isLoggable(record, Logging.LEVEL_WARN, PROP_WARN) || JosmNativeLogHandler.isLoggable(record, Logging.LEVEL_INFO, PROP_INFO) || JosmNativeLogHandler.isLoggable(record, Logging.LEVEL_DEBUG, PROP_DEBUG) || JosmNativeLogHandler.isLoggable(record, Logging.LEVEL_TRACE, PROP_TRACE));
    }

    private static boolean isLoggable(LogRecord record, Level level, BooleanProperty prop) {
        return level.equals(record.getLevel()) && prop.get() != false;
    }

    @Override
    public final void flush() {
    }

    @Override
    public final void close() {
    }
}

