/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui.imageinfo;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.streetside.StreetsideDataListener;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.gui.boilerplate.StreetsideButton;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.WebLinkAction;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideURL;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public final class ImageInfoPanel
extends ToggleDialog
implements StreetsideDataListener,
DataSelectionListener {
    private static final long serialVersionUID = 1898445061036887054L;
    private static final Logger LOGGER = Logger.getLogger(ImageInfoPanel.class.getCanonicalName());
    private static ImageInfoPanel instance;
    private final WebLinkAction imgLinkAction;
    private AbstractProperty.ValueChangeListener<Boolean> imageLinkChangeListener;

    private ImageInfoPanel() {
        super(I18n.tr((String)"Streetside 360\u00b0 image info", (Object[])new Object[0]), "streetside-info", I18n.tr((String)"Displays detail information on the currently selected Streetside image", (Object[])new Object[0]), null, 150);
        SelectionEventManager.getInstance().addSelectionListener((DataSelectionListener)this);
        this.imgLinkAction = new WebLinkAction(I18n.tr((String)"View in browser", (Object[])new Object[0]), null);
        JPanel root = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 5, 0, 5);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        root.add((Component)new JLabel(I18n.tr((String)"Image actions", (Object[])new Object[0])), gbc);
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 0;
        root.add((Component)new StreetsideButton(this.imgLinkAction, true), gbc);
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.gridx = 2;
        gbc.gridy = 1;
        this.createLayout(root, true, null);
        this.selectedImageChanged(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageInfoPanel getInstance() {
        Class<ImageInfoPanel> clazz = ImageInfoPanel.class;
        synchronized (ImageInfoPanel.class) {
            if (instance == null) {
                instance = new ImageInfoPanel();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static synchronized void destroyInstance() {
        instance = null;
    }

    protected void stateChanged() {
        super.stateChanged();
        if (this.isDialogShowing()) {
            StreetsideProperties.IMAGEINFO_HELP_COUNTDOWN.put(Integer.valueOf(0));
        }
    }

    @Override
    public void imagesAdded() {
    }

    @Override
    public synchronized void selectedImageChanged(StreetsideImage oldImage, StreetsideImage newImage) {
        String newImageKey;
        LOGGER.info(() -> String.format("Selected Streetside image changed from %s to %s.", oldImage != null ? oldImage.id() : "\u2039none\u203a", newImage != null ? newImage.id() : "\u2039none\u203a"));
        String string = newImageKey = newImage != null ? newImage.id() : null;
        if (newImageKey != null) {
            this.imageLinkChangeListener = b -> this.imgLinkAction.setURL(StreetsideURL.MainWebsite.browseImage(newImage));
            this.imageLinkChangeListener.valueChanged(null);
            StreetsideProperties.IMAGE_LINK_TO_BLUR_EDITOR.addListener(this.imageLinkChangeListener);
        } else {
            if (this.imageLinkChangeListener != null) {
                StreetsideProperties.IMAGE_LINK_TO_BLUR_EDITOR.removeListener(this.imageLinkChangeListener);
                this.imageLinkChangeListener = null;
            }
            this.imgLinkAction.setURL(null);
        }
    }

    public synchronized void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        Set sel = event.getSelection();
        if (Boolean.TRUE.equals(StreetsideProperties.DEBUGING_ENABLED.get())) {
            LOGGER.log(Logging.LEVEL_DEBUG, "Selection changed. {0} primitives are selected.", sel == null ? 0 : sel.size());
        }
    }
}

