/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cubemap;

import javafx.scene.Group;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;

public class CameraTransformer
extends Group {
    public final Translate t = new Translate();
    private final Translate p = new Translate();
    private final Translate ip = new Translate();
    public final Rotate rx = new Rotate();
    public final Rotate ry = new Rotate();
    private final Rotate rz = new Rotate();
    private final Scale s = new Scale();

    public CameraTransformer() {
        this.rx.setAxis(Rotate.X_AXIS);
        this.ry.setAxis(Rotate.Y_AXIS);
        this.rz.setAxis(Rotate.Z_AXIS);
        this.getTransforms().addAll((Object[])new Transform[]{this.t, this.rz, this.ry, this.rx, this.s});
    }

    public CameraTransformer(RotateOrder rotateOrder) {
        switch (rotateOrder.ordinal()) {
            case 0: {
                this.getTransforms().addAll((Object[])new Transform[]{this.t, this.p, this.rz, this.ry, this.rx, this.s, this.ip});
                break;
            }
            case 1: {
                this.getTransforms().addAll((Object[])new Transform[]{this.t, this.p, this.ry, this.rz, this.rx, this.s, this.ip});
                break;
            }
            case 2: {
                this.getTransforms().addAll((Object[])new Transform[]{this.t, this.p, this.rz, this.rx, this.ry, this.s, this.ip});
                break;
            }
            case 3: {
                this.getTransforms().addAll((Object[])new Transform[]{this.t, this.p, this.rx, this.rz, this.ry, this.s, this.ip});
                break;
            }
            case 4: {
                this.getTransforms().addAll((Object[])new Transform[]{this.t, this.p, this.ry, this.rx, this.rz, this.s, this.ip});
                break;
            }
            case 5: {
                this.getTransforms().addAll((Object[])new Transform[]{this.t, this.p, this.rx, this.ry, this.rz, this.s, this.ip});
            }
        }
    }

    public void setTranslate(double x, double y, double z) {
        this.t.setX(x);
        this.t.setY(y);
        this.t.setZ(z);
    }

    public void setTranslate(double x, double y) {
        this.t.setX(x);
        this.t.setY(y);
    }

    public void setTx(double x) {
        this.t.setX(x);
    }

    public void setTy(double y) {
        this.t.setY(y);
    }

    public void setTz(double z) {
        this.t.setZ(z);
    }

    public void setRotate(double x, double y, double z) {
        this.rx.setAngle(x);
        this.ry.setAngle(y);
        this.rz.setAngle(z);
    }

    public void setRotateX(double x) {
        this.rx.setAngle(x);
    }

    public void setRotateY(double y) {
        this.ry.setAngle(y);
    }

    public void setRotateZ(double z) {
        this.rz.setAngle(z);
    }

    public void setRx(double x) {
        this.rx.setAngle(x);
    }

    public void setRy(double y) {
        this.ry.setAngle(y);
    }

    public void setRz(double z) {
        this.rz.setAngle(z);
    }

    public void setScale(double scaleFactor) {
        this.s.setX(scaleFactor);
        this.s.setY(scaleFactor);
        this.s.setZ(scaleFactor);
    }

    public void setScale(double x, double y, double z) {
        this.s.setX(x);
        this.s.setY(y);
        this.s.setZ(z);
    }

    public void setSx(double x) {
        this.s.setX(x);
    }

    public void setSy(double y) {
        this.s.setY(y);
    }

    public void setSz(double z) {
        this.s.setZ(z);
    }

    public void setPivot(double x, double y, double z) {
        this.p.setX(x);
        this.p.setY(y);
        this.p.setZ(z);
        this.ip.setX(-x);
        this.ip.setY(-y);
        this.ip.setZ(-z);
    }

    public void reset() {
        this.rx.setAngle(0.0);
        this.ry.setAngle(0.0);
        this.rz.setAngle(0.0);
        this.resetTSP();
    }

    public void resetTSP() {
        this.t.setX(0.0);
        this.t.setY(0.0);
        this.t.setZ(0.0);
        this.s.setX(1.0);
        this.s.setY(1.0);
        this.s.setZ(1.0);
        this.p.setX(0.0);
        this.p.setY(0.0);
        this.p.setZ(0.0);
        this.ip.setX(0.0);
        this.ip.setY(0.0);
        this.ip.setZ(0.0);
    }

    public static enum RotateOrder {
        XYZ,
        XZY,
        YXZ,
        YZX,
        ZXY,
        ZYX;

    }
}

