/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.io.download;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.plugins.streetside.StreetsideData;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.io.download.BoundsDownloadRunnable;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideURL;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public final class SequenceDownloadRunnable
extends BoundsDownloadRunnable {
    private static final Logger LOG = Logger.getLogger(BoundsDownloadRunnable.class.getCanonicalName());
    private static final Function<Bounds, URL> URL_GEN = StreetsideURL.APIv3::searchStreetsideImages;
    private final StreetsideData data;
    private String logo;
    private String copyright;

    public SequenceDownloadRunnable(StreetsideData data, Bounds bounds) {
        super(bounds);
        this.data = data;
    }

    @Override
    public void run(URLConnection con) throws IOException {
        if (Thread.interrupted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        try (JsonParser parser = Json.createParser((InputStream)con.getInputStream());){
            if (!parser.hasNext() || parser.next() != JsonParser.Event.START_OBJECT) {
                throw new IllegalStateException("Expected an object");
            }
            this.parseJson(parser);
            long endTime = System.currentTimeMillis();
            LOG.log(Level.INFO, "Successfully loaded {0} Microsoft Streetside images in {1} seconds.", new Object[]{this.data.getImages().size(), (endTime - startTime) / 1000L});
        }
        catch (DateTimeParseException dateTimeParseException) {
            BugReport.intercept((Throwable)dateTimeParseException).put("url", (Object)con.getURL()).warn();
        }
    }

    void parseJson(JsonParser parser) {
        while (parser.hasNext()) {
            if (Objects.requireNonNull(parser.next()) != JsonParser.Event.KEY_NAME) continue;
            switch (parser.getString()) {
                case "errorDetails": {
                    SequenceDownloadRunnable.parseErrorDetails(parser);
                    break;
                }
                case "resourceSets": {
                    this.parseResourceSets(parser);
                    break;
                }
                case "brandLogoUri": {
                    this.parseBrandLogoUri(parser);
                    break;
                }
                case "copyright": {
                    this.parseCopyright(parser);
                    break;
                }
            }
        }
    }

    private static void parseErrorDetails(JsonParser parser) {
        if (parser.next() == JsonParser.Event.START_ARRAY) {
            StringBuilder errors = new StringBuilder();
            while (parser.next() != JsonParser.Event.END_ARRAY) {
                if (parser.currentEvent() != JsonParser.Event.VALUE_STRING) continue;
                errors.append(parser.getString()).append('\n');
            }
            throw new JosmRuntimeException(errors.toString());
        }
    }

    private void parseResourceSets(JsonParser parser) {
        if (parser.next() == JsonParser.Event.START_ARRAY) {
            while (parser.hasNext() && parser.next() == JsonParser.Event.START_OBJECT) {
                while (parser.hasNext() && parser.currentEvent() != JsonParser.Event.END_OBJECT) {
                    if (parser.next() != JsonParser.Event.KEY_NAME || !"resources".equals(parser.getString())) continue;
                    parser.next();
                    ArrayList<StreetsideImage> bubbleImages = new ArrayList<StreetsideImage>();
                    this.parseResource(parser, bubbleImages);
                    this.data.addAll(bubbleImages, true);
                }
            }
        }
    }

    private void parseBrandLogoUri(JsonParser parser) {
        if (parser.next() == JsonParser.Event.VALUE_STRING) {
            this.logo = parser.getString();
        }
    }

    private void parseCopyright(JsonParser parser) {
        if (parser.next() == JsonParser.Event.VALUE_STRING) {
            this.copyright = parser.getString();
        }
    }

    private void parseResource(JsonParser parser, List<StreetsideImage> bubbleImages) {
        while (parser.hasNext() && parser.next() == JsonParser.Event.START_OBJECT) {
            JsonObject node = parser.getObject();
            if (node.get((Object)"imageUrl") != null && node.get((Object)"lat") != null && node.get((Object)"lon") != null) {
                String id = node.getString("imageUrl");
                double lat = node.getJsonNumber("lat").doubleValue();
                double lon = node.getJsonNumber("lon").doubleValue();
                double heading = node.getJsonNumber("he").doubleValue();
                double pitch = node.containsKey((Object)"pi") ? node.getJsonNumber("pi").doubleValue() : Double.NaN;
                double roll = node.containsKey((Object)"ro") ? node.getJsonNumber("ro").doubleValue() : Double.NaN;
                Instant vintageStart = LocalDate.parse(node.getString("vintageStart").replace("GMT", "UTC"), DateTimeFormatter.ofPattern("dd LLL yyyy zzz")).atStartOfDay().toInstant(ZoneOffset.UTC);
                Instant vintageEnd = LocalDate.parse(node.getString("vintageStart").replace("GMT", "UTC"), DateTimeFormatter.ofPattern("dd LLL yyyy zzz")).atTime(LocalTime.MAX).toInstant(ZoneOffset.UTC);
                List<String> imageUrlSubdomains = node.getJsonArray("imageUrlSubdomains").getValuesAs(JsonString.class).stream().map(JsonString::getString).toList();
                int zoomMax = node.getInt("zoomMax");
                int zoomMin = node.getInt("zoomMin");
                int imageHeight = node.getInt("imageHeight");
                int imageWidth = node.getInt("imageWidth");
                StreetsideImage image = new StreetsideImage(id, lat, lon, heading, pitch, roll, vintageStart, vintageEnd, this.logo, this.copyright, zoomMin, zoomMax, imageHeight, imageWidth, imageUrlSubdomains);
                bubbleImages.add(image);
                LOG.info(() -> "Added image with id <" + image.id() + ">");
                if (!Boolean.TRUE.equals(StreetsideProperties.PREDOWNLOAD_CUBEMAPS.get())) continue;
                this.data.downloadSurroundingCubemaps(image);
                continue;
            }
            LOG.info(() -> MessageFormat.format("Unparsable JSON node object: {0}", node));
        }
    }

    @Override
    protected Function<Bounds, URL> getUrlGenerator() {
        return URL_GEN;
    }
}

