/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cache;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.apache.commons.jcs3.access.CacheAccess;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.tools.Logging;

public final class Caches {
    private static final Logger LOGGER = Logger.getLogger(Caches.class.getCanonicalName());

    private Caches() {
    }

    public static File getCacheDirectory() {
        File file = new File(Preferences.main().getPluginsDirectory().getPath() + "/MicrosoftStreetside/cache");
        if (!file.exists() && !file.mkdirs()) {
            Logging.error((String)"Failed to make directory: {0}", (Object[])new Object[]{file});
        }
        return file;
    }

    public static class MapObjectIconCache
    extends CacheProxy<String, ImageIcon> {
        private static CacheProxy<String, ImageIcon> instance;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CacheProxy<String, ImageIcon> getInstance() {
            Class<MapObjectIconCache> clazz = MapObjectIconCache.class;
            synchronized (MapObjectIconCache.class) {
                if (instance == null) {
                    instance = new MapObjectIconCache();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        @Override
        protected CacheAccess<String, ImageIcon> createNewCache() throws IOException {
            return JCSCacheManager.getCache((String)"streetsideObjectIcons", (int)100, (int)1000, (String)Caches.getCacheDirectory().getPath());
        }
    }

    public static class CubemapCache {
        private static CubemapCache instance;
        private final CacheAccess<String, BufferedImageCacheEntry> cache;

        public CubemapCache() {
            CacheAccess c;
            try {
                c = JCSCacheManager.getCache((String)"streetside", (int)10, (int)10000, (String)Caches.getCacheDirectory().getPath());
            }
            catch (Exception e) {
                LOGGER.log(Logging.LEVEL_WARN, "Could not initialize the Streetside cubemap cache.", e);
                c = null;
            }
            this.cache = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CubemapCache getInstance() {
            Class<CubemapCache> clazz = CubemapCache.class;
            synchronized (CubemapCache.class) {
                if (instance == null) {
                    instance = new CubemapCache();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        public CacheAccess<String, BufferedImageCacheEntry> getCache() {
            return this.cache;
        }
    }

    public static class ImageCache {
        private static ImageCache instance;
        private final CacheAccess<String, BufferedImageCacheEntry> cache;

        public ImageCache() {
            CacheAccess c;
            try {
                c = JCSCacheManager.getCache((String)"streetside", (int)10, (int)10000, (String)Caches.getCacheDirectory().getPath());
            }
            catch (Exception e) {
                Logging.log((Level)Logging.LEVEL_WARN, (String)"Could not initialize the Streetside image cache.", (Throwable)e);
                c = null;
            }
            this.cache = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ImageCache getInstance() {
            Class<ImageCache> clazz = ImageCache.class;
            synchronized (ImageCache.class) {
                if (instance == null) {
                    instance = new ImageCache();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        public CacheAccess<String, BufferedImageCacheEntry> getCache() {
            return this.cache;
        }
    }

    public static abstract class CacheProxy<K, V extends Serializable> {
        private final CacheAccess<K, V> cache;

        protected CacheProxy() {
            CacheAccess<K, V> c;
            try {
                c = this.createNewCache();
            }
            catch (IOException e) {
                LOGGER.log(Logging.LEVEL_WARN, e, () -> "Could not initialize cache for " + this.getClass().getName());
                c = null;
            }
            this.cache = c;
        }

        protected abstract CacheAccess<K, V> createNewCache() throws IOException;

        public V get(K key) {
            return (V)(this.cache == null ? null : (Serializable)this.cache.get(key));
        }

        public void put(K key, V value) {
            if (this.cache != null) {
                this.cache.put(key, value);
            }
        }
    }
}

