/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.api;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonStructure;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public final class CadastreAPI {
    private static final StringProperty API_ENDPOINT = new StringProperty("cadastrefr.api.endpoint", "https://geo.api.gouv.fr/cadastre");

    private CadastreAPI() {
    }

    public static Set<String> getSheets(Bounds bounds) throws IOException {
        return CadastreAPI.getSheets(bounds.getMinLon(), bounds.getMinLat(), bounds.getMaxLon(), bounds.getMaxLat());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<String> getSheets(double minlon, double minlat, double maxlon, double maxlat) throws IOException {
        URL url = URI.create(API_ENDPOINT.get() + "/feuilles?bbox=" + String.join((CharSequence)",", Double.toString(minlon), Double.toString(minlat), Double.toString(maxlon), Double.toString(maxlat))).toURL();
        try {
            HttpClient.Response response = HttpClient.create((URL)url).connect();
            if (response.getResponseCode() >= 400) {
                throw new IOException(I18n.tr((String)"Cadastre GeoAPI returned HTTP error {0}. This is not a JOSM bug.\nPlease report the issue to {1}, {2} or {3}", (Object[])new Object[]{response.getResponseCode(), "https://github.com/etalab/geo.data.gouv.fr/issues", "https://twitter.com/geodatagouv", "geo@data.gouv.fr"}));
            }
            try (JsonReader reader = Json.createReader((Reader)response.getContentReader());){
                JsonStructure json = reader.read();
                if (json instanceof JsonArray) {
                    Set<String> set = json.asJsonArray().stream().map(x -> x.asJsonObject().getString("id")).collect(Collectors.toSet());
                    return set;
                }
                JsonObject obj = json.asJsonObject();
                throw new IOException((Throwable)new OsmApiException(obj.getInt("code"), null, obj.getString("message"), url.toExternalForm()));
            }
        }
        catch (MalformedURLException e) {
            throw new JosmRuntimeException((Throwable)e);
        }
    }
}

