/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.opendata.core.licenses.License;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class ViewLicenseDialog
extends ExtendedDialog {
    private final License license;
    private final JEditorPane htmlPane;
    private boolean summary;

    public ViewLicenseDialog(License license) throws IOException {
        this(license, (Component)MainApplication.getMainFrame(), I18n.tr((String)"License", (Object[])new Object[0]), new String[]{I18n.tr((String)"OK", (Object[])new Object[0]), "", I18n.tr((String)"Cancel", (Object[])new Object[0])});
    }

    public ViewLicenseDialog(License license, Component parent, String title, String[] buttonTexts) throws IOException {
        super(parent, title, buttonTexts);
        this.license = license;
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        if (license.getSummaryURL() != null) {
            this.htmlPane.setPage(license.getSummaryURL());
            this.summary = true;
        } else {
            this.htmlPane.setPage(license.getURL());
            this.summary = false;
        }
        JScrollPane scrollPane = new JScrollPane(this.htmlPane);
        scrollPane.setPreferredSize(new Dimension(800, 600));
        this.setButtonIcons(new Icon[]{ImageProvider.get((String)"ok"), ImageProvider.get((String)"agreement24"), ImageProvider.get((String)"cancel")});
        this.setToolTipTexts(new String[]{null, I18n.tr((String)"View the full text of this license", (Object[])new Object[0]), null});
        if (license.getIcon() != null) {
            this.setIcon(license.getIcon());
        } else {
            this.setIcon(1);
        }
        this.setCancelButton(new Integer[]{3});
        this.setMinimumSize(new Dimension(300, 200));
        this.setContent(scrollPane, false);
    }

    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        if (buttonIndex == 1) {
            try {
                if (this.summary) {
                    ((JButton)this.buttons.get(1)).setText(I18n.tr((String)"View summary", (Object[])new Object[0]));
                    this.htmlPane.setPage(this.license.getURL());
                } else {
                    ((JButton)this.buttons.get(1)).setText(I18n.tr((String)"View full text", (Object[])new Object[0]));
                    this.htmlPane.setPage(this.license.getSummaryURL());
                }
            }
            catch (IOException e) {
                Logging.error((Throwable)e);
            }
            this.summary = !this.summary;
        } else {
            super.buttonAction(buttonIndex, evt);
        }
    }

    public void setupDialog() {
        super.setupDialog();
        ((JButton)this.buttons.get(1)).setEnabled(this.license.getSummaryURL() != null && this.license.getURL() != null);
        if (this.summary) {
            ((JButton)this.buttons.get(1)).setText(I18n.tr((String)"View full text", (Object[])new Object[0]));
        } else {
            ((JButton)this.buttons.get(1)).setText(I18n.tr((String)"View summary", (Object[])new Object[0]));
        }
    }
}

