/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.gui;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.plugins.opendata.core.gui.OdPreferenceSetting;
import org.openstreetmap.josm.plugins.opendata.core.layers.OdDataLayer;
import org.openstreetmap.josm.plugins.opendata.core.layers.OdLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class OdDialog
extends ToggleDialog
implements MainLayerManager.ActiveLayerChangeListener {
    private final SideButton downloadButton = new SideButton((Action)((Object)new DownloadAction()));
    private final SideButton diffButton = new SideButton((Action)((Object)new DiffAction()));
    private final SideButton toolsButton = new SideButton((Action)((Object)new ToolsAction()));
    private final List<SideButton> buttons = Arrays.asList(new SideButton((Action)((Object)new SelectAction())), this.downloadButton, this.diffButton, this.toolsButton);
    private final TreeModel treeModel;
    private OdDataLayer dataLayer;

    public OdDialog() {
        super("OpenData", "o24.png", I18n.tr((String)"Open the OpenData window.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"subwindow:opendata", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{"OpenData"}), (int)65, (int)5010), 150, false, OdPreferenceSetting.class);
        this.toolsButton.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (MainApplication.getLayerManager().getEditLayer() instanceof OdLayer) {
                    JPopupMenu popup = new JPopupMenu();
                    for (JosmAction tool : ((OdDialog)OdDialog.this).dataLayer.handler.getTools()) {
                        popup.add((Action)tool);
                    }
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.disableAllButtons();
        this.treeModel = new DefaultTreeModel(null);
        this.dataLayer = null;
        this.createLayout(new JTree(this.treeModel), true, this.buttons);
        MainApplication.getLayerManager().addActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
    }

    private void disableAllButtons() {
        for (SideButton button : this.buttons) {
            button.setEnabled(false);
        }
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        Layer newLayer = MainApplication.getLayerManager().getActiveLayer();
        this.dataLayer = newLayer instanceof OdLayer ? ((OdLayer)newLayer).getDataLayer() : null;
        if (this.dataLayer != null) {
            if (this.dataLayer.osmLayer == null) {
                this.downloadButton.setEnabled(true);
            }
            this.toolsButton.setEnabled(this.dataLayer.handler != null && !this.dataLayer.handler.getTools().isEmpty());
        } else {
            this.disableAllButtons();
        }
    }

    public void destroy() {
        super.destroy();
        MainApplication.getLayerManager().removeActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
    }

    public OdDataLayer getDataLayer() {
        return this.dataLayer;
    }

    private static class ToolsAction
    extends JosmAction {
        ToolsAction() {
            super(I18n.marktr((String)"Tools"), "dialogs/utils", I18n.tr((String)"Open tools menu for this data.", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private static class DiffAction
    extends JosmAction {
        DiffAction() {
            super(I18n.marktr((String)"Diff"), "dialogs/diff", I18n.tr((String)"Perform diff between current data set and existing OSM data.", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private static class SelectAction
    extends JosmAction {
        SelectAction() {
            super(I18n.marktr((String)"Select"), "dialogs/select", I18n.tr((String)"Set the selected elements on the map to the selected items in the list above.", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private class DownloadAction
    extends JosmAction {
        DownloadAction() {
            super(I18n.marktr((String)"Download"), "download", I18n.tr((String)"Download OSM data corresponding to the current data set.", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent e) {
            if (MainApplication.getLayerManager().getEditLayer() instanceof OdLayer) {
                OdDialog.this.dataLayer.downloadOsmData();
                OdDialog.this.diffButton.setEnabled(((OdDialog)OdDialog.this).dataLayer.osmLayer != null);
            }
        }
    }
}

