/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.openstreetmap.josm.gui.util.ChangeNotifier;
import org.openstreetmap.josm.plugins.opendata.OdPlugin;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleException;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleInformation;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;

public class ModulePreferencesModel
extends ChangeNotifier {
    private final ArrayList<ModuleInformation> availableModules = new ArrayList();
    private final ArrayList<ModuleInformation> displayedModules = new ArrayList();
    private final HashMap<ModuleInformation, Boolean> selectedModulesMap = new HashMap();
    private final Set<String> pendingDownloads = new HashSet<String>();
    private String filterExpression;
    private final Set<String> currentActiveModules = new HashSet<String>(this.getModules(Collections.emptyList()));

    protected List<String> getModules(List<String> def) {
        return Config.getPref().getList("opendata.modules", def);
    }

    public void filterDisplayedModules(String filter) {
        if (filter == null) {
            this.displayedModules.clear();
            this.displayedModules.addAll(this.availableModules);
            this.filterExpression = null;
            return;
        }
        this.displayedModules.clear();
        for (ModuleInformation pi : this.availableModules) {
            if (!pi.matches(filter)) continue;
            this.displayedModules.add(pi);
        }
        this.filterExpression = filter;
        this.fireStateChanged();
    }

    public void setAvailableModules(Collection<ModuleInformation> available) {
        this.availableModules.clear();
        if (available != null) {
            this.availableModules.addAll(available);
        }
        this.sort();
        this.filterDisplayedModules(this.filterExpression);
        HashSet<String> activeModules = new HashSet<String>(this.getModules(Collections.emptyList()));
        for (ModuleInformation pi : this.availableModules) {
            if (this.selectedModulesMap.get(pi) != null || !activeModules.contains(pi.name)) continue;
            this.selectedModulesMap.put(pi, true);
        }
        this.fireStateChanged();
    }

    protected void updateAvailableModule(ModuleInformation other) {
        if (other == null) {
            return;
        }
        ModuleInformation pi = this.getModuleInformation(other.name);
        if (pi == null) {
            this.availableModules.add(other);
            return;
        }
        pi.updateFromModuleSite(other);
    }

    public void updateAvailableModules(Collection<ModuleInformation> fromModuleSite) {
        for (ModuleInformation other : fromModuleSite) {
            this.updateAvailableModule(other);
        }
        this.sort();
        this.filterDisplayedModules(this.filterExpression);
        HashSet<String> activeModules = new HashSet<String>(this.getModules(Collections.emptyList()));
        for (ModuleInformation pi : this.availableModules) {
            if (this.selectedModulesMap.get(pi) != null || !activeModules.contains(pi.name)) continue;
            this.selectedModulesMap.put(pi, true);
        }
        this.fireStateChanged();
    }

    public List<ModuleInformation> getSelectedModules() {
        LinkedList<ModuleInformation> ret = new LinkedList<ModuleInformation>();
        for (ModuleInformation pi : this.availableModules) {
            if (this.selectedModulesMap.get(pi) == null || !Boolean.TRUE.equals(this.selectedModulesMap.get(pi))) continue;
            ret.add(pi);
        }
        return ret;
    }

    public Set<String> getSelectedModuleNames() {
        HashSet<String> ret = new HashSet<String>();
        for (ModuleInformation pi : this.getSelectedModules()) {
            ret.add(pi.name);
        }
        return ret;
    }

    protected void sort() {
        this.availableModules.sort((o1, o2) -> {
            String n1 = o1.getName() == null ? "" : o1.getName().toLowerCase(Locale.ROOT);
            String n2 = o2.getName() == null ? "" : o2.getName().toLowerCase(Locale.ROOT);
            return n1.compareTo(n2);
        });
    }

    public List<ModuleInformation> getDisplayedModules() {
        return this.displayedModules;
    }

    public List<ModuleInformation> getModulesScheduledForUpdateOrDownload() {
        ArrayList<ModuleInformation> ret = new ArrayList<ModuleInformation>();
        for (String module : this.pendingDownloads) {
            ModuleInformation pi = this.getModuleInformation(module);
            if (pi == null) continue;
            ret.add(pi);
        }
        return ret;
    }

    public void setModuleSelected(String name, boolean selected) {
        ModuleInformation pi = this.getModuleInformation(name);
        if (pi != null) {
            this.selectedModulesMap.put(pi, selected);
            if (pi.isUpdateRequired()) {
                this.pendingDownloads.add(pi.name);
            }
        }
        if (!selected) {
            this.pendingDownloads.remove(name);
        }
    }

    public void clearPendingModules(Collection<ModuleInformation> modules) {
        if (modules == null || modules.isEmpty()) {
            return;
        }
        for (ModuleInformation pi : modules) {
            this.pendingDownloads.remove(pi.name);
        }
    }

    public ModuleInformation getModuleInformation(String name) {
        for (ModuleInformation pi : this.availableModules) {
            if (pi.getName() == null || !pi.getName().equals(name)) continue;
            return pi;
        }
        return null;
    }

    public boolean isSelectedModule(String name) {
        ModuleInformation pi = this.getModuleInformation(name);
        if (pi == null) {
            return false;
        }
        if (this.selectedModulesMap.get(pi) == null) {
            return false;
        }
        return this.selectedModulesMap.get(pi);
    }

    public boolean isActiveModulesChanged() {
        Set<String> newActiveModules = this.getSelectedModuleNames();
        return !newActiveModules.equals(this.currentActiveModules);
    }

    public void refreshLocalModuleVersion(Collection<ModuleInformation> modules) {
        if (modules == null) {
            return;
        }
        File moduleDir = OdPlugin.getInstance().getModulesDirectory();
        for (ModuleInformation pi : modules) {
            File downloadedModuleFile = new File(moduleDir, pi.name + ".jar.new");
            if (!(downloadedModuleFile.exists() && downloadedModuleFile.canRead() || (downloadedModuleFile = new File(moduleDir, pi.name + ".jar")).exists() && downloadedModuleFile.canRead())) continue;
            try {
                ModuleInformation newinfo = new ModuleInformation(downloadedModuleFile, pi.name);
                ModuleInformation oldinfo = this.getModuleInformation(pi.name);
                if (oldinfo == null) continue;
                oldinfo.localversion = newinfo.version;
            }
            catch (ModuleException e) {
                Logging.debug((Throwable)e);
            }
        }
    }
}

