/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io;

import java.util.regex.Pattern;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;

public class ProjectionPatterns {
    private final Pattern xPattern;
    private final Pattern yPattern;
    private final Pattern xyPattern;
    private final Projection projection;

    public ProjectionPatterns(Pattern xPattern, Pattern yPattern, Pattern xyPattern, Projection projection) {
        this.xPattern = xPattern;
        this.yPattern = yPattern;
        this.xyPattern = xyPattern;
        this.projection = projection;
        OdConstants.PROJECTIONS.add(this);
    }

    public ProjectionPatterns(String proj, Projection projection) {
        this(ProjectionPatterns.getCoordinatePattern("X|LON|.*_LON|LONGI|.*LONGITUDE.*|EASTING", proj), ProjectionPatterns.getCoordinatePattern("Y|LAT|.*_LAT|LATI|.*LATITUDE.*|NORTHING", proj), ProjectionPatterns.getCoordinatePattern("POINT", proj), projection);
    }

    public ProjectionPatterns(String proj) {
        this(proj, null);
    }

    public final Pattern getXPattern() {
        return this.xPattern;
    }

    public final Pattern getYPattern() {
        return this.yPattern;
    }

    public final Pattern getXYPattern() {
        return this.xyPattern;
    }

    public Projection getProjection(String xFieldName, String yFieldName) {
        return this.getProjection();
    }

    public final Projection getProjection() {
        return this.projection;
    }

    public static Pattern getCoordinatePattern(String coor, String proj) {
        if (proj != null && !proj.isEmpty()) {
            return Pattern.compile("(?:.*(?:" + coor + ").*(?:" + proj + ").*)|(?:.*(" + proj + ").*(?:" + coor + ").*)", 2);
        }
        return Pattern.compile(coor, 2);
    }

    public String toString() {
        return "[xPattern=" + this.xPattern + ", yPattern=" + this.yPattern + ", xyPattern=" + this.xyPattern + ", projection=" + this.projection + ']';
    }
}

