/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import livegps.AppendableGpxTrackSegment;
import livegps.LiveGpsData;
import livegps.LiveGpsDrawHelper;
import livegps.SingleSegmentGpxTrack;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public class LiveGpsLayer
extends GpxLayer
implements PropertyChangeListener {
    public static final String LAYER_NAME = I18n.tr((String)"LiveGPS layer", (Object[])new Object[0]);
    private int refreshInterval;
    private int centerInterval;
    private double centerFactor;
    private long lastRedraw = 0L;
    private long lastCenter = 0L;
    LiveGpsData lastData;
    LatLon lastPos;
    WayPoint lastPoint;
    private final AppendableGpxTrackSegment trackSegment;
    private final GpxData gpxData;
    boolean autocenter;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public LiveGpsLayer(GpxData data) {
        super(data, LAYER_NAME);
        this.trackSegment = new AppendableGpxTrackSegment();
        HashMap<String, Object> attr = new HashMap<String, Object>();
        attr.put("desc", "josm live gps");
        SingleSegmentGpxTrack trackBeingWritten = new SingleSegmentGpxTrack(this.trackSegment, attr);
        data.tracks.add(trackBeingWritten);
        this.gpxData = data;
        this.initIntervals();
    }

    protected MapViewPaintable.LayerPainter createMapViewPainter(MapViewPaintable.MapViewEvent event) {
        return new LiveGpsDrawHelper(this);
    }

    void setCurrentPosition(double lat, double lon, WayPoint wp) {
        LatLon thisPos = new LatLon(lat, lon);
        if (this.lastPos != null && thisPos.equalsEpsilon((ILatLon)this.lastPos, 1.0E-7) && Config.getPref().getBoolean("livegps.positions.all", false)) {
            return;
        }
        this.lastPos = thisPos;
        if (wp != null) {
            this.lastPoint = wp;
        } else {
            this.lastPoint = new WayPoint(thisPos);
            this.lastPoint.attr.put("time", this.dateFormat.format(new Date()));
        }
        this.trackSegment.addWaypoint(this.lastPoint);
        this.gpxData.invalidate();
        if (this.autocenter) {
            this.conditionalCenter(thisPos);
        }
    }

    public void center() {
        if (this.lastPoint != null) {
            MainApplication.getMap().mapView.zoomTo(this.lastPoint.getCoor());
        }
    }

    public void conditionalCenter(LatLon Pos) {
        Point2D P = MainApplication.getMap().mapView.getPoint2D(Pos);
        Rectangle rv = MainApplication.getMap().mapView.getBounds(null);
        Date date = new Date();
        long current = date.getTime();
        rv.grow(-((int)(rv.getHeight() * this.centerFactor)), -((int)(rv.getWidth() * this.centerFactor)));
        if (!rv.contains(P) || this.centerInterval > 0 && current - this.lastCenter >= (long)this.centerInterval) {
            MainApplication.getMap().mapView.zoomTo(Pos);
            this.lastCenter = current;
        }
    }

    public void setAutoCenter(boolean ac) {
        this.autocenter = ac;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isVisible()) {
            return;
        }
        if ("gpsdata".equals(evt.getPropertyName())) {
            this.lastData = (LiveGpsData)evt.getNewValue();
            if (this.lastData.isFix()) {
                this.setCurrentPosition(this.lastData.getLatitude(), this.lastData.getLongitude(), this.lastData.getWaypoint());
                if (this.allowRedraw()) {
                    this.setFilterStateChanged();
                }
            }
        }
    }

    private boolean allowRedraw() {
        Date date = new Date();
        long current = date.getTime();
        if (current - this.lastRedraw >= (long)this.refreshInterval) {
            this.lastRedraw = current;
            return true;
        }
        return false;
    }

    private void initIntervals() {
        this.refreshInterval = Config.getPref().getInt("livegps.refresh_interval_msec", 250);
        this.centerInterval = Config.getPref().getInt("livegps.center_interval_msec", 5000);
        this.centerFactor = Config.getPref().getInt("livegps.center_factor", 80);
        if (this.centerFactor <= 1.0 || this.centerFactor >= 99.0) {
            this.centerFactor = 80.0;
        }
        Config.getPref().putInt("livegps.refresh_interval_msec", this.refreshInterval);
        Config.getPref().putInt("livegps.center_interval_msec", this.centerInterval);
        Config.getPref().putInt("livegps.center_factor", (int)this.centerFactor);
        this.centerFactor = (100.0 - this.centerFactor) / 2.0 / 100.0;
    }
}

